/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ObjectSupplier;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CropEntryConfigData {
    private final String cropEntryName;
    private final boolean enabled;
    private final EnumTemperature temperature;
    private final DropEntry primarySeed;
    private final List<Supplier<Item>> seeds;
    private final List<DropEntry> drops;
    private final List<ParentPair> parents;
    private final Supplier<Block> soil;

    private CropEntryConfigData(String cropEntryName, boolean enabled, EnumTemperature temperature, DropEntry primarySeed, List<Supplier<Item>> seeds, List<DropEntry> drops, List<ParentPair> parents, Supplier<Block> soil) {
        this.cropEntryName = cropEntryName;
        this.enabled = enabled;
        this.temperature = temperature;
        this.primarySeed = primarySeed;
        this.seeds = ImmutableList.copyOf(seeds);
        this.drops = ImmutableList.copyOf(drops);
        this.parents = ImmutableList.copyOf(parents);
        this.soil = soil;
    }

    public String getCropEntryName() {
        return this.cropEntryName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public DropEntry getPrimarySeed() {
        return this.primarySeed;
    }

    public List<Supplier<Item>> getSeeds() {
        return this.seeds;
    }

    public List<DropEntry> getDrops() {
        return this.drops;
    }

    public List<ParentPair> getParents() {
        return this.parents;
    }

    public Supplier<Block> getSoil() {
        return this.soil;
    }

    public static CropEntryConfigData create(String cropEntryName, CropConfiguration config) {
        return new CropEntryConfigData(cropEntryName, config.isEnabled(), config.getTemperature(), config.getPrimarySeed(), config.getSeeds(), config.getDrops(), config.getParents(), config.getSoil());
    }

    public static class Serializer
    implements JsonSerializer<CropEntryConfigData>,
    JsonDeserializer<CropEntryConfigData> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public JsonElement serialize(CropEntryConfigData data, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("crop", data.getCropEntryName());
            obj.addProperty("enabled", Boolean.valueOf(data.isEnabled()));
            obj.addProperty("temperature", data.getTemperature().name().toLowerCase(Locale.ROOT));
            obj.add("primary_seed", context.serialize((Object)data.getPrimarySeed(), DropEntry.class));
            JsonArray seeds = new JsonArray();
            data.getSeeds().stream().map(Supplier::get).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).map(JsonPrimitive::new).forEach(arg_0 -> ((JsonArray)seeds).add(arg_0));
            obj.add("seeds", (JsonElement)seeds);
            JsonArray drops = new JsonArray();
            data.getDrops().stream().map(entry -> context.serialize(entry, DropEntry.class)).forEach(arg_0 -> ((JsonArray)drops).add(arg_0));
            obj.add("drops", (JsonElement)drops);
            JsonArray parents = new JsonArray();
            data.getParents().stream().map(pair -> context.serialize(pair, ParentPair.class)).forEach(arg_0 -> ((JsonArray)parents).add(arg_0));
            obj.add("parents", (JsonElement)parents);
            JsonObject soil = new JsonObject();
            soil.addProperty("block", data.getSoil().get().getRegistryName().toString());
            obj.add("soil", (JsonElement)soil);
            return obj;
        }

        public CropEntryConfigData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String name = JSONUtils.func_151200_h((JsonObject)obj, (String)"crop");
            boolean enabled = JSONUtils.func_151212_i((JsonObject)obj, (String)"enabled");
            EnumTemperature temp = this.getTemperature(obj.get("temperature"));
            DropEntry primarySeed = (DropEntry)context.deserialize(obj.get("primary_seed"), DropEntry.class);
            List<Supplier<Item>> seeds = this.getSeeds(obj.get("seeds"));
            List<DropEntry> drops = this.getDropEntries(obj.get("drops"), context);
            List<ParentPair> parents = this.getParentPairs(obj.get("parents"), context);
            Supplier<Block> soil = this.getSoil(obj.get("soil"));
            return new CropEntryConfigData(name, enabled, temp, primarySeed, seeds, drops, parents, soil);
        }

        public void write(CropEntryConfigData data, PacketBuffer buf) {
            buf.func_211400_a(data.getCropEntryName(), 64);
            buf.writeBoolean(data.isEnabled());
            buf.func_179249_a((Enum)data.getTemperature());
            DropEntry.Serializer.INSTANCE.write(data.primarySeed, buf);
            buf.writeShort(data.getSeeds().size());
            data.getSeeds().stream().map(Supplier::get).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).forEach(arg_0 -> ((PacketBuffer)buf).func_192572_a(arg_0));
            buf.writeShort(data.getParents().size());
            data.getDrops().forEach(drop -> DropEntry.Serializer.INSTANCE.write((DropEntry)drop, buf));
            buf.writeShort(data.getParents().size());
            data.getParents().forEach(pair -> ParentPair.Serializer.INSTANCE.write((ParentPair)pair, buf));
            buf.func_192572_a(data.getSoil().get().getRegistryName());
        }

        public CropEntryConfigData read(PacketBuffer buf) {
            String cropEntryName = buf.func_150789_c(64);
            boolean enabled = buf.readBoolean();
            EnumTemperature temperature = (EnumTemperature)buf.func_179257_a(EnumTemperature.class);
            DropEntry primarySeed = DropEntry.Serializer.INSTANCE.read(buf);
            LinkedList seeds = new LinkedList();
            int seedsAmount = buf.readShort();
            for (int i = 0; i < seedsAmount; ++i) {
                seeds.add(ObjectSupplier.of(buf.func_192575_l(), ForgeRegistries.ITEMS));
            }
            int dropsAmount = buf.readShort();
            LinkedList<DropEntry> drops = new LinkedList<DropEntry>();
            for (int i = 0; i < dropsAmount; ++i) {
                drops.add(DropEntry.Serializer.INSTANCE.read(buf));
            }
            LinkedList<ParentPair> parentPairs = new LinkedList<ParentPair>();
            int parentsAmount = buf.readShort();
            for (int i = 0; i < parentsAmount; ++i) {
                parentPairs.add(ParentPair.Serializer.INSTANCE.read(buf));
            }
            ObjectSupplier soil = ObjectSupplier.of(buf.func_192575_l(), ForgeRegistries.BLOCKS);
            return new CropEntryConfigData(cropEntryName, enabled, temperature, primarySeed, seeds, drops, parentPairs, soil);
        }

        private EnumTemperature getTemperature(JsonElement element) {
            String tempStr = JSONUtils.func_151206_a((JsonElement)element, (String)"temperature").toUpperCase(Locale.ROOT);
            EnumTemperature temp = EnumTemperature.byName(tempStr);
            if (temp == null) {
                throw new JsonSyntaxException("Expected temperature to have a value of " + Arrays.toString((Object[])EnumTemperature.values()).toLowerCase(Locale.ROOT) + ", got " + JSONUtils.func_151222_d((JsonElement)element));
            }
            return temp;
        }

        private List<DropEntry> getDropEntries(JsonElement dropsElement, JsonDeserializationContext context) {
            ArrayList<DropEntry> drops = new ArrayList<DropEntry>();
            if (dropsElement.isJsonPrimitive() || dropsElement.isJsonObject()) {
                drops.add((DropEntry)context.deserialize(dropsElement, DropEntry.class));
            } else if (dropsElement.isJsonArray()) {
                dropsElement.getAsJsonArray().forEach(el -> drops.add((DropEntry)context.deserialize(el, DropEntry.class)));
            } else {
                throw new JsonSyntaxException("Expected drops to be a string, JsonObject or JsonArray, was " + JSONUtils.func_151222_d((JsonElement)dropsElement));
            }
            return drops;
        }

        private List<ParentPair> getParentPairs(JsonElement pairElement, JsonDeserializationContext context) {
            ArrayList<ParentPair> parents = new ArrayList<ParentPair>();
            if (pairElement.isJsonObject()) {
                parents.add((ParentPair)context.deserialize(pairElement, ParentPair.class));
            } else if (pairElement.isJsonArray()) {
                JsonArray array = pairElement.getAsJsonArray();
                array.forEach(el -> parents.add((ParentPair)context.deserialize(el, ParentPair.class)));
            } else {
                throw new JsonSyntaxException("Expected parents to be a JsonObject or JsonArray, was " + JSONUtils.func_151222_d((JsonElement)pairElement));
            }
            return parents;
        }

        private List<Supplier<Item>> getSeeds(JsonElement element) {
            JsonArray array = JSONUtils.func_151207_m((JsonElement)element, (String)"seeds");
            return StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsString).map(ResourceLocation::new).map(loc -> ObjectSupplier.of(loc, ForgeRegistries.ITEMS)).collect(Collectors.toList());
        }

        private Supplier<Block> getSoil(JsonElement element) {
            if (element.isJsonPrimitive()) {
                return () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)"soil")));
            }
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                return () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"block")));
            }
            throw new JsonSyntaxException("Expected soil to be a string or JsonObject, was " + JSONUtils.func_151222_d((JsonElement)element));
        }
    }
}

