/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CropList
implements ISerializable {
    public static final Logger LOGGER = LogManager.getLogger();
    private final HashMap<String, CropEntry> internalMap = new HashMap();

    @Override
    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        try {
            ListNBT keyList = new ListNBT();
            for (String key : this.internalMap.keySet()) {
                keyList.add((Object)StringNBT.func_229705_a_((String)key));
                compound.func_218657_a(key, (INBT)this.internalMap.get(key).write());
            }
            compound.func_218657_a("keys", (INBT)keyList);
        }
        catch (Exception e) {
            PlantTechMain.LOGGER.error("Crop list is broken, cannot write the data");
            return new CompoundNBT();
        }
        return compound;
    }

    @Override
    public void read(CompoundNBT compound) {
        this.internalMap.clear();
        ListNBT list = compound.func_150295_c("keys", 8);
        for (int i = 0; i < list.size(); ++i) {
            String key = list.func_150307_f(i);
            this.internalMap.put(key, new CropEntry(compound.func_74775_l(key)));
        }
    }

    public List<CropEntry> values(boolean includeDisabled) {
        return (List)this.internalMap.values().stream().filter(entry -> includeDisabled || entry.getConfiguration().isEnabled()).sorted().collect(ImmutableList.toImmutableList());
    }

    public List<CropEntry> values() {
        return this.values(false);
    }

    public Set<String> keySet(boolean includeDisabled, boolean onlyWithParticles) {
        return (Set)this.internalMap.keySet().stream().filter(str -> includeDisabled || this.internalMap.get(str).getConfiguration().isEnabled()).filter(str -> !onlyWithParticles || this.internalMap.get(str).hasParticle()).sorted().collect(ImmutableSet.toImmutableSet());
    }

    public Set<String> keySet(boolean includeDisabled) {
        return this.keySet(includeDisabled, false);
    }

    public Set<String> keySet() {
        return this.keySet(false);
    }

    public void addEntry(String name, int seedColor, boolean hasParticle, CropConfiguration defaultConfig) {
        CropEntry prev = this.internalMap.put(name, new CropEntry(name, seedColor, hasParticle, defaultConfig));
        if (prev != null) {
            PlantTechMain.LOGGER.warn("A duplicate crop entry for {} was registered; this may be a coding mistake", (Object)prev.getName());
        }
    }

    public void removeEntry(String name) {
        this.internalMap.remove(name);
    }

    @Nullable
    public CropEntry getByName(String name) {
        return this.internalMap.get(name);
    }

    @Nullable
    public CropEntry getBySeed(Item item) {
        return this.internalMap.values().stream().filter(entry -> entry.isSeed(item)).findFirst().orElse(null);
    }

    public Set<CropEntry> getByParents(String parent1, String parent2) {
        HashSet<CropEntry> result = new HashSet<CropEntry>();
        for (CropEntry entry : this.internalMap.values()) {
            if (!entry.isChild(parent1, parent2)) continue;
            result.add(entry);
        }
        return result;
    }

    public int getLength() {
        return this.internalMap.size();
    }

    public int getLengthEnabledOnly() {
        return this.values(false).size();
    }

    public void configureFromConfigData(Collection<CropEntryConfigData> configData) {
        for (CropEntryConfigData data : configData) {
            CropEntry entry = PlantTechMain.getCropList().getByName(data.getCropEntryName());
            if (entry != null) {
                entry.setConfiguration(CropConfiguration.fromConfigData(data));
                continue;
            }
            LOGGER.error("Attempted to configure crop configuration for non-existent crop {}", (Object)data.getCropEntryName());
        }
    }

    public static CropList addDefaultEntries(CropList cropList) {
        CropList.addEntry(cropList, "abyssalnite", 4522079);
        CropList.addEntry(cropList, "adamantine", 13974528);
        CropList.addEntry(cropList, "allium", 10903265, false);
        CropList.addEntry(cropList, "aluminum", 0xB4B4B4);
        CropList.addEntry(cropList, "aluminum_brass", 13153024);
        CropList.addEntry(cropList, "alumite", 15174143);
        CropList.addEntry(cropList, "amber", 0xE09E00);
        CropList.addEntry(cropList, "apatite", 46048);
        CropList.addEntry(cropList, "aquamarine", 50132);
        CropList.addEntry(cropList, "ardite", 8931099);
        CropList.addEntry(cropList, "awakened_draconium", 12536832);
        CropList.addEntry(cropList, "azure_bluet", 14084328, false);
        CropList.addEntry(cropList, "bamboo", 6129700, false);
        CropList.addEntry(cropList, "basalt", 0x424242);
        CropList.addEntry(cropList, "beast", 6973797);
        CropList.addEntry(cropList, "beetroots", 12526889, false);
        CropList.addEntry(cropList, "black_quartz", 0x202020);
        CropList.addEntry(cropList, "blaze", 16553472);
        CropList.addEntry(cropList, "blitz", 0xFFFDCC);
        CropList.addEntry(cropList, "blizz", 12833791);
        CropList.addEntry(cropList, "blue_topaz", 6326783);
        CropList.addEntry(cropList, "blue_orchid", 3172095, false);
        CropList.addEntry(cropList, "brass", 0xEAEAEA);
        CropList.addEntry(cropList, "bronze", 8406272);
        CropList.addEntry(cropList, "cactus", 5405990, false);
        CropList.addEntry(cropList, "carrot", 14912029, false);
        CropList.addEntry(cropList, "certus_quartz", 10470399);
        CropList.addEntry(cropList, "chicken", 0xE2E2E2);
        CropList.addEntry(cropList, "chimerite", 11468710);
        CropList.addEntry(cropList, "chorus", 9400719, false);
        CropList.addEntry(cropList, "chrome", 0xFFFFFF);
        CropList.addEntry(cropList, "coal", 0x3F3F3F);
        CropList.addEntry(cropList, "cobalt", 1922961);
        CropList.addEntry(cropList, "cocoa_bean", 12153653, false);
        CropList.addEntry(cropList, "cold_iron", 7514111);
        CropList.addEntry(cropList, "compressed_iron", 0xBDBDBD);
        CropList.addEntry(cropList, "conductive_iron", 6462975);
        CropList.addEntry(cropList, "constantan", 11643648);
        CropList.addEntry(cropList, "copper", 11827200);
        CropList.addEntry(cropList, "coralium", 25706);
        CropList.addEntry(cropList, "cornflower", 4614891, false);
        CropList.addEntry(cropList, "cow", 4470310);
        CropList.addEntry(cropList, "creeper", 4306742);
        CropList.addEntry(cropList, "dancium", 15436820);
        CropList.addEntry(cropList, "dandelion", 16700985, false);
        CropList.addEntry(cropList, "dark_gem", 0x4E4E4E);
        CropList.addEntry(cropList, "dark_steel", 9272063);
        CropList.addEntry(cropList, "desh", 0x535353);
        CropList.addEntry(cropList, "diamond", 7851771);
        CropList.addEntry(cropList, "dirt", 5848361);
        CropList.addEntry(cropList, "draconium", 7733434);
        CropList.addEntry(cropList, "dreadium", 12189709);
        CropList.addEntry(cropList, "drowned", 9433559);
        CropList.addEntry(cropList, "electrical_steel", 0xB8B8B8);
        CropList.addEntry(cropList, "electrotine", 20627);
        CropList.addEntry(cropList, "electrum", 16773464);
        CropList.addEntry(cropList, "elementium", 15405567);
        CropList.addEntry(cropList, "emerald", 1564002);
        CropList.addEntry(cropList, "end_steel", 16711638);
        CropList.addEntry(cropList, "ender_amethyst", 16594431);
        CropList.addEntry(cropList, "ender_biotite", 0);
        CropList.addEntry(cropList, "enderdragon", 0x181818);
        CropList.addEntry(cropList, "enderium", 31607);
        CropList.addEntry(cropList, "enderman", 0x181818);
        CropList.addEntry(cropList, "endstone", 16186045);
        CropList.addEntry(cropList, "energetic_alloy", 10288946);
        CropList.addEntry(cropList, "fish", 12551195);
        CropList.addEntry(cropList, "fluix_crystal", 7274648);
        CropList.addEntry(cropList, "fluxed_electrum", 16776071);
        CropList.addEntry(cropList, "ghast", 0xF0F0F0);
        CropList.addEntry(cropList, "glowstone", 16505460);
        CropList.addEntry(cropList, "glowstone_ingot", 16182528);
        CropList.addEntry(cropList, "gold", 16297771);
        CropList.addEntry(cropList, "graphite", 0x444444);
        CropList.addEntry(cropList, "guardian", 6719872);
        CropList.addEntry(cropList, "husk", 6970698);
        CropList.addEntry(cropList, "illager", 0x939999);
        CropList.addEntry(cropList, "invar", 12827648);
        CropList.addEntry(cropList, "iridium", 0xCFCFCF);
        CropList.addEntry(cropList, "iron", 12360064);
        CropList.addEntry(cropList, "kanekium", 5713546);
        CropList.addEntry(cropList, "kelp", 5996849, false);
        CropList.addEntry(cropList, "kinnoium", 2386733);
        CropList.addEntry(cropList, "knightslime", 0xFD5FFF);
        CropList.addEntry(cropList, "lapis", 1066156);
        CropList.addEntry(cropList, "lava", 13717260);
        CropList.addEntry(cropList, "lead", 3305113);
        CropList.addEntry(cropList, "lenthurium", 2917765);
        CropList.addEntry(cropList, "lilly_of_the_valley", 0xE7E7E7, false);
        CropList.addEntry(cropList, "lithium", 16775876);
        CropList.addEntry(cropList, "lumium", 0xFFF282);
        CropList.addEntry(cropList, "magma_cube", 0x330000);
        CropList.addEntry(cropList, "magnesium", 6379776);
        CropList.addEntry(cropList, "malachite", 3587923);
        CropList.addEntry(cropList, "manasteel", 4034559);
        CropList.addEntry(cropList, "manyullyn", 0x793393);
        CropList.addEntry(cropList, "melon", 10988573, false);
        CropList.addEntry(cropList, "meteoric_iron", 9405534);
        CropList.addEntry(cropList, "mithril", 12048383);
        CropList.addEntry(cropList, "moonstone", 0xEEF6FF);
        CropList.addEntry(cropList, "mooshroom", 11014162);
        CropList.addEntry(cropList, "mushroom", 0xE21212, false);
        CropList.addEntry(cropList, "mycelium", 7561570);
        CropList.addEntry(cropList, "nether_wart", 8592416, false);
        CropList.addEntry(cropList, "netherrack", 6629416);
        CropList.addEntry(cropList, "neutronium", 0x585858);
        CropList.addEntry(cropList, "nickel", 10459532);
        CropList.addEntry(cropList, "octine", 16757760);
        CropList.addEntry(cropList, "orange_tulip", 12413474, false);
        CropList.addEntry(cropList, "osmium", 13037055);
        CropList.addEntry(cropList, "oxeye_daisy", 16103975, false);
        CropList.addEntry(cropList, "panda", 16103975);
        CropList.addEntry(cropList, "parrot", 1621503);
        CropList.addEntry(cropList, "peridot", 6277209);
        CropList.addEntry(cropList, "pig", 15834776);
        CropList.addEntry(cropList, "pink_tulip", 14987252, false);
        CropList.addEntry(cropList, "plantium", 3514440, true);
        CropList.addEntry(cropList, "platinum", 0xA2A2A2);
        CropList.addEntry(cropList, "polarbear", 0xF6F6F6);
        CropList.addEntry(cropList, "poppy", 15544364, false);
        CropList.addEntry(cropList, "potato", 13148747, false);
        CropList.addEntry(cropList, "prismarine", 6202518);
        CropList.addEntry(cropList, "pulsating_iron", 7723376);
        CropList.addEntry(cropList, "pumpkin", 14912029, false);
        CropList.addEntry(cropList, "quartz", 13945530);
        CropList.addEntry(cropList, "quicksilver", 0xD6FFFF);
        CropList.addEntry(cropList, "red_tulip", 15544364, false);
        CropList.addEntry(cropList, "redstone", 0xFF0000);
        CropList.addEntry(cropList, "redstone_alloy", 0xFF0000);
        CropList.addEntry(cropList, "refined_obsidian", 6435181);
        CropList.addEntry(cropList, "rock_crystal", 0xA6A6A6);
        CropList.addEntry(cropList, "rubber", 0x444444);
        CropList.addEntry(cropList, "ruby", 0x980000);
        CropList.addEntry(cropList, "saltpeter", 0x969696);
        CropList.addEntry(cropList, "sand", 14340003);
        CropList.addEntry(cropList, "sapphire", 2702);
        CropList.addEntry(cropList, "sheep", 12623494);
        CropList.addEntry(cropList, "shulker", 9330830);
        CropList.addEntry(cropList, "signalum", 9328384);
        CropList.addEntry(cropList, "silicon", 0x777777);
        CropList.addEntry(cropList, "silver", 0xDADADA);
        CropList.addEntry(cropList, "skeleton", 0xBCBCBC);
        CropList.addEntry(cropList, "sky_stone", 0x383838);
        CropList.addEntry(cropList, "slate", 0xFFFFFF);
        CropList.addEntry(cropList, "slime", 5881157);
        CropList.addEntry(cropList, "slimy_bone", 0x7B7B7B);
        CropList.addEntry(cropList, "snow", 0xFFFFFF);
        CropList.addEntry(cropList, "soularium", 4470820);
        CropList.addEntry(cropList, "soulsand", 4798252);
        CropList.addEntry(cropList, "spider", 6313032);
        CropList.addEntry(cropList, "sponge", 13487690);
        CropList.addEntry(cropList, "squid", 13487690);
        CropList.addEntry(cropList, "star_steel", 0x171717);
        CropList.addEntry(cropList, "starmetal", 0x22002F);
        CropList.addEntry(cropList, "steel", 0x686868);
        CropList.addEntry(cropList, "stone", 0x616161);
        CropList.addEntry(cropList, "stray", 11319997);
        CropList.addEntry(cropList, "sugarcane", 8562777, false);
        CropList.addEntry(cropList, "sulfur", 11643943);
        CropList.addEntry(cropList, "sunstone", 12663552);
        CropList.addEntry(cropList, "syrmorite", 13049599);
        CropList.addEntry(cropList, "tanzanite", 11096518);
        CropList.addEntry(cropList, "terrasteel", 3322112);
        CropList.addEntry(cropList, "thaumium", 9044223);
        CropList.addEntry(cropList, "tin", 11249548);
        CropList.addEntry(cropList, "titanium", 0xC6C6C6);
        CropList.addEntry(cropList, "topaz", 16768553);
        CropList.addEntry(cropList, "tungsten", 23104);
        CropList.addEntry(cropList, "turtle", 3706170);
        CropList.addEntry(cropList, "uranium", 3849506);
        CropList.addEntry(cropList, "valonite", 13608405);
        CropList.addEntry(cropList, "vibrant_alloy", 12549632);
        CropList.addEntry(cropList, "villager", 11893607);
        CropList.addEntry(cropList, "vine", 1789969, false);
        CropList.addEntry(cropList, "vinteum", 5931519);
        CropList.addEntry(cropList, "void_metal", 0);
        CropList.addEntry(cropList, "water", 2842623);
        CropList.addEntry(cropList, "wheat", 44569, false);
        CropList.addEntry(cropList, "white_tulip", 0xF7F7F7, false);
        CropList.addEntry(cropList, "witch", 10720387);
        CropList.addEntry(cropList, "wither", 0x343434);
        CropList.addEntry(cropList, "wither_rose", 0, false);
        CropList.addEntry(cropList, "wither_skeleton", 0x515353);
        CropList.addEntry(cropList, "wood", 6315604);
        CropList.addEntry(cropList, "yellorium", 0xFFFC00);
        CropList.addEntry(cropList, "zinc", 0xB8B78B);
        CropList.addEntry(cropList, "zombie", 7443803);
        CropList.addEntry(cropList, "zombie_pigman", 15639972);
        CropList.addEntry(cropList, "zombie_villager", 3891759);
        return cropList;
    }

    static void addEntry(CropList list, String name, int seedColor, boolean hasParticle, Consumer<CropConfiguration.Builder> config) {
        CropConfiguration.Builder builder = CropConfiguration.builder(DropEntry.of(() -> ModItems.SEEDS.get(name), 1, 4));
        if (hasParticle) {
            builder.drop(() -> ModItems.PARTICLES.get(name), 0, 8);
        }
        config.accept(builder);
        list.addEntry(name, seedColor, hasParticle, builder.build());
    }

    static void addEntry(CropList list, String name, int seedColor, boolean hasParticle) {
        CropList.addEntry(list, name, seedColor, hasParticle, b -> {});
    }

    static void addEntry(CropList list, String name, int seedColor) {
        CropList.addEntry(list, name, seedColor, true);
    }
}

