/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.packets.CropListSyncMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CropListReloadListener
extends JsonReloadListener {
    public static final String FOLDER = "pt2_crops";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CropEntryConfigData.class, (Object)CropEntryConfigData.Serializer.INSTANCE).registerTypeAdapter(DropEntry.class, (Object)DropEntry.Serializer.INSTANCE).registerTypeAdapter(ParentPair.class, (Object)ParentPair.Serializer.INSTANCE).create();

    public CropListReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> elementMap, IResourceManager resourceManager, IProfiler profiler) {
        PlantTechMain.LOGGER.debug("Loading crop configurations");
        HashMap<ResourceLocation, Object> configs = new HashMap<ResourceLocation, Object>();
        LinkedList<ResourceLocation> keys = new LinkedList<ResourceLocation>(elementMap.keySet());
        keys.sort((a, b) -> a.func_110624_b().equals("planttech2") ? -1 : a.compareTo(b));
        for (ResourceLocation key : keys) {
            try {
                JsonElement element = elementMap.get(key);
                if (!CraftingHelper.processConditions((JsonObject)JSONUtils.func_151210_l((JsonElement)element, (String)"top element"), (String)"conditions")) {
                    PlantTechMain.LOGGER.debug("Skipping loading crop configuration {} as it's conditions were not met", (Object)key);
                    continue;
                }
                configs.put(key, GSON.fromJson(element, CropEntryConfigData.class));
            }
            catch (JsonSyntaxException | IllegalArgumentException ex) {
                PlantTechMain.LOGGER.error("Error while loading crop configuration {}", (Object)key, (Object)ex);
            }
        }
        PlantTechMain.getCropList().configureFromConfigData(configs.values());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PlantTechMain.LOGGER.info("syncing crop list to clients");
            PlantTech2PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new CropListSyncMessage());
        } else {
            PlantTechMain.LOGGER.info("Server is not up yet, will not send the changes to clients");
        }
    }

    public static JsonElement toJson(CropEntryConfigData data) {
        return GSON.toJsonTree((Object)data);
    }
}

