/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.ObjectSupplier;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class DropEntry
implements ISerializable {
    public static final DropEntry EMPTY = DropEntry.of(() -> Items.field_190931_a, 0, 0);
    private final int min;
    private final int max;
    private final Supplier<Item> drop;

    private DropEntry(Supplier<Item> item, int min, int max) {
        this.drop = item;
        this.min = min;
        this.max = max;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("min", this.min);
        compound.func_74768_a("max", this.max);
        compound.func_74778_a("drop", this.drop.get().getRegistryName().toString());
        return compound;
    }

    public int getAmountDropped(int traitBase, int traitMax, Random rand) {
        int minAmount = Math.max((int)((float)traitBase / (float)traitMax * (float)this.max * 0.75f), this.min);
        int maxAmount = Math.max(1, Math.min((int)((float)traitBase / (float)traitMax * (float)this.max * 1.5f), this.max));
        int range = maxAmount - minAmount;
        return rand.nextInt(range + 1) + minAmount;
    }

    public ItemStack getDroppedStack(int traitBase, int traitMax, Random rand) {
        int amountDropped = this.getAmountDropped(traitBase, traitMax, rand);
        if (amountDropped > 0) {
            return new ItemStack((IItemProvider)this.drop.get(), amountDropped);
        }
        return ItemStack.field_190927_a;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public Supplier<Item> getItem() {
        return this.drop;
    }

    public ItemStack getItemStack() {
        return new ItemStack((IItemProvider)this.getItem().get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropEntry entry = (DropEntry)o;
        return this.min == entry.min && this.max == entry.max && this.drop.equals(entry.drop);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.drop);
    }

    public static DropEntry of(Supplier<Item> item, int min, int max) {
        return new DropEntry(item, min, max);
    }

    public static DropEntry of(CompoundNBT compound) {
        return new DropEntry(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("drop"))), compound.func_74762_e("min"), compound.func_74762_e("max"));
    }

    public static class Serializer
    implements JsonSerializer<DropEntry>,
    JsonDeserializer<DropEntry> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public JsonElement serialize(DropEntry entry, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", entry.getItem().get().getRegistryName().toString());
            obj.addProperty("min", (Number)entry.getMin());
            obj.addProperty("max", (Number)entry.getMax());
            return obj;
        }

        public DropEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation itemLocation;
            int min = 1;
            int max = 1;
            if (json.isJsonPrimitive()) {
                itemLocation = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)json, (String)"drops"));
            } else if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                itemLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"item"));
                if (obj.has("min")) {
                    min = JSONUtils.func_151203_m((JsonObject)obj, (String)"min");
                }
                if (obj.has("max")) {
                    max = JSONUtils.func_151203_m((JsonObject)obj, (String)"max");
                }
            } else {
                throw new JsonSyntaxException("Expected either a string or an object, got " + JSONUtils.func_151222_d((JsonElement)json));
            }
            if (min < 0) {
                throw new JsonSyntaxException("min has a negative value");
            }
            if (max < 0) {
                throw new JsonSyntaxException("max has a negative value");
            }
            if (min > max) {
                throw new JsonSyntaxException("min is bigger than max");
            }
            return DropEntry.of(ObjectSupplier.of(itemLocation, ForgeRegistries.ITEMS), min, max);
        }

        public void write(DropEntry entry, PacketBuffer buffer) {
            buffer.func_192572_a(entry.getItem().get().getRegistryName());
            buffer.writeInt(entry.getMin());
            buffer.writeInt(entry.getMax());
        }

        public DropEntry read(PacketBuffer buffer) {
            ResourceLocation itemLoc = buffer.func_192575_l();
            int min = buffer.readInt();
            int max = buffer.readInt();
            return DropEntry.of(ObjectSupplier.of(itemLoc, ForgeRegistries.ITEMS), min, max);
        }
    }
}

