/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ObjectSupplier<T extends IForgeRegistryEntry<T>>
implements Supplier<T> {
    private T object;
    private final ResourceLocation name;
    private final IForgeRegistry<T> registry;

    private ObjectSupplier(String name, IForgeRegistry<T> registry) {
        this(new ResourceLocation("planttech2", name), registry);
    }

    private ObjectSupplier(ResourceLocation name, IForgeRegistry<T> registry) {
        this.name = name;
        this.registry = registry;
    }

    public static <R extends IForgeRegistryEntry<R>> ObjectSupplier<R> of(String name, IForgeRegistry<R> registry) {
        return ObjectSupplier.of(new ResourceLocation("planttech2", name), registry);
    }

    public static <R extends IForgeRegistryEntry<R>> ObjectSupplier<R> of(ResourceLocation name, IForgeRegistry<R> registry) {
        return new ObjectSupplier<R>(name, registry);
    }

    @Override
    @Nullable
    public T get() {
        if (this.object == null) {
            this.object = this.registry.getValue(this.name);
        }
        return this.object;
    }
}

