/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.blocks.baseclasses.CustomFenceBlock;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelGenerator
extends BlockStateProvider {
    public BlockModelGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "planttech2", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.addHedges();
    }

    private void addHedges() {
        BlockModelBuilder hedge_base = (BlockModelBuilder)this.models().getBuilder("block/hedge/base/hedge_base");
        hedge_base.parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")));
        this.createCube(hedge_base, 5.0f, 5.0f, 5.0f, 11.0f, 16.0f, 11.0f, "#leaves", 0);
        this.createCube(hedge_base, 4.0f, 0.0f, 4.0f, 5.0f, 4.0f, 5.0f, "#wood");
        this.createCube(hedge_base, 4.0f, 0.0f, 11.0f, 5.0f, 4.0f, 12.0f, "#wood");
        this.createCube(hedge_base, 11.0f, 0.0f, 11.0f, 12.0f, 4.0f, 12.0f, "#wood");
        this.createCube(hedge_base, 11.0f, 0.0f, 4.0f, 12.0f, 4.0f, 5.0f, "#wood");
        this.createCube(hedge_base, 5.0f, 0.0f, 5.0f, 11.0f, 4.0f, 11.0f, "#soil", 1);
        BlockModelBuilder hedge_adding = (BlockModelBuilder)this.models().getBuilder("block/hedge/base/hedge_adding");
        this.createCube(hedge_adding, 11.0f, 5.0f, 5.0f, 16.0f, 16.0f, 11.0f, "#leaves", 0);
        this.createCube(hedge_adding, 12.0f, 0.0f, 11.0f, 16.0f, 4.0f, 12.0f, "#wood");
        this.createCube(hedge_adding, 12.0f, 0.0f, 4.0f, 16.0f, 4.0f, 5.0f, "#wood");
        this.createCube(hedge_adding, 11.0f, 0.0f, 5.0f, 16.0f, 4.0f, 11.0f, "#soil", 1);
        BlockModelBuilder hedge_none = (BlockModelBuilder)this.models().getBuilder("block/hedge/base/hedge_none");
        this.createCube(hedge_none, 11.0f, 0.0f, 5.0f, 12.0f, 4.0f, 11.0f, "#wood");
        String[] types = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        String[] soils = new String[]{"dirt", "grass_block_top", "podzol_top"};
        for (String type_1 : types) {
            for (String type_2 : types) {
                BlockModelBuilder temp;
                String hedge = "block/hedge/";
                String woodType = type_1 + "_" + type_2;
                ResourceLocation leavesTexture = this.mcLoc("block/" + type_1 + "_leaves");
                ResourceLocation woodsTexture = this.mcLoc("block/" + type_2 + "_log");
                for (String soil : soils) {
                    String soilType = soil.replace("_block", "").replace("_top", "");
                    ResourceLocation soilTexture = this.mcLoc("block/" + soil);
                    temp = (BlockModelBuilder)this.models().getBuilder(hedge + woodType + "_" + soilType + "_base");
                    ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)temp.parent((ModelFile)hedge_base)).texture("leaves", leavesTexture)).texture("wood", woodsTexture)).texture("soil", soilTexture)).texture("particle", woodsTexture);
                    temp = (BlockModelBuilder)this.models().getBuilder(hedge + woodType + "_" + soil.replace("_block", "").replace("_top", "") + "_adding");
                    ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)temp.parent((ModelFile)hedge_adding)).texture("leaves", leavesTexture)).texture("wood", woodsTexture)).texture("soil", soilTexture)).texture("particle", woodsTexture);
                }
                temp = (BlockModelBuilder)this.models().getBuilder(hedge + woodType + "_none");
                ((BlockModelBuilder)((BlockModelBuilder)temp.parent((ModelFile)hedge_none)).texture("wood", woodsTexture)).texture("particle", woodsTexture);
            }
        }
        for (Hedge b : ModBlocks.HEDGE_BLOCKS) {
            MultiPartBlockStateBuilder builder = this.getMultipartBuilder(b);
            String s = b.getRegistryName().toString().replace("planttech2:hedge_", "block/hedge/");
            builder.part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(s + "_base"))).addModel();
            ModelFile.ExistingModelFile adding = this.models().getExistingFile(this.modLoc(s + "_adding"));
            ModelFile.ExistingModelFile none = this.models().getExistingFile(this.modLoc(s.replace("_dirt", "").replace("_grass", "").replace("_podzol", "") + "_none"));
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)adding).rotationY(270).addModel()).condition((Property)CustomFenceBlock.NORTH, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)none).rotationY(270).addModel()).condition((Property)CustomFenceBlock.NORTH, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)adding).addModel()).condition((Property)CustomFenceBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)none).addModel()).condition((Property)CustomFenceBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)adding).rotationY(90).addModel()).condition((Property)CustomFenceBlock.SOUTH, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)none).rotationY(90).addModel()).condition((Property)CustomFenceBlock.SOUTH, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)adding).rotationY(180).addModel()).condition((Property)CustomFenceBlock.WEST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)none).rotationY(180).addModel()).condition((Property)CustomFenceBlock.WEST, (Comparable[])new Boolean[]{false});
        }
    }

    private void createCube(BlockModelBuilder builder, float fx, float fy, float fz, float tx, float ty, float tz, String texture) {
        builder.element().from(fx, fy, fz).to(tx, ty, tz).textureAll(texture).end();
    }

    private void createCube(BlockModelBuilder builder, float fx, float fy, float fz, float tx, float ty, float tz, String texture, int tint) {
        builder.element().from(fx, fy, fz).to(tx, ty, tz).allFaces((dir, faceB) -> faceB.texture(texture).tintindex(tint)).end();
    }

    public String func_200397_b() {
        return " planttech2 block model generator";
    }
}

