/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.kaneka.planttech2.crops.CropConfigProvider;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;

public class DefaultCropConfigProvider
extends CropConfigProvider {
    private final Map<ResourceLocation, CropEntryConfigData> data = new HashMap<ResourceLocation, CropEntryConfigData>();

    public DefaultCropConfigProvider(DataGenerator generator) {
        super(generator);
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("planttech2", path);
    }

    @Override
    public Map<ResourceLocation, CropEntryConfigData> getCropData() {
        this.addEntryWithSeeds("allium", false, b -> b.seed(() -> Items.field_221622_aX).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221622_aX, 0, 4));
        this.addEntryWithSeeds("azure_bluet", false, b -> b.seed(() -> Items.field_221623_aY).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221623_aY, 0, 4));
        this.addEntryWithSeeds("bamboo", false, b -> b.seed(() -> Items.field_222068_kQ).drop(() -> Items.field_222068_kQ, 0, 4));
        this.addEntryWithSeeds("beast", b -> b.parents("illager", "witch", 0.1f));
        this.addEntryWithSeeds("beetroots", false, b -> b.seed(() -> Items.field_185163_cU).drop(() -> Items.field_185164_cV, 0, 4));
        this.addEntryWithSeeds("blaze", b -> b.parents("creeper", "lava", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("blue_orchid", false, b -> b.seed(() -> Items.field_221621_aW).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221621_aW, 0, 4));
        this.addEntryWithSeeds("cactus", false, b -> b.seed(() -> Items.field_221774_cw).drop(() -> Items.field_221774_cw, 0, 4).temperature(EnumTemperature.WARM).soil(() -> Blocks.field_150354_m));
        this.addEntryWithSeeds("carrot", false, b -> b.seed(() -> Items.field_151172_bF).drop(() -> Items.field_151172_bF, 0, 4));
        this.addEntryWithSeeds("chicken", b -> b.parents("beetroots", "cactus", 0.1f));
        this.addEntryWithSeeds("chorus", false, b -> b.seed(() -> Items.field_221663_bT).drop(() -> Items.field_185161_cS, 0, 4).temperature(EnumTemperature.COLD).soil(() -> Blocks.field_150377_bs));
        this.addEntryWithSeeds("coal", b -> b.parents("nether_wart", "chorus", 0.1f).soil(() -> Blocks.field_150365_q));
        this.addEntryWithSeeds("cocoa_bean", false, b -> b.seed(() -> Items.field_196130_bo).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_196130_bo, 0, 4).temperature(EnumTemperature.WARM));
        this.addEntryWithSeeds("cornflower", false, b -> b.seed(() -> Items.field_221686_be).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221686_be, 0, 4));
        this.addEntryWithSeeds("cow", b -> b.parents("carrot", "potato", 0.1f));
        this.addEntryWithSeeds("creeper", b -> b.parents("pig", "coal", 0.1f));
        this.addEntryWithSeeds("dancium", b -> b.parents("plantium", "fish", 0.1f));
        this.addEntryWithSeeds("dandelion", false, b -> b.seed(() -> Items.field_221619_aU).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221619_aU, 0, 4));
        this.addEntryWithSeeds("diamond", b -> b.parents("quartz", "enderdragon", 0.1f).soil(() -> Blocks.field_150482_ag));
        this.addEntryWithSeeds("dirt", b -> b.parents("melon", "pumpkin", 0.1f));
        this.addEntryWithSeeds("drowned", b -> b.parents("stray", "husk", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("emerald", b -> b.parents("diamond", "wither", 0.1f).soil(() -> Blocks.field_150482_ag));
        this.addEntryWithSeeds("enderdragon", b -> b.parents("enderman", "shulker", 0.1f).temperature(EnumTemperature.EXTREME_WARM).soil(() -> Blocks.field_150357_h));
        this.addEntryWithSeeds("enderman", b -> b.parents("wither_skeleton", "netherrack", 0.1f));
        this.addEntryWithSeeds("endstone", b -> b.parents("coal", "chorus", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("fish", b -> b.parents("cactus", "sugarcane", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("ghast", b -> b.parents("magma_cube", "blaze", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("glowstone", b -> b.parents("soulsand", "netherrack", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("gold", b -> b.parents("coal", "lapis", 0.1f).soil(() -> Blocks.field_150352_o));
        this.addEntryWithSeeds("guardian", b -> b.parents("ghast", "witch", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("husk", b -> b.parents("zombie", "lava", 0.1f).temperature(EnumTemperature.WARM));
        this.addEntryWithSeeds("illager", b -> b.parents("villager", "witch", 0.1f));
        this.addEntryWithSeeds("iron", b -> b.parents("redstone", "gold", 0.1f).soil(() -> Blocks.field_150366_p));
        this.addEntryWithSeeds("kanekium", b -> b.parents("plantium", "squid", 0.1f));
        this.addEntryWithSeeds("kelp", false, b -> b.seed(() -> Items.field_222066_kO).drop(() -> Items.field_222066_kO, 0, 4));
        this.addEntryWithSeeds("kinnoium", b -> b.parents("plantium", "pig", 0.1f));
        this.addEntryWithSeeds("lapis", b -> b.parents("stone", "coal", 0.1f).soil(() -> Blocks.field_150369_x));
        this.addEntryWithSeeds("lava", b -> b.parents("stone", "water", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("lenthurium", b -> b.parents("plantium", "chicken", 0.1f));
        this.addEntryWithSeeds("lilly_of_the_valley", false, b -> b.seed(() -> Items.field_221688_bf).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221688_bf, 0, 4));
        this.addEntryWithSeeds("magma_cube", b -> b.parents("slime", "lava", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("melon", false, b -> b.seed(() -> Items.field_151081_bc).drop(() -> Items.field_221794_dg, 0, 4));
        this.addEntryWithSeeds("mooshroom", b -> b.parents("cow", "mushroom", 0.1f));
        this.addEntryWithSeeds("mushroom", false, b -> b.seed(() -> Items.field_221692_bh).seed(() -> Items.field_221694_bi).drop(() -> Items.field_221692_bh, 0, 4).drop(() -> Items.field_221694_bi, 0, 4));
        this.addEntryWithSeeds("mycelium", b -> b.parents("netherrack", "mooshroom", 0.1f));
        this.addEntryWithSeeds("nether_wart", false, b -> b.seed(() -> Items.field_151075_bm).drop(() -> Items.field_151075_bm, 0, 4).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("netherrack", b -> b.parents("endstone", "nether_wart", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("orange_tulip", false, b -> b.seed(() -> Items.field_221678_ba).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221678_ba, 0, 4));
        this.addEntryWithSeeds("oxeye_daisy", false, b -> b.seed(() -> Items.field_221684_bd).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221684_bd, 0, 4));
        this.addEntryWithSeeds("pink_tulip", false, b -> b.seed(() -> Items.field_221682_bc).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221682_bc, 0, 4));
        this.addEntryWithSeeds("plantium", b -> b.seed(() -> ModItems.PLANTIUM_NUGGET).soil(() -> ModBlocks.PLANTIUM_BLOCK));
        this.addEntryWithSeeds("poppy", false, b -> b.seed(() -> Items.field_221620_aV).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221620_aV, 0, 4));
        this.addEntryWithSeeds("potato", false, b -> b.seed(() -> Items.field_151174_bG).drop(() -> Items.field_151174_bG, 0, 4).drop(() -> Items.field_151170_bI, 0, 2));
        this.addEntryWithSeeds("pumpkin", false, b -> b.seed(() -> Items.field_151080_bb).drop(() -> Items.field_221687_cF, 0, 3));
        this.addEntryWithSeeds("panda", b -> b.parents("beetroots", "mushroom", 0.1f));
        this.addEntryWithSeeds("parrot", b -> b.parents("wheat", "cocoa_bean", 0.1f).temperature(EnumTemperature.WARM));
        this.addEntryWithSeeds("pig", b -> b.parents("beetroots", "carrot", 0.1f));
        this.addEntryWithSeeds("polarbear", b -> b.parents("cow", "panda", 0.1f).temperature(EnumTemperature.EXTREME_COLD));
        this.addEntryWithSeeds("prismarine", b -> b.parents("soulsand", "water", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("quartz", b -> b.parents("netherrack", "iron", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("redstone", b -> b.parents("gold", "glowstone", 0.1f).soil(() -> Blocks.field_150450_ax));
        this.addEntryWithSeeds("red_tulip", false, b -> b.seed(() -> Items.field_221624_aZ).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221624_aZ, 0, 4));
        this.addEntryWithSeeds("sand", b -> b.parents("mushroom", "cactus", 0.1f));
        this.addEntryWithSeeds("sheep", b -> b.parents("potato", "wheat", 0.1f));
        this.addEntryWithSeeds("shulker", b -> b.parents("blaze", "endstone", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("skeleton", b -> b.parents("pig", "cow", 0.1f));
        this.addEntryWithSeeds("slime", b -> b.parents("creeper", "zombie", 0.1f));
        this.addEntryWithSeeds("snow", b -> b.parents("polarbear", "water", 0.1f).temperature(EnumTemperature.EXTREME_COLD));
        this.addEntryWithSeeds("soulsand", b -> b.parents("sand", "netherrack", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("spider", b -> b.parents("sheep", "squid", 0.1f));
        this.addEntryWithSeeds("sponge", b -> b.parents("mycelium", "guardian", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("squid", b -> b.parents("nether_wart", "vine", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("stone", b -> b.parents("wheat", "mushroom", 0.1f));
        this.addEntryWithSeeds("stray", b -> b.parents("skeleton", "snow", 0.1f).temperature(EnumTemperature.COLD));
        this.addEntryWithSeeds("sugarcane", false, b -> b.seed(() -> Items.field_222065_kN).drop(() -> Items.field_222065_kN, 0, 4));
        this.addEntryWithSeeds("turtle", b -> b.parents("squid", "fish", 0.1f));
        this.addEntryWithSeeds("villager", b -> b.parents("polarbear", "turtle", 0.1f));
        this.addEntryWithSeeds("vine", false, b -> b.seed(() -> Items.field_221796_dh).drop(() -> Items.field_221796_dh, 0, 4));
        this.addEntryWithSeeds("water", b -> b.parents("vine", "sugarcane", 0.1f));
        this.addEntryWithSeeds("wheat", false, b -> b.seed(() -> Items.field_151014_N).drop(() -> Items.field_151015_O, 0, 4));
        this.addEntryWithSeeds("white_tulip", false, b -> b.seed(() -> Items.field_221680_bb).drop(() -> ModItems.COLOR_PARTICLES, 1, 4).drop(() -> Items.field_221680_bb, 0, 4));
        this.addEntryWithSeeds("witch", b -> b.parents("villager", "soulsand", 0.1f));
        this.addEntryWithSeeds("wither", b -> b.parents("ghast", "zombie_villager", 0.1f).soil(() -> Blocks.field_150357_h));
        this.addEntryWithSeeds("wither_rose", false, b -> b.seed(() -> Items.field_221690_bg).drop(() -> Items.field_221690_bg, 0, 1));
        this.addEntryWithSeeds("wither_skeleton", b -> b.parents("skeleton", "netherrack", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("wood", b -> b.parents("dirt", "sand", 0.1f));
        this.addEntryWithSeeds("zombie", b -> b.parents("chicken", "sheep", 0.1f));
        this.addEntryWithSeeds("zombie_pigman", b -> b.parents("zombie", "nether_wart", 0.1f).temperature(EnumTemperature.EXTREME_WARM));
        this.addEntryWithSeeds("zombie_villager", b -> b.parents("zombie", "villager", 0.1f));
        this.addDisabledEntry("abyssalnite");
        this.addDisabledEntry("adamantine");
        this.addDisabledEntry("aluminum");
        this.addDisabledEntry("aluminum_brass");
        this.addDisabledEntry("alumite");
        this.addDisabledEntry("amber");
        this.addDisabledEntry("apatite");
        this.addDisabledEntry("aquamarine");
        this.addDisabledEntry("ardite");
        this.addDisabledEntry("awakened_draconium");
        this.addDisabledEntry("basalt");
        this.addDisabledEntry("black_quartz");
        this.addDisabledEntry("blitz");
        this.addDisabledEntry("blizz");
        this.addDisabledEntry("blue_topaz");
        this.addDisabledEntry("brass");
        this.addDisabledEntry("bronze");
        this.addDisabledEntry("certus_quartz");
        this.addDisabledEntry("chimerite");
        this.addDisabledEntry("chrome");
        this.addDisabledEntry("cobalt");
        this.addDisabledEntry("cold_iron");
        this.addDisabledEntry("compressed_iron");
        this.addDisabledEntry("conductive_iron");
        this.addDisabledEntry("constantan");
        this.addDisabledEntry("copper");
        this.addDisabledEntry("coralium");
        this.addDisabledEntry("dark_gem");
        this.addDisabledEntry("dark_steel");
        this.addDisabledEntry("desh");
        this.addDisabledEntry("draconium");
        this.addDisabledEntry("dreadium");
        this.addDisabledEntry("electrical_steel");
        this.addDisabledEntry("electrotine");
        this.addDisabledEntry("electrum");
        this.addDisabledEntry("elementium");
        this.addDisabledEntry("end_steel");
        this.addDisabledEntry("ender_amethyst");
        this.addDisabledEntry("ender_biotite");
        this.addDisabledEntry("enderium");
        this.addDisabledEntry("energetic_alloy");
        this.addDisabledEntry("fluix_crystal");
        this.addDisabledEntry("fluxed_electrum");
        this.addDisabledEntry("glowstone_ingot");
        this.addDisabledEntry("graphite");
        this.addDisabledEntry("invar");
        this.addDisabledEntry("iridium");
        this.addDisabledEntry("knightslime");
        this.addDisabledEntry("lead");
        this.addDisabledEntry("lithium");
        this.addDisabledEntry("lumium");
        this.addDisabledEntry("magnesium");
        this.addDisabledEntry("malachite");
        this.addDisabledEntry("manasteel");
        this.addDisabledEntry("manyullyn");
        this.addDisabledEntry("meteoric_iron");
        this.addDisabledEntry("mithril");
        this.addDisabledEntry("moonstone");
        this.addDisabledEntry("neutronium");
        this.addDisabledEntry("nickel");
        this.addDisabledEntry("octine");
        this.addDisabledEntry("osmium");
        this.addDisabledEntry("peridot");
        this.addDisabledEntry("platinum");
        this.addDisabledEntry("pulsating_iron");
        this.addDisabledEntry("quicksilver");
        this.addDisabledEntry("redstone_alloy");
        this.addDisabledEntry("refined_obsidian");
        this.addDisabledEntry("rock_crystal");
        this.addDisabledEntry("rubber");
        this.addDisabledEntry("ruby");
        this.addDisabledEntry("saltpeter");
        this.addDisabledEntry("signalum");
        this.addDisabledEntry("silicon");
        this.addDisabledEntry("silver");
        this.addDisabledEntry("sky_stone");
        this.addDisabledEntry("slate");
        this.addDisabledEntry("slimy_bone");
        this.addDisabledEntry("soularium");
        this.addDisabledEntry("sapphire");
        this.addDisabledEntry("star_steel");
        this.addDisabledEntry("starmetal");
        this.addDisabledEntry("steel");
        this.addDisabledEntry("sulfur");
        this.addDisabledEntry("sunstone");
        this.addDisabledEntry("syrmorite");
        this.addDisabledEntry("tanzanite");
        this.addDisabledEntry("terrasteel");
        this.addDisabledEntry("thaumium");
        this.addDisabledEntry("tin");
        this.addDisabledEntry("titanium");
        this.addDisabledEntry("topaz");
        this.addDisabledEntry("tungsten");
        this.addDisabledEntry("uranium");
        this.addDisabledEntry("valonite");
        this.addDisabledEntry("vibrant_alloy");
        this.addDisabledEntry("vinteum");
        this.addDisabledEntry("void_metal");
        this.addDisabledEntry("yellorium");
        this.addDisabledEntry("zinc");
        return this.data;
    }

    private void addDisabledEntry(String crop) {
        this.addDisabledEntry(crop, CropConfiguration.Builder::disabled);
    }

    private void addDisabledEntry(String crop, Consumer<CropConfiguration.Builder> config) {
        this.addEntryWithSeeds(crop, true, builder -> config.accept(builder.disabled()));
    }

    private void addEntryWithSeeds(String crop, Consumer<CropConfiguration.Builder> config) {
        this.addEntryWithSeeds(crop, true, config);
    }

    private void addEntryWithSeeds(String crop, boolean hasParticle, Consumer<CropConfiguration.Builder> config) {
        this.addEntry(crop, builder -> {
            if (hasParticle) {
                builder.drop(() -> ModItems.PARTICLES.get(crop), 0, 8);
            }
            config.accept((CropConfiguration.Builder)builder);
        }, DropEntry.of(() -> ModItems.SEEDS.get(crop), 1, 4));
    }

    private void addEntry(String crop, Consumer<CropConfiguration.Builder> config, DropEntry primarySeed) {
        CropConfiguration.Builder builder = CropConfiguration.builder(primarySeed);
        config.accept(builder);
        this.data.put(DefaultCropConfigProvider.modLoc(crop), CropEntryConfigData.create(crop, builder.build()));
    }
}

