/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "planttech2", existingFileHelper);
    }

    protected void registerModels() {
        this.registerBlockModels();
        this.registerItemModels();
    }

    private void registerBlockModels() {
        for (Hedge b : ModBlocks.HEDGE_BLOCKS) {
            this.blockHedge(b);
        }
    }

    private void registerItemModels() {
        this.generatedItemModel("aura_chip_temperature_extreme_cold");
        this.generatedItemModel("aura_chip_temperature_cold");
        this.generatedItemModel("aura_chip_temperature_normal");
        this.generatedItemModel("aura_chip_temperature_warm");
        this.generatedItemModel("aura_chip_temperature_extreme_warm");
    }

    private void generatedItemModel(String name) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + name));
    }

    private void block(Block b) {
        this.withExistingParent(b.getRegistryName().func_110623_a(), this.modLoc("block/" + b.getRegistryName().func_110623_a()));
    }

    private void blockHedge(Hedge b) {
        this.withExistingParent(b.getRegistryName().func_110623_a(), this.modLoc("block/hedge/" + b.getRegistryName().func_110623_a().replace("hedge_", "") + "_base"));
    }

    public String func_200397_b() {
        return " planttech2 item model generator";
    }
}

