/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

public class Languages
extends LanguageProvider {
    public Languages(DataGenerator gen) {
        super(gen, "planttech2", "en_us");
    }

    protected void addTranslations() {
        this.addBlocks();
        this.addHedges();
        this.addCrops();
        this.addGuides();
        this.addGUIs();
        this.addItems();
        this.addItemGroups();
        this.addInfo();
        this.addMisc();
    }

    private void addMisc() {
        this.add("planttech2.update.available", "An update for PlantTech 2 is available. ");
        this.add("planttech2.update.click", "Click here");
        this.add("planttech2.update.tooltip", "View CurseForge");
        this.add("planttech2.electric_fence.idle", "Electric fence hums");
        this.add("planttech2.crossbreeding", "Crossbreeding");
        this.add("planttech2.infuser", "Infuser");
        this.add("planttech2.compressor", "Compressor");
        this.add("planttech2.chipalyzer", "Chipalyzer");
        this.add("planttech2.carver", "Carver Crop");
        this.add("planttech2.machinebulbreprocessor", "Machinebulb Reprocessor");
        this.add("planttech2.machine_growing", "Growing Machine");
        this.add("config.test", "TEST");
        this.add("fluid.biomass", "Biomass");
        this.add("death.attack.radiation_sickness", "%1$s was infected by radiation sickness");
        this.add("armorinformation.when_worn", "When worn:");
        this.add("armorinformation.selfrepair", "Self-repair");
        this.add("armorinformation.autofeed", "Auto-feed");
        this.add("techvillager.profession.scientist", "Scientist");
        this.add("techvillager.profession.botanist", "Botanist");
        this.add("techvillager.profession.headhunter", "Headhunter");
        this.add("techvillager.profession.engineer", "Engineer");
        this.add("text.biometemperature", "temperature");
        this.add("temp.extreme_cold", "Extremely Cold");
        this.add("temp.cold", "Cold");
        this.add("temp.normal", "Normal");
        this.add("temp.warm", "Warm");
        this.add("temp.extreme_warm", "Extremely Warm");
    }

    private void addItemGroups() {
        this.add("itemGroup.planttech2_main", "General");
        this.add("itemGroup.planttech2_blocks", "Building Blocks");
        this.add("itemGroup.planttech2_seeds", "Seeds");
        this.add("itemGroup.planttech2_machines", "Machines");
        this.add("itemGroup.planttech2_particles", "Particles");
        this.add("itemGroup.planttech2_toolsandarmor", "Tools and Armor");
        this.add("itemGroup.planttech2_chips", "Chips and Upgrades");
    }

    private void addItems() {
        this.add(ModItems.GUIDE_OVERVIEW, "Tablet: PlantTech 2 Guide");
        this.add(ModItems.GUIDE_PLANTS, "Tablet: Plant Encyclopedia");
        this.add(ModItems.GUIDE_GENETIC_ENGINEERING, "Tablet: Genetic Engineering (NO FUNKTION!)");
        this.add(ModItems.ANALYSER, "Analyzer");
        this.add(ModItems.ADVANCED_ANALYSER, "Advanced Analyzer");
        this.add(ModItems.CROPREMOVER, "Crop Remover");
        this.add(ModItems.WRENCH, "Wrench");
        this.add(ModItems.THERMOMETER, "Thermometer");
        this.add(ModItems.SOLARFOCUS_TIER_1, "Class 1 Solar Focus");
        this.add(ModItems.SOLARFOCUS_TIER_2, "Class 2 Solar Focus");
        this.add(ModItems.SOLARFOCUS_TIER_3, "Class 3 Solar Focus");
        this.add(ModItems.SOLARFOCUS_TIER_4, "Class 4 Solar Focus");
        this.add(ModItems.SPEEDUPGRADE_TIER_1, "Speed Upgrade v1.0");
        this.add(ModItems.SPEEDUPGRADE_TIER_2, "Speed Upgrade v2.0");
        this.add(ModItems.SPEEDUPGRADE_TIER_3, "Speed Upgrade v3.0");
        this.add(ModItems.SPEEDUPGRADE_TIER_4, "Speed Upgrade v4.0");
        this.add(ModItems.RANGEUPGRADE_TIER_1, "Range Upgrade v1.0");
        this.add(ModItems.RANGEUPGRADE_TIER_2, "Range Upgrade v2.0");
        this.add(ModItems.RANGEUPGRADE_TIER_3, "Range Upgrade v3.0");
        this.add(ModItems.RANGEUPGRADE_TIER_4, "Range Upgrade v4.0");
        this.add(ModItems.CAPACITYUPGRADE_TIER_1, "Capacity Upgrade v1.0");
        this.add(ModItems.CAPACITYUPGRADE_TIER_2, "Capacity Upgrade v2.0");
        this.add(ModItems.CAPACITYUPGRADE_TIER_3, "Capacity Upgrade v3.0");
        this.add(ModItems.PLANTIUM_INGOT, "Plantium Ingot");
        this.add(ModItems.PLANTIUM_NUGGET, "Plantium Nugget");
        this.add(ModItems.DANCIUM_INGOT, "Dancium Ingot");
        this.add(ModItems.DANCIUM_NUGGET, "Dancium Nugget");
        this.add(ModItems.KANEKIUM_INGOT, "Kanekium Ingot");
        this.add(ModItems.KANEKIUM_NUGGET, "Kanekium Nugget");
        this.add(ModItems.KINNOIUM_INGOT, "Kinnoium Ingot");
        this.add(ModItems.KINNOIUM_NUGGET, "Kinnoium Nugget");
        this.add(ModItems.LENTHURIUM_INGOT, "Lenthurium Ingot");
        this.add(ModItems.LENTHURIUM_NUGGET, "Lenthurium Nugget");
        this.add(ModItems.BIOMASS, "Biomass");
        this.add(ModItems.DNA_CONTAINER_EMPTY, "Empty DNA Container");
        this.add(ModItems.DNA_CONTAINER, "DNA Container");
        this.add(ModItems.FERTILIZER_TIER_1, "G1 Fertilizer");
        this.add(ModItems.FERTILIZER_TIER_2, "G2 Fertilizer");
        this.add(ModItems.FERTILIZER_TIER_3, "G3 Fertilizer");
        this.add(ModItems.FERTILIZER_TIER_4, "G4 Fertilizer");
        this.add(ModItems.FERTILIZER_CREATIVE, "Creative Fertilizer");
        this.add(ModItems.GEAR_KANEKIUM, "Kanekium Gear");
        this.add(ModItems.GEAR_LENTHURIUM, "Lenthurium Gear");
        this.add(ModItems.GEAR_KINNOIUM, "Kinnoium Gear");
        this.add(ModItems.GEAR_DANCIUM, "Dancium Gear");
        this.add(ModItems.GEAR_IRON, "Iron Gear");
        this.add(ModItems.GEAR_PLANTIUM, "Plantium Gear");
        this.add(ModItems.GEAR_KANEKIUM_INFUSED, "Infused Kanekium Gear");
        this.add(ModItems.GEAR_LENTHURIUM_INFUSED, "Infused Lenthurium Gear");
        this.add(ModItems.GEAR_KINNOIUM_INFUSED, "Infused Kinnoium Gear");
        this.add(ModItems.GEAR_DANCIUM_INFUSED, "Infused Dancium Gear");
        this.add(ModItems.GEAR_IRON_INFUSED, "Infused Iron Gear");
        this.add(ModItems.GEAR_PLANTIUM_INFUSED, "Infused Plantium Gear");
        this.add(ModItems.REDSTONE_INFUSED, "Infused Redstone");
        this.add(ModItems.BIOMASSCONTAINER, "Biomasscontainer");
        this.add(ModItems.ENERGYSTORAGE_TIER_1, "Class 1 Battery");
        this.add(ModItems.ENERGYSTORAGE_TIER_2, "Class 2 Battery");
        this.add(ModItems.ENERGYSTORAGE_TIER_3, "Class 3 Battery");
        this.add(ModItems.KNOWLEDGECHIP_TIER_0, "Knowledge Chip v0a");
        this.add(ModItems.KNOWLEDGECHIP_TIER_1, "Knowledge Chip v1.0");
        this.add(ModItems.KNOWLEDGECHIP_TIER_2, "Knowledge Chip v2.0");
        this.add(ModItems.KNOWLEDGECHIP_TIER_3, "Knowledge Chip v3.0");
        this.add(ModItems.KNOWLEDGECHIP_TIER_4, "Knowledge Chip v4.0");
        this.add(ModItems.KNOWLEDGECHIP_TIER_5, "Knowledge Chip v5.0");
        this.add(ModItems.WHITE_CRYSTAL, "White Crystal");
        this.add(ModItems.DARK_CRYSTAL, "Dark Crystal");
        this.add(ModItems.PLANT_OBTAINER, "Plant Obtainer");
        this.add(ModItems.RADIATION_METRE, "Radiation Metre");
        this.add((Item)ModItems.BIOMASS_BUCKET, "Biomass Bucket");
        this.add((Item)ModItems.MACHINEBULBREPROCESSOR_BULB, "Machinebulb Reprocessor Bulb");
        this.add((Item)ModItems.DNA_COMBINER_BULB, "DNA Combiner Bulb");
        this.add((Item)ModItems.DNA_EXTRACTOR_BULB, "DNA Extractor Bulb");
        this.add((Item)ModItems.DNA_REMOVER_BULB, "DNA Remover Bulb");
        this.add((Item)ModItems.DNA_CLEANER_BULB, "DNA Cleaner Bulb");
        this.add((Item)ModItems.CHIPALYZER_BULB, "Chipalyzer Bulb");
        this.add((Item)ModItems.COMPRESSOR_BULB, "Compressor Bulb");
        this.add((Item)ModItems.IDENTIFIER_BULB, "Identifier Bulb");
        this.add((Item)ModItems.INFUSER_BULB, "Infuser Bulb");
        this.add((Item)ModItems.SEEDSQUEEZER_BULB, "Seed Squeezer Bulb");
        this.add((Item)ModItems.SOLARGENERATOR_BULB, "Solar Generator Bulb");
        this.add((Item)ModItems.MEGAFURNACE_BULB, "Megafurnace Bulb");
        this.add((Item)ModItems.PLANTFARM_BULB, "Plantfarm Bulb");
        this.add((Item)ModItems.SEEDCONSTRUCTOR_BULB, "Seed Constructor Bulb");
        this.add((Item)ModItems.ENERGY_SUPPLIER_BULB, "Energy Supplier Bulb");
        this.add(ModItems.CYBERBOW, "CyberBow");
        this.add(ModItems.CYBERDAGGER, "CyberDagger");
        this.add(ModItems.CYBERKATANA, "CyberKatana");
        this.add(ModItems.CYBERRAPIER, "CyberRapier");
        this.add(ModItems.MULTITOOL, "MultiTool");
        this.add((Item)ModItems.CYBERARMOR_HELMET, "CyberArmor Helmet");
        this.add((Item)ModItems.CYBERARMOR_CHEST, "CyberArmor Chest");
        this.add((Item)ModItems.CYBERARMOR_LEGGINGS, "CyberArmor Leggings");
        this.add((Item)ModItems.CYBERARMOR_BOOTS, "CyberArmor Boots");
        this.add(ModItems.EMPTY_UPGRADECHIP_TIER_1, "Blank Upgrade Chip");
        this.add(ModItems.EMPTY_UPGRADECHIP_TIER_2, "v2.0 Chip Upgrade Pack");
        this.add(ModItems.EMPTY_UPGRADECHIP_TIER_3, "v3.0 Chip Upgrade Pack");
        this.add(ModItems.CHIP_UPGRADEPACK_CAPACITY_1, "v2.0 Capacity Chip Upgrade Pack");
        this.add(ModItems.CHIP_UPGRADEPACK_CAPACITY_2, "v3.0 Capacity Chip Upgrade Pack");
        this.add(ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_1, "v2.0 Harvest Level Chip Upgrade Pack");
        this.add(ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_2, "v3.0 Harvest Level Chip Upgrade Pack");
        this.add(ModItems.CHIP_UPGRADEPACK_REACTOR_1, "v2.0 Reactor Chip Upgrade Pack");
        this.add(ModItems.CHIP_UPGRADEPACK_REACTOR_2, "v3.0 Reactor Chip Upgrade Pack");
        this.add(ModItems.CAPACITYCHIP_TIER_1, "Capacity Chip v1.0");
        this.add(ModItems.CAPACITYCHIP_TIER_2, "Capacity Chip v2.0");
        this.add(ModItems.CAPACITYCHIP_TIER_3, "Capacity Chip v3.0");
        this.add(ModItems.HARVESTLEVELCHIP_TIER_1, "Harvest Level Chip v1.0");
        this.add(ModItems.HARVESTLEVELCHIP_TIER_2, "Harvest Level Chip v2.0");
        this.add(ModItems.HARVESTLEVELCHIP_TIER_3, "Harvest Level Chip v3.0");
        this.add(ModItems.ATTACKCHIP_TIER_1, "Attack Chip v1.0");
        this.add(ModItems.ATTACKCHIP_TIER_2, "Attack Chip v2.0");
        this.add(ModItems.ATTACKCHIP_TIER_3, "Attack Chip v3.0");
        this.add(ModItems.BREAKDOWNRATECHIP_TIER_1, "Breakdown Rate Chip v1.0");
        this.add(ModItems.BREAKDOWNRATECHIP_TIER_2, "Breakdown Rate Chip v2.0");
        this.add(ModItems.BREAKDOWNRATECHIP_TIER_3, "Breakdown Rate Chip v3.0");
        this.add(ModItems.ARMORCHIP_TIER_1, "Armor Chip v1.0");
        this.add(ModItems.ARMORCHIP_TIER_2, "Armor Chip v2.0");
        this.add(ModItems.ARMORCHIP_TIER_3, "Armor Chip v3.0");
        this.add(ModItems.TOUGHNESSCHIP_TIER_1, "Toughness Chip v1.0");
        this.add(ModItems.TOUGHNESSCHIP_TIER_2, "Toughness Chip v2.0");
        this.add(ModItems.TOUGHNESSCHIP_TIER_3, "Toughness Chip v3.0");
        this.add(ModItems.ATTACKSPEEDCHIP_TIER_1, "Attack Speed Chip v1.0");
        this.add(ModItems.ATTACKSPEEDCHIP_TIER_2, "Attack Speed Chip v2.0");
        this.add(ModItems.ATTACKSPEEDCHIP_TIER_3, "Attack Speed Chip v3.0");
        this.add(ModItems.REACTORCHIP_TIER_1, "Reactor Chip v1.0");
        this.add(ModItems.REACTORCHIP_TIER_2, "Reactor Chip v2.0");
        this.add(ModItems.REACTORCHIP_TIER_3, "Reactor Chip v3.0");
        this.add(ModItems.UNLOCKCHIP_SHOVEL, "Unlock Chip: Shovel");
        this.add(ModItems.UNLOCKCHIP_AXE, "Unlock Chip: Axe");
        this.add(ModItems.UNLOCKCHIP_SHEARS, "Unlock Chip: Shears");
        this.add(ModItems.UNLOCKCHIP_HOE, "Unlock Chip: Hoe");
        this.add(ModItems.PROTECTION_CHIP, "Protection Chip");
        this.add(ModItems.FIRE_PROTECTION_CHIP, "Fire Protection Chip");
        this.add(ModItems.FEATHER_FALLING_CHIP, "Feather Falling Chip");
        this.add(ModItems.BLAST_PROTECTION_CHIP, "Blast Protection Chip");
        this.add(ModItems.PROJECTILE_PROTECTION_CHIP, "Projectile Protection Chip");
        this.add(ModItems.RESPIRATION_CHIP, "Respiration Chip");
        this.add(ModItems.AQUA_AFFINITY_CHIP, "Aqua Affinity Chip");
        this.add(ModItems.THORNS_CHIP, "Thorns Chip");
        this.add(ModItems.DEPTH_STRIDER_CHIP, "Depth Strider Chip");
        this.add(ModItems.FROST_WALKER_CHIP, "Frost Walker Chip");
        this.add(ModItems.SHARPNESS_CHIP, "Sharpness Chip");
        this.add(ModItems.SMITE_CHIP, "Smite Chip");
        this.add(ModItems.BANE_OF_ARTHROPODS_CHIP, "Bane of Arthropods Chip");
        this.add(ModItems.KNOCKBACK_CHIP, "Knockback Chip");
        this.add(ModItems.FIRE_ASPECT_CHIP, "Fire Aspect Chip");
        this.add(ModItems.LOOTING_CHIP, "Looting Chip");
        this.add(ModItems.SWEEPING_CHIP, "Sweeping Chip");
        this.add(ModItems.EFFICIENCY_CHIP, "Efficiency Chip");
        this.add(ModItems.SILK_TOUCH_CHIP, "Silk Touch Chip");
        this.add(ModItems.UNBREAKING_CHIP, "Unbreaking Chip");
        this.add(ModItems.FORTUNE_CHIP, "Fortune Chip");
        this.add(ModItems.POWER_CHIP, "Power Chip");
        this.add(ModItems.PUNCH_CHIP, "Punch Chip");
        this.add(ModItems.FLAME_CHIP, "Flame Chip");
        this.add(ModItems.INFINITY_CHIP, "Infinity Chip");
    }

    private void addBlocks() {
        this.add(ModBlocks.WALL_LIGHT, "Wall Light");
        this.add((Block)ModBlocks.BIOMASSFLUIDBLOCK, "Biomass Fluid");
        this.add(ModBlocks.CROPBARS, "Cropbars");
        this.add(ModBlocks.IDENTIFIER, "Identifier");
        this.add(ModBlocks.MEGAFURNACE, "Mega Furnace");
        this.add(ModBlocks.SEEDSQUEEZER, "Seed Squeezer");
        this.add(ModBlocks.SOLARGENERATOR, "Solar Generator");
        this.add(ModBlocks.PLANTFARM, "Void-Plantfarm");
        this.add(ModBlocks.PLANTIUM_BLOCK, "Plantium Block");
        this.add(ModBlocks.DANCIUM_BLOCK, "Dancium Block");
        this.add(ModBlocks.KANEKIUM_BLOCK, "Kanekium Block");
        this.add(ModBlocks.KINNOIUM_BLOCK, "Kinnoium Block");
        this.add(ModBlocks.LENTHURIUM_BLOCK, "Lenthurium Block");
        this.add(ModBlocks.UNIVERSAL_SOIL, "Experimental Soil Prototype");
        this.add(ModBlocks.UNIVERSAL_SOIL_INFUSED, "Biomass-Infused OmniSoil");
        this.add(ModBlocks.CABLE, "Cable");
        this.add(ModBlocks.DNA_EXTRACTOR, "DNA Extractor");
        this.add(ModBlocks.DNA_COMBINER, "DNA Combiner");
        this.add(ModBlocks.DNA_REMOVER, "DNA Remover");
        this.add(ModBlocks.DNA_CLEANER, "DNA Cleaner");
        this.add(ModBlocks.SEEDCONSTRUCTOR, "Seed Constructor");
        this.add(ModBlocks.COMPRESSOR, "Compressor");
        this.add(ModBlocks.ENERGYSTORAGE, "Energy Storage");
        this.add(ModBlocks.INFUSER, "Infuser");
        this.add(ModBlocks.CHIPALYZER, "Chipalyzer");
        this.add(ModBlocks.MACHINEBULBREPROCESSOR, "Machinebulb Reprocessor");
        this.add(ModBlocks.MACHINESHELL_IRON, "Iron Machine Shell");
        this.add(ModBlocks.MACHINESHELL_PLANTIUM, "Plantium Machine Shell");
        this.add(ModBlocks.CARVER, "Carver Crop");
        this.add(ModBlocks.ENERGY_SUPPLIER, "Energy Supplier");
        this.add(ModBlocks.DARK_CRYSTAL_BLOCK, "Dark Crystal Block");
        this.add(ModBlocks.DARK_CRYSTAL_BRICK, "Dark Crystal Bricks");
        this.add(ModBlocks.DARK_CRYSTAL_TILING, "Dark Crystal Tiling");
        this.add(ModBlocks.DARK_CRYSTAL_LAMP, "Dark Crystal Lamp");
        this.add(ModBlocks.DARK_CRYSTAL_STAIRS, "Dark Crystal Stairs");
        this.add(ModBlocks.DARK_CRYSTAL_SLAB, "Dark Crystal Slab");
        this.add(ModBlocks.DARK_CRYSTAL_FENCE, "Dark Crystal Fence");
        this.add(ModBlocks.DARK_CRYSTAL_DOOR, "Dark Crystal Door");
        this.add(ModBlocks.DARK_CRYSTAL_GLASSPANE_END, "Dark Crystal Glasspane End");
        this.add(ModBlocks.DARK_CRYSTAL_GLASSPANE_MIDDLE, "Dark Crystal Glasspane Middle");
        this.add(ModBlocks.DARK_CRYSTAL_GLASSPANE_CROSS, "Dark Crystal Glasspane Cross");
        this.add(ModBlocks.DARK_CRYSTAL_ORE, "Dark Crystal Ore");
        this.add(ModBlocks.ELECTRIC_FENCE, "Electric Fence");
        this.add(ModBlocks.ELECTRIC_FENCE_TOP, "Electric Fence Top");
        this.add(ModBlocks.ELECTRIC_FENCE_GATE, "Electric Fence Gate");
        this.add(ModBlocks.WHITE_CRYSTAL_BLOCK, "White Crystal Block");
        this.add(ModBlocks.WHITE_CRYSTAL_BRICK, "White Crystal Bricks");
        this.add(ModBlocks.WHITE_CRYSTAL_TILING, "White Crystal Tiling");
        this.add(ModBlocks.WHITE_CRYSTAL_STAIRS, "White Crystal Stairs");
        this.add(ModBlocks.WHITE_CRYSTAL_SLAB, "White Crystal Slab");
        this.add(ModBlocks.WHITE_CRYSTAL_FENCE, "White Crystal Fence");
        this.add(ModBlocks.WHITE_CRYSTAL_DOOR, "White Crystal Door");
        this.add(ModBlocks.WHITE_CRYSTAL_GLASSPANE_END, "White Crystal Glasspane End");
        this.add(ModBlocks.WHITE_CRYSTAL_GLASSPANE_MIDDLE, "White Crystal Glasspane Middle");
        this.add(ModBlocks.WHITE_CRYSTAL_GLASSPANE_CROSS, "White Crystal Glasspane Cross");
        this.add(ModBlocks.WHITE_CRYSTAL_ORE, "White Crystal Ore");
    }

    public void addCrops() {
        this.add(ModItems.COLOR_PARTICLES, "Color Particles");
        HashMap<String, String> langKeys = new HashMap<String, String>();
        Map<String, String> crops = Languages.defaultCrops();
        crops.forEach((k, v) -> langKeys.putIfAbsent("crop." + k, (String)v));
        for (CropEntry entry : PlantTechMain.getCropList().values()) {
            String name = entry.getName().intern();
            langKeys.putIfAbsent("item.planttech2." + name + "_seeds", crops.get(name) + " Seeds");
            if (!entry.hasParticle()) continue;
            langKeys.putIfAbsent("item.planttech2." + name + "_particles", crops.get(name) + " Particles");
        }
        langKeys.forEach((arg_0, arg_1) -> ((Languages)this).add(arg_0, arg_1));
    }

    public void addHedges() {
        String[] types = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        String[] soils = new String[]{"dirt", "grass", "podzol"};
        for (String type_1 : types) {
            for (String type_2 : types) {
                for (String soil : soils) {
                    this.add("block.planttech2.hedge_" + type_1 + "_" + type_2 + "_" + soil, "Hedge");
                }
            }
        }
    }

    public void addGUIs() {
        this.add("container.megafurnace", "Mega Furnace");
        this.add("container.identifier", "Identifier");
        this.add("container.solargenerator", "Solar Generator");
        this.add("container.seedsqueezer", "Seed Squeezer");
        this.add("container.plantfarm", "Plantfarm");
        this.add("container.dnaextractor", "DNA Extractor");
        this.add("container.dnacombiner", "DNA Combiner");
        this.add("container.dnaremover", "DNA Remover");
        this.add("container.dnacleaner", "DNA Cleaner");
        this.add("container.seedconstructor", "Seed Constructor");
        this.add("container.compressor", "Compressor");
        this.add("container.energystorage", "Energy Storage");
        this.add("container.infuser", "Infuser");
        this.add("container.upgradeableitem", "Upgrade Item");
        this.add("container.chipalyzer", "Chipalyzer");
        this.add("container.planttopia_teleporter", "PlantTopia Teleporter");
        this.add("container.machinebulbreprocessor", "Machinebulb Reprocessor");
        this.add("container.energysupplier", "Energy Supplier");
        this.add("gui.soil", "Soil");
        this.add("gui.seeds", "Seeds");
        this.add("gui.drops", "Drops");
        this.add("gui.temperature", "Temperature");
        this.add("gui.parents", "Parents");
        this.add("gui.non_selected", "Nothing selected");
        this.add("gui.next", "Next");
        this.add("gui.last", "Last");
        this.add("gui.back", "Back");
        this.add("slot.chipalyzer.chipinput", "Insert empty chip");
        this.add("slot.chipalyzer.iteminput", "Insert item to implant in empty chip");
        this.add("slot.compressor.input", "Insert particle and select result");
        this.add("slot.compressor.select", "Select result after placing particle in input slot");
        this.add("slot.dnacleaner.input", "Insert DNA container you want to empty");
        this.add("slot.dnacombiner.container", "Insert DNA container with traits you want to combine");
        this.add("slot.dnacombiner.empty_container", "Insert empty DNA container");
        this.add("slot.dnaextractor.seeds", "Insert seed you want to extract traits from");
        this.add("slot.dnaextractor.empty_container", "Insert empty DNA container");
        this.add("slot.dnaremover.container", "Insert DNA container to remove a single trait");
        this.add("slot.identifier.input", "Insert seeds with unknown traits");
        this.add("slot.infuser.input", "Insert item/block you want to infuse with biomass");
        this.add("slot.megafurnace.input", "Insert item/block you want to smelt");
        this.add("slot.machinebulbreprocessor.input", "Seeds placed here will be reprocessed into a Machinebulb");
        this.add("slot.plantfarm.storage", "Drops of harvested crops will be inserted here");
        this.add("slot.seedconstructor.container", "Insert DNA container to construct a new seed with its traits");
        this.add("slot.seedsqueezer.input", "Insert PlantTech2 seeds that should be squeezed into biomass and energy");
        this.add("slot.seedsqueezer.squeeze", "No input, will automatically pull from input");
        this.add("slot.solargenerator.focus", "Insert focus to start energy production");
        this.add("slot.upgradeableitem.chipslot", "Insert chip to upgrade item");
        this.add("slot.util.speedupgrade", "Insert Speed Upgrade to speed up the process");
        this.add("slot.util.rangeupgrade", "Insert Range Upgrade to increase the production");
        this.add("slot.util.energystorageupgrade", "Insert Storage Upgrade to increase the energy storage");
        this.add("slot.util.knowledgechip", "Insert Knowledge Chip to collect knowledge while machine is active (limited by the tier of the machine)");
        this.add("slot.util.output", "Output slot");
        this.add("slot.util.fluidin", "Insert biomass container to insert biomass");
        this.add("slot.util.fluidout", "Insert biomass container to extract biomass");
        this.add("slot.util.energyin", "Insert item with energy to charge this machine");
        this.add("slot.util.energyout", "Insert item with energy to charge the item");
    }

    public void addGuides() {
        this.addGuide("header", "PlantTech 2 Guide");
        this.addGuide("crossbreeding.menu", "Crossbreeding");
        this.addGuide("machines.menu", "Machines");
        this.addGuide("genetic_engineering.menu", "Genetic Engineering");
        this.addGuide("general_crossbreeding.header", "General");
        this.addGuide("getting_started.header", "Getting started");
        this.addGuide("crop_not_growing.header", "Crop is not growing?");
        this.addGuide("multiply_crops_seeds.header", "How to multiply crops/seeds");
        this.addGuide("how_to_crossbreed.header", "How to crossbreed");
        this.addGuide("autoreplanting.header", "Auto-replanting");
        this.addGuide("croptraits.header", "Crop traits");
        this.addGuide("identify_traits.header", "Identify traits");
        this.addGuide("fertilizer.header", "Fertilizer");
        this.addGuide("genetic_engineering_crops.header", "Genetic engineering crops");
        this.addGuide("general_genetic_engineering.header", "General");
        this.addGuide("extracting_genes.header", "Extracting genes");
        this.addGuide("purifying_genes.header", "Purifying genes");
        this.addGuide("combining_genes.header", "Combining genes");
        this.addGuide("cleaning_containers.header", "Cleaning containers");
        this.addGuide("creating_designerseeds.header", "Creating designer seeds");
        this.addGuide("general_machines.header", "General");
        this.addGuide("chipalyzer.header", "Chipalyzer");
        this.addGuide("compressor.header", "Compressor");
        this.addGuide("dna_cleaner.header", "DNA Cleaner");
        this.addGuide("dna_combiner.header", "DNA Combiner");
        this.addGuide("dna_extractor.header", "DNA Extractor");
        this.addGuide("dna_remover.header", "DNA Remover");
        this.addGuide("energy_supplier.header", "Energy Supplier");
        this.addGuide("identifier.header", "Identifier");
        this.addGuide("infuser.header", "Infuser");
        this.addGuide("machinebulb_reprocessor.header", "Machinebulb Reprocessor");
        this.addGuide("mega_furnace.header", "Mega Furnace");
        this.addGuide("void_plantfarm.header", "Void Plantfarm");
        this.addGuide("seedconstructor.header", "Seed Constructor");
        this.addGuide("seed_squeezer.header", "Seed Squeezer");
        this.addGuide("solar_generator.header", "Solar Generator");
        this.addGuide("general_crossbreeding.text", "Crossbreeding is the key for renewable resources. But before starting there is some important information: <br> <br> - PlantTech 2 crops act different then vanilla crops. They share some behavior, but not all. <br> - The crops have traits that can be improved with crossbreeding, but most of the base traits are considerably worse than vanilla - however, if properly tended they can be much more efficient. <br> <br> Example: In the beginning plants will need a water source to be 1 block away, but through crossbreeding they can potentially thrive with water as far as 9 blocks away. <br> <br> Please refer to the 'Crop traits' section of the Guide for detailed information. <br> <br> **Also be advised that Bonemeal does not work on PlantTech 2 crops (see Fertilizer)");
        this.addGuide("getting_started.text", "To start your career as a crossbreeder, you just need cropbars <br> (crafting: 4 sticks in 2x2 square) and a vanilla seed (or plantium nugget). Place the cropbars and right-click with the seeds on the cropbars, and if conditions are right the crop will grow. (If not, have a look at the next chapter.)");
        this.addGuide("crop_not_growing.text", "The easiest way to check, if the conditions are matched, is using the analyser. Just right-click on the crop and you will get a message with every condition that is not matched. <br>  The conditions are: <br> <br> - Water source near enough <br> - Light level high enough <br> - Right soil <br> - Right temperature");
        this.addGuide("multiply_crops_seeds.text", "When fully grown on a cropbar, plants will spread to an empty cropbar that is immediately adjacent. This is the easiest way to multiply your stock of seeds without increasing any traits, and if the original seed was identified the traits of the new plant will also be known (provided the result was not a crossbreed; see the next chapter). Once the Fertility trait increases, extra seeds may begin to drop when a crop is harvested.");
        this.addGuide("how_to_crossbreed.text", "When trying to get better traits - or new crop types - you need to crossbreed. This happens when a fully-grown plant spreads onto an empty cropbar that is next to another plant. The selection of the new traits/type is random with the following logic: <br> <br> Type: If the parent crops are different but have a matching crossbreed result, there is a small chance the new plant will be of that type. <br> <br> Traits: For each trait, the traits of the parents are compared. If they are equal, there is a small chance the trait will increased by one. Otherwise, the traits of the new crop will be in range of the parents' traits. <br> <br> The traits of a crossbred crop are always unknown and will need to be revealed with the Identifier machine.");
        this.addGuide("autoreplanting.text", "All crops in PlantTech 2 are auto-replanted; right-clicking to harvest the crops when fully grown will generate any drops and reset the plant to the seedling state. Until the Fertility trait is increased this will usually result in no extra seed drops, as a seed was needed for replanting.");
        this.addGuide("croptraits.text", " **Growth Rate** <br>     - Minimum level: 0 <br>    - Maximum level: 10 <br>     - Reduce the amount of time needed for the crop to grow. <br>    - Time per Stage = 90s - level * 6 <br> <br> **Sensitivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level 10 <br>    - Not yet implemented. <br> <br>  **Light Sensitivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 14 <br>    - Defines the minimum light level needed for the plant to grow. <br>    - Minimum needed lightlevel = 14 - level <br> <br>  **Water Sensitivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 8 <br>    - Defines the max distance from water that that the crop will be able to grow. <br>    - Distance = 1 + level <br> <br>  **Temperature Tolerance** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 4 <br>    - Allows the crop to grow in temperatures outside of its native climate. <br>    - Allowed temperature = default temperature +- level <br> <br> <br> <br> <br> <br> **Productivity** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 5 <br>    - Increases the amount of products dropped <br> <br>  **Fertility** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 5 <br>    - Increases the amount of seeds dropped <br> <br>  **Spreading Speed** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 10 <br>    - Not yet implemented <br> <br> <br> **Gene Strength** <br> <br>    - Minimum level: 0 <br>    - Maximum level: 10 <br>    - Not yet implemented <br> <br>  **Energy Value** <br> <br>    - Minimum level: 1 <br>    - Maximum level: 10 <br>    - Increases the amount of energy produced in the seed squeezer <br>    - Energy = level * 20");
        this.addGuide("identify_traits.text", "The identifier is a machine that uses energy to identify the unknown traits of crops. <br> Just put the seeds with the unknown traits in the correct slot and the seeds will be identified in a bit. <br> For more information, have a look at \"Machines: Identifier.\"");
        this.addGuide("fertilizer.text", "Bonemeal does not work on PlantTech 2 crops. Instead, Fertilizer must be created by infusing Bonemeal with biomass (in the Infuser machine). There are 4 tiers of fertilizer, which may be upgraded in the Infuser as well. <br> <br> Fertilizer has a chance of advancing the growth of the crop it is used on by one stage, from 5% at Tier 1 to 75% at Tier 4.");
        this.addGuide("genetic_engineering_crops.text", "To make the life a bit easier, it is possible to extract genes of crops and make seeds with these genes. <br> This process is a bridge between the way of crossbreeding and the way of PlantTechian. <br> You find more information in the main category 'Genetic Engineering'");
        this.addGuide("general_genetic_engineering.text", "Genetic engineering is a way to create crops with selected traits. These traits need to be found first but could be used as much as you want. So, start crossbreeding your crops and develop the traits you like to have.");
        this.addGuide("extracting_genes.text", "Once you got traits you want to keep, you need to extract the whole DNA sequence. <br> Therefore, put a seed with traits and an empty DNA container in the DNA extractor. You will obtain a DNA container with the whole DNA sequence; the seed will be destroyed in the process.");
        this.addGuide("purifying_genes.text", "There will be times when you want to remove a gene entirely from a DNA sequence - this can be accomplished by placing the DNA container into the DNA Remover machine. A single gene will be selected randomly and removed from the sequence - it's not possible to select which one, so don't mess around when you only have a single container left. <br> In this way you can isolate a single gene.");
        this.addGuide("combining_genes.text", "DNA containers can be combined in the DNA combiner. Through this process the DNA sequences will be mixed, with the lower values being dominant. (There is no dominant crop type however; that will be selected at random.) The used DNA containers will not be consumed, so this can be an effective way to backup a DNA sequence as you attempt to isolate a gene.");
        this.addGuide("cleaning_containers.text", "Useless DNA containers can be cleaned up for reuse, by placing them in the DNA cleaner.");
        this.addGuide("creating_designerseeds.text", "Now the last step in getting personalized seeds is to put a DNA container and 500 biomass in the Seed Constructor. <br> Biomass is produced by the Seed Squeezer - the same stuff used in the Machinebulb Reprocessor. Again, the used DNA container will not be consumed. <br> All traits that are not present in the DNA container will be reset to their initial value. The default crop type is Carrot, and for the traits have a look at \"Crossbreeding: Crop traits\"");
        this.addGuide("test.text", Strings.repeat((String)"XX ", (int)675));
        this.addGuide("general_machines.text", "Machines in PlantTech 2 aren't just blocks that can be placed, they are complex symbioses of metal and plants. Therefore the process of obtaining the machines is more complex than you may be used to. <br> First of all the machines need a machine shell appropriate for the tier of the machine - lower tier machines need an iron machine shell, with higher tiers requiring a machine shell made from plantium. To obtain the machine shell, you need to place an Iron Block or Plantium Block next to a Carver Crop and wait. <br>  For the plant part you need the machinebulb of the desired machine. A Machinebulb Reprocessor is required for most of these, as well as a Seed Squeezer as a bioenergy source. (These two machinebulbs are the only ones that are obtainable by crafting.) When clicking on the correct machine shell with a bulb the machine will start growing and once finished, the machine is ready. <br> The Machinebulb Reprocessor requires a Knowledge Chip to access higher tiers of machinebulbs. This Chip collects information from machines while they're running, as long as the machine is not a lower tier than the chip. (To start, a Knowledge Chip v0.1 may be used in a Seed Squeezer, a Tier 0 machine.) Once the Knowledge Chip has collected enough information, it may be used in the Machinebulb Reprocessor to get better machinebulbs. (And the Knowledge Chip will only gain useful data from the new Tier 1 machines.)");
        this.addGuide("chipalyzer.text", "The Chipalyzer can analyze various items and record the data on Blank Upgrade Chips. The resulting chips can be slotted into PlantTech2 equipment to enhance its capabilities. (Some effects are stackable; refer to each chip's tooltip for more info.) Some of these chips can also be upgraded; the following pages will have more on this. <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> These chips are upgradeable with standard Chip Upgrade Packs. <br> <br> Attack Chip: Iron Sword <br> Attack Speed Chip: Golden Sword <br> <br> Armor Chip: Iron Chestplate <br> Toughness Chip: Diamond Chestplate <br> <br> Breakdown Rate Chip: Golden Pickaxe <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> This set of chips is upgradeable with their own special Upgrade Packs. <br> <br> Capacity Chip: Battery (0.5kBE) <br> Reactor Chip: Solar Focus MkI <br> Harvestlevel Chip: Wooden Pickaxe <br> Harvest Level Chip: Diamond Pickaxe <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> <br> The following chips are used to unlock additional right-click functions for the Multi-Tool. They are not upgradeable. <br> <br> Unlock Chip (Axe): Iron Axe <br> Unlock Chip (Hoe): Iron Hoe <br> Unlock Chip (Shears): Shears <br> Unlock Chip (Shovel): Iron Shovel <br> <br> <br> It is also possible to program Upgrade Chips with Enchantment data. These do not have multiple levels (so don't waste a Fortune III - you'll get a Fortune I chip), but the effects are stackable with multiple chips.");
        this.addGuide("compressor.text", "The Compressor converts crop particles into items. Some particles have more multiple options.");
        this.addGuide("dna_cleaner.text", "The DNA Cleaner sanitizes used DNA containers and prepares them for reuse.");
        this.addGuide("dna_combiner.text", "The DNA Combiner combines two sequences of DNA (lower values are dominant). The used sample sequences are not lost.");
        this.addGuide("dna_extractor.text", "The DNA Extractor stores the DNA sequence of a crop seed into an empty DNA container. This process destroys the seed.");
        this.addGuide("dna_remover.text", "The DNA Remover removes a single trait, selected randomly. Should be used to reduce the sequence to only good traits.");
        this.addGuide("energy_supplier.text", "The Energy Supplier does what the names says, it supplies energy for blocks like electric fences.");
        this.addGuide("identifier.text", "The Identifier is used to identify crop traits. It can also be used to convert vanilla seeds into PlantTech 2 seeds.");
        this.addGuide("infuser.text", "The Infuser infuses biomass into things like bonemeal to obtain fertilizer.");
        this.addGuide("machinebulb_reprocessor.text", "Takes energy and biomass to produce Machinebulbs. Available Machinebulbs are limited by the Knowledge Chip installed. Energy needed for each bulb: 1000.        Biomass needed: Compressor, Identifier, Energy Supplier -> 100; Infuser, Chipalyzer, Mega Furnace -> 1000; DNA Cleaner, DNA Combiner, DNA Extractor, DNA Remover, Seed Constructor, Void-Plantfarm, Solar Generator -> 2000;");
        this.addGuide("mega_furnace.text", "Powered with BE and has 6 slots for smelting.");
        this.addGuide("void_plantfarm.text", "You want to have cropproducts but don't want to have a farm consume your space? The void plantfarm takes a seed and will plant and farm the crops in the void dimension! It consumes energy to create a portal once it can harvest a crop and the production can be increased by putting a rangeupgrade in it! We can't access the dimension in person, but the machine can.");
        this.addGuide("seedconstructor.text", "The seedconstructor takes a sequence of dna, energy and biomass to creates seeds from it. The sequence will not be consumed. If a trait is not set in the sequence, it will be set to the default value.");
        this.addGuide("seed_squeezer.text", "The seed squeezer is a power generator fuelled by PlantTech2 seeds. The amount of power generated is determined by the seed's energy trait. Biomass is also produced, albeit at a fixed rate.");
        this.addGuide("solar_generator.text", "The solar generator needs a solar focus to produce energy. The higher the tier of the focus, the higher the production.");
    }

    private void addInfo() {
        this.addInfo("knowledge", "Knowledge");
        this.addInfo("tier", "Tier");
        this.addInfo("type", "type");
        this.addInfo("soil", "soil");
        this.addInfo("growspeed", "growth rate");
        this.addInfo("sensitivity", "sensitivity");
        this.addInfo("needed_lightlevel", "light level needed");
        this.addInfo("waterrange", "water range");
        this.addInfo("temperature", "temperature");
        this.addInfo("temperaturetolerance", "temperature tolerance");
        this.addInfo("productivity", "productivity");
        this.addInfo("fertility", "fertility");
        this.addInfo("spreedingspeed", "spreading speed");
        this.addInfo("genestrength", "gene strength");
        this.addInfo("energyvalue", "energy per seed");
        this.addInfo("unknown", "unknown");
        this.addInfo("only_creative", "Only for Creative Mode");
        this.addInfo("only_seeds", "Only for PlantTech 2 seeds");
        this.addInfo("no_space", "Not enough space in your inventory");
        this.addInfo("not_a_trait", "Not a trait");
        this.addInfo("fertilizer", "Chance");
        this.addInfo("fertilizer_creative", "Ignores requirements");
        this.addInfo("energy", "energy: %s");
        this.addInfo("energycosts", "energycosts per action: %s");
        this.addInfo("openwithshift", "Shift-rightclick to open inventory");
        this.addInfo("upgradechip.increasecapacity", "+%s energy capacity per chip");
        this.addInfo("upgradechip.increasecapacitymax", "Max energy capacity: %s");
        this.addInfo("upgradechip.energyproduction", "+%s energy production per chip");
        this.addInfo("upgradechip.increaseharvestlevel", "Max energy production: %s");
        this.addInfo("upgradechip.increasearmor", "+%s armor per chip");
        this.addInfo("upgradechip.increaseattack", "+%s attack per chip");
        this.addInfo("upgradechip.increaseattackmax", "Max attack: %s ");
        this.addInfo("upgradechip.increaseattackspeed", "+%s attack speed per chip");
        this.addInfo("upgradechip.increaseattackspeedmax", "Max attack speed: %s");
        this.addInfo("upgradechip.increasebreakdownrate", "+%s breakdown rate per chip");
        this.addInfo("upgradechip.increasebreakdownratemax", "Max breakdown rate: %s");
        this.addInfo("upgradechip.increasetougness", "+%s toughness per chip");
        this.addInfo("upgradechip.increasetougnessmax", "Max toughness: %s");
        this.addInfo("upgradechip.unlockaxefeat", "Unlocks axe features");
        this.addInfo("upgradechip.unlockshovelfeat", "Unlocks shovel features");
        this.addInfo("upgradechip.unlockshearsfeat", "Unlocks shears features");
        this.addInfo("upgradechip.unlockhoefeat", "Unlocks hoe features");
        this.addInfo("upgradechip.energycosts", "+%s energy costs per chip");
        this.addInfo("upgradechip.add", "Add");
        this.addInfo("upgradechip.stackable", "Enchantment can be stacked");
        this.addInfo("any_enchanted_item", "Any item with this enchantment. Level doesn`t matter");
        this.addInfo("wrench_cable", "Right-click cable connections to toggle");
        this.addInfo("wrench_dismantle", "Right-click while sneaking to dismantle PlantTech2 machines and cables");
    }

    public static Map<String, String> defaultCrops() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"abyssalnite", (Object)"Abyssalnite");
        map.put((Object)"adamantine", (Object)"Adamantine");
        map.put((Object)"allium", (Object)"Allium");
        map.put((Object)"aluminum", (Object)"Aluminum");
        map.put((Object)"aluminum_brass", (Object)"Aluminum Brass");
        map.put((Object)"alumite", (Object)"Alumite");
        map.put((Object)"amber", (Object)"Amber");
        map.put((Object)"apatite", (Object)"Apatite");
        map.put((Object)"aquamarine", (Object)"Aquamarine");
        map.put((Object)"ardite", (Object)"Ardite");
        map.put((Object)"awakened_draconium", (Object)"Awakened Draconium");
        map.put((Object)"azure_bluet", (Object)"Azure Bluet");
        map.put((Object)"bamboo", (Object)"Bamboo");
        map.put((Object)"basalt", (Object)"Basalt");
        map.put((Object)"beast", (Object)"Ravager");
        map.put((Object)"beetroots", (Object)"Beetroots");
        map.put((Object)"black_quartz", (Object)"Black Quartz");
        map.put((Object)"blaze", (Object)"Blaze");
        map.put((Object)"blitz", (Object)"Blitz");
        map.put((Object)"blizz", (Object)"Blizz");
        map.put((Object)"blue_topaz", (Object)"Blue Topaz");
        map.put((Object)"blue_orchid", (Object)"Blue Orchid");
        map.put((Object)"brass", (Object)"Brass");
        map.put((Object)"bronze", (Object)"Bronze");
        map.put((Object)"cactus", (Object)"Cactus");
        map.put((Object)"carrot", (Object)"Carrot");
        map.put((Object)"certus_quartz", (Object)"Certus Quartz");
        map.put((Object)"chicken", (Object)"Chicken");
        map.put((Object)"chimerite", (Object)"Chimerite");
        map.put((Object)"chorus", (Object)"Chorus");
        map.put((Object)"chrome", (Object)"Chrome");
        map.put((Object)"coal", (Object)"Coal");
        map.put((Object)"cobalt", (Object)"Cobalt");
        map.put((Object)"cocoa_bean", (Object)"Cocoa Bean");
        map.put((Object)"cold_iron", (Object)"Cold Iron");
        map.put((Object)"compressed_iron", (Object)"Compressed Iron");
        map.put((Object)"conductive_iron", (Object)"Conductive Iron");
        map.put((Object)"constantan", (Object)"Constantan");
        map.put((Object)"copper", (Object)"Copper");
        map.put((Object)"coralium", (Object)"Coralium");
        map.put((Object)"cornflower", (Object)"Cornflower");
        map.put((Object)"cow", (Object)"Cow");
        map.put((Object)"creeper", (Object)"Creeper");
        map.put((Object)"dancium", (Object)"Dancium");
        map.put((Object)"dandelion", (Object)"Dandelion");
        map.put((Object)"dark_gem", (Object)"Dark Gem");
        map.put((Object)"dark_steel", (Object)"Dark Steel");
        map.put((Object)"desh", (Object)"Desh");
        map.put((Object)"diamond", (Object)"Diamond");
        map.put((Object)"dirt", (Object)"Dirt");
        map.put((Object)"draconium", (Object)"Draconium");
        map.put((Object)"dreadium", (Object)"Dreadium");
        map.put((Object)"drowned", (Object)"Drowned");
        map.put((Object)"electrical_steel", (Object)"Electrical Steel");
        map.put((Object)"electrotine", (Object)"Electrotine");
        map.put((Object)"electrum", (Object)"Electrum");
        map.put((Object)"elementium", (Object)"Elementium");
        map.put((Object)"emerald", (Object)"Emerald");
        map.put((Object)"end_steel", (Object)"End Steel");
        map.put((Object)"ender_amethyst", (Object)"Ender Amethyst");
        map.put((Object)"ender_biotite", (Object)"Ender Biotite");
        map.put((Object)"enderdragon", (Object)"Enderdragon");
        map.put((Object)"enderium", (Object)"Enderium");
        map.put((Object)"enderman", (Object)"Enderman");
        map.put((Object)"endstone", (Object)"Endstone");
        map.put((Object)"energetic_alloy", (Object)"Energetic Alloy");
        map.put((Object)"fish", (Object)"Fish");
        map.put((Object)"fluix_crystal", (Object)"Fluix Crystal");
        map.put((Object)"fluxed_electrum", (Object)"Fluxed Electrum");
        map.put((Object)"ghast", (Object)"Ghast");
        map.put((Object)"glowstone", (Object)"Glowstone");
        map.put((Object)"glowstone_ingot", (Object)"Glowstone Ingot");
        map.put((Object)"gold", (Object)"Gold");
        map.put((Object)"graphite", (Object)"Graphite");
        map.put((Object)"guardian", (Object)"Guardian");
        map.put((Object)"husk", (Object)"Husk");
        map.put((Object)"illager", (Object)"Illager");
        map.put((Object)"invar", (Object)"Invar");
        map.put((Object)"iridium", (Object)"Iridium");
        map.put((Object)"iron", (Object)"Iron");
        map.put((Object)"kanekium", (Object)"Kanekium");
        map.put((Object)"kelp", (Object)"Kelp");
        map.put((Object)"kinnoium", (Object)"Kinnoium");
        map.put((Object)"knightslime", (Object)"Knightslime");
        map.put((Object)"lapis", (Object)"Lapis");
        map.put((Object)"lava", (Object)"Lava");
        map.put((Object)"lead", (Object)"Lead");
        map.put((Object)"lenthurium", (Object)"Lenthurium");
        map.put((Object)"lilly_of_the_valley", (Object)"Lily Of The Valley");
        map.put((Object)"lithium", (Object)"Lithium");
        map.put((Object)"lumium", (Object)"Lumium");
        map.put((Object)"magma_cube", (Object)"Magma Cube");
        map.put((Object)"magnesium", (Object)"Magnesium");
        map.put((Object)"malachite", (Object)"Malachite");
        map.put((Object)"manasteel", (Object)"Manasteel");
        map.put((Object)"manyullyn", (Object)"Manyullyn");
        map.put((Object)"melon", (Object)"Melon");
        map.put((Object)"meteoric_iron", (Object)"Meteoric Iron");
        map.put((Object)"mithril", (Object)"Mithril");
        map.put((Object)"moonstone", (Object)"Moonstone");
        map.put((Object)"mooshroom", (Object)"Mooshroom");
        map.put((Object)"mushroom", (Object)"Mushroom");
        map.put((Object)"mycelium", (Object)"Mycelium");
        map.put((Object)"nether_wart", (Object)"Nether Wart");
        map.put((Object)"netherrack", (Object)"Netherrack");
        map.put((Object)"neutronium", (Object)"Neutronium");
        map.put((Object)"nickel", (Object)"Nickel");
        map.put((Object)"octine", (Object)"Octine");
        map.put((Object)"orange_tulip", (Object)"Orange Tulip");
        map.put((Object)"osmium", (Object)"Osmium");
        map.put((Object)"oxeye_daisy", (Object)"Oxeye Daisy");
        map.put((Object)"panda", (Object)"Panda");
        map.put((Object)"parrot", (Object)"Parrot");
        map.put((Object)"peridot", (Object)"Peridot");
        map.put((Object)"pig", (Object)"Pig");
        map.put((Object)"pink_tulip", (Object)"Pink Tulip");
        map.put((Object)"plantium", (Object)"Plantium");
        map.put((Object)"platinum", (Object)"Platinum");
        map.put((Object)"polarbear", (Object)"Polarbear");
        map.put((Object)"poppy", (Object)"Poppy");
        map.put((Object)"potato", (Object)"Potato");
        map.put((Object)"prismarine", (Object)"Prismarine");
        map.put((Object)"pulsating_iron", (Object)"Pulsating Iron");
        map.put((Object)"pumpkin", (Object)"Pumpkin");
        map.put((Object)"quartz", (Object)"Quartz");
        map.put((Object)"quicksilver", (Object)"Quicksilver");
        map.put((Object)"red_tulip", (Object)"Red Tulip");
        map.put((Object)"redstone", (Object)"Redstone");
        map.put((Object)"redstone_alloy", (Object)"Redstone Alloy");
        map.put((Object)"refined_obsidian", (Object)"Refined Obsidian");
        map.put((Object)"rock_crystal", (Object)"Rock Crystal");
        map.put((Object)"rubber", (Object)"Rubber");
        map.put((Object)"ruby", (Object)"Ruby");
        map.put((Object)"saltpeter", (Object)"Saltpeter");
        map.put((Object)"sand", (Object)"Sand");
        map.put((Object)"sapphire", (Object)"Sapphire");
        map.put((Object)"sheep", (Object)"Sheep");
        map.put((Object)"shulker", (Object)"Shulker");
        map.put((Object)"signalum", (Object)"Signalum");
        map.put((Object)"silicon", (Object)"Silicon");
        map.put((Object)"silver", (Object)"Silver");
        map.put((Object)"skeleton", (Object)"Skeleton");
        map.put((Object)"sky_stone", (Object)"Sky Stone");
        map.put((Object)"slate", (Object)"Slate");
        map.put((Object)"slime", (Object)"Slime");
        map.put((Object)"slimy_bone", (Object)"Slimy Bone");
        map.put((Object)"snow", (Object)"Snow");
        map.put((Object)"soularium", (Object)"Soularium");
        map.put((Object)"soulsand", (Object)"Soulsand");
        map.put((Object)"spider", (Object)"Spider");
        map.put((Object)"sponge", (Object)"Sponge");
        map.put((Object)"squid", (Object)"Squid");
        map.put((Object)"star_steel", (Object)"Star Steel");
        map.put((Object)"starmetal", (Object)"Starmetal");
        map.put((Object)"steel", (Object)"Steel");
        map.put((Object)"stone", (Object)"Stone");
        map.put((Object)"stray", (Object)"Stray");
        map.put((Object)"sugarcane", (Object)"Sugarcane");
        map.put((Object)"sulfur", (Object)"Sulfur");
        map.put((Object)"sunstone", (Object)"Sunstone");
        map.put((Object)"syrmorite", (Object)"Syrmorite");
        map.put((Object)"tanzanite", (Object)"Tanzanite");
        map.put((Object)"terrasteel", (Object)"Terrasteel");
        map.put((Object)"thaumium", (Object)"Thaumium");
        map.put((Object)"tin", (Object)"Tin");
        map.put((Object)"titanium", (Object)"Titanium");
        map.put((Object)"topaz", (Object)"Topaz");
        map.put((Object)"tungsten", (Object)"Tungsten");
        map.put((Object)"turtle", (Object)"Turtle");
        map.put((Object)"uranium", (Object)"Uranium");
        map.put((Object)"valonite", (Object)"Valonite");
        map.put((Object)"vibrant_alloy", (Object)"Vibrant Alloy");
        map.put((Object)"villager", (Object)"Villager");
        map.put((Object)"vine", (Object)"Vine");
        map.put((Object)"vinteum", (Object)"Vinteum");
        map.put((Object)"void_metal", (Object)"Void Metal");
        map.put((Object)"water", (Object)"Water");
        map.put((Object)"wheat", (Object)"Wheat");
        map.put((Object)"white_tulip", (Object)"White Tulip");
        map.put((Object)"witch", (Object)"Witch");
        map.put((Object)"wither", (Object)"Wither");
        map.put((Object)"wither_rose", (Object)"Wither Rose");
        map.put((Object)"wither_skeleton", (Object)"Wither Skeleton");
        map.put((Object)"wood", (Object)"Wood");
        map.put((Object)"yellorium", (Object)"Yellorium");
        map.put((Object)"zinc", (Object)"Zinc");
        map.put((Object)"zombie", (Object)"Zombie");
        map.put((Object)"zombie_pigman", (Object)"Zombie Pigman");
        map.put((Object)"zombie_villager", (Object)"Zombie Villager");
        return map.build();
    }

    public void addInfo(String key, String value) {
        this.add("info." + key, value);
    }

    public void addGuide(String key, String value) {
        this.add("guide", key, value);
    }

    public void add(String category, String subKey, String value) {
        this.add(category + "." + "planttech2" + (!subKey.isEmpty() ? "." + subKey : ""), value);
    }
}

