/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>>();

    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        this.tables.clear();
        this.standardDropTable(ModBlocks.CABLE);
        this.standardDropTable(ModBlocks.CARVER);
        this.standardDropTable(ModBlocks.CHIPALYZER);
        this.standardDropTable(ModBlocks.COMPRESSOR);
        this.standardDropTable(ModBlocks.CROPBARS);
        this.standardDropTable(ModBlocks.DANCIUM_BLOCK);
        this.standardDropTable(ModBlocks.DNA_CLEANER);
        this.standardDropTable(ModBlocks.DNA_COMBINER);
        this.standardDropTable(ModBlocks.DNA_EXTRACTOR);
        this.standardDropTable(ModBlocks.DNA_REMOVER);
        this.standardDropTable(ModBlocks.ENERGYSTORAGE);
        this.standardDropTable(ModBlocks.ENERGY_SUPPLIER);
        this.standardDropTable(ModBlocks.IDENTIFIER);
        this.standardDropTable(ModBlocks.INFUSER);
        this.standardDropTable(ModBlocks.KANEKIUM_BLOCK);
        this.standardDropTable(ModBlocks.KINNOIUM_BLOCK);
        this.standardDropTable(ModBlocks.LENTHURIUM_BLOCK);
        this.standardDropTable(ModBlocks.MACHINEBULBREPROCESSOR);
        this.standardDropTable(ModBlocks.MACHINESHELL_IRON);
        this.standardDropTable(ModBlocks.MACHINESHELL_PLANTIUM);
        this.standardDropTable(ModBlocks.MEGAFURNACE);
        this.standardDropTable(ModBlocks.PLANTFARM);
        this.standardDropTable(ModBlocks.PLANTIUM_BLOCK);
        this.standardDropTable(ModBlocks.SEEDCONSTRUCTOR);
        this.standardDropTable(ModBlocks.SEEDSQUEEZER);
        this.standardDropTable(ModBlocks.SOLARGENERATOR);
        this.standardDropTable(ModBlocks.UNIVERSAL_SOIL);
        this.standardDropTable(ModBlocks.UNIVERSAL_SOIL_INFUSED);
        this.silkFortuneBlockTable(ModBlocks.DARK_CRYSTAL_ORE, (IItemProvider)ModItems.DARK_CRYSTAL);
        this.silkFortuneBlockTable(ModBlocks.WHITE_CRYSTAL_ORE, (IItemProvider)ModItems.WHITE_CRYSTAL);
        ModBlocks.HEDGE_BLOCKS.forEach(this::standardDropTable);
        return this.tables;
    }

    void silkFortuneBlockTable(Block b, IItemProvider item) {
        LootPool.Builder pool = LootPool.func_216096_a();
        pool.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1));
        StandaloneLootEntry.Builder silk = (StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)b).func_212840_b_(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1)))));
        StandaloneLootEntry.Builder fortune = ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t));
        pool.func_216045_a((LootEntry.Builder)AlternativesLootEntry.func_216149_a((LootEntry.Builder[])new LootEntry.Builder[]{silk, fortune}));
        this.blockTable(b, LootTable.func_216119_b().func_216040_a(pool));
    }

    void standardDropTable(Block b) {
        this.blockTable(b, LootTable.func_216119_b().func_216040_a(this.createStandardDrops((IItemProvider)b)));
    }

    void blockTable(Block b, LootTable.Builder lootTable) {
        this.addTable(b.func_220068_i(), lootTable, LootParameterSets.field_216267_h);
    }

    void addTable(ResourceLocation path, LootTable.Builder lootTable, LootParameterSet paramSet) {
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(path, lootTable), (Object)paramSet));
    }

    LootPool.Builder createStandardDrops(IItemProvider itemProvider) {
        return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemProvider));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }
}

