/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.capabilities.player;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kaneka.planttech2.entities.capabilities.player.IPlayerRenderRGB;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerRenderRGB
implements ICapabilitySerializable<CompoundNBT>,
IPlayerRenderRGB {
    @CapabilityInject(value=IPlayerRenderRGB.class)
    public static Capability<IPlayerRenderRGB> PLAYER_RENDER_RGB_CAPABILITY = null;
    private final LazyOptional<IPlayerRenderRGB> lazyOptional = LazyOptional.of(PlayerRenderRGB::new);
    private float[] rgb = new float[3];
    private float fogDensity;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == PLAYER_RENDER_RGB_CAPABILITY ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public static IPlayerRenderRGB getCap(PlayerEntity player) {
        return (IPlayerRenderRGB)player.getCapability(PLAYER_RENDER_RGB_CAPABILITY).orElseThrow(() -> new NullPointerException("getting capability"));
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)PLAYER_RENDER_RGB_CAPABILITY.getStorage().writeNBT(PLAYER_RENDER_RGB_CAPABILITY, this.lazyOptional.orElseThrow(() -> new NullPointerException("An error has occur during writing Render RGB Capability by Plant Tech 2")), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        PLAYER_RENDER_RGB_CAPABILITY.getStorage().readNBT(PLAYER_RENDER_RGB_CAPABILITY, this.lazyOptional.orElseThrow(() -> new NullPointerException("An error has occur during reading Render RGB Capability by Plant Tech 2")), null, (INBT)nbt);
    }

    @Override
    public float[] getRGB() {
        return this.rgb;
    }

    @Override
    public float getCurrentRed() {
        return this.rgb[0];
    }

    @Override
    public float getCurrentGreen() {
        return this.rgb[1];
    }

    @Override
    public float getCurrentBlue() {
        return this.rgb[2];
    }

    @Override
    public float getCurrentFogDensity() {
        return this.fogDensity;
    }

    @Override
    public void setRGB(float[] rgb) {
        this.setCurrentRed(rgb[0]);
        this.setCurrentGreen(rgb[1]);
        this.setCurrentBlue(rgb[2]);
    }

    @Override
    public void setRGB(float r, float g, float b) {
        this.setRGB(new float[]{r, g, b});
    }

    @Override
    public void setCurrentRed(float value) {
        this.rgb[0] = value < 0.0f ? 0.0f : Math.min(value, 255.0f);
    }

    @Override
    public void changeCurrentRed(float amount) {
        this.setCurrentRed(this.getCurrentRed() + amount);
    }

    @Override
    public void setCurrentGreen(float value) {
        this.rgb[1] = value < 0.0f ? 0.0f : Math.min(value, 255.0f);
    }

    @Override
    public void changeCurrentGreen(float amount) {
        this.setCurrentGreen(this.getCurrentGreen() + amount);
    }

    @Override
    public void setCurrentBlue(float value) {
        this.rgb[2] = value < 0.0f ? 0.0f : Math.min(value, 255.0f);
    }

    @Override
    public void changeCurrentBlue(float amount) {
        this.setCurrentBlue(this.getCurrentBlue() + amount);
    }

    @Override
    public void setCurrentFogDensity(float value) {
        this.fogDensity = value;
    }

    public static class PlayerRenderRGBStorage
    implements Capability.IStorage<IPlayerRenderRGB> {
        @Nullable
        public INBT writeNBT(Capability<IPlayerRenderRGB> capability, IPlayerRenderRGB instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74776_a("red", instance.getCurrentRed());
            compound.func_74776_a("green", instance.getCurrentGreen());
            compound.func_74776_a("blue", instance.getCurrentBlue());
            compound.func_74776_a("density", instance.getCurrentFogDensity());
            return compound;
        }

        public void readNBT(Capability<IPlayerRenderRGB> capability, IPlayerRenderRGB instance, Direction side, INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            instance.setRGB(compound.func_74760_g("red"), compound.func_74760_g("green"), compound.func_74760_g("blue"));
            instance.setCurrentFogDensity(compound.func_74760_g("density"));
        }
    }
}

