/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.enums;

import javax.annotation.Nullable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum EnumTemperature {
    EXTREME_COLD(-1.0f, 0.0f, TextFormatting.BLUE),
    COLD(0.0f, 0.5f, TextFormatting.AQUA),
    NORMAL(0.5f, 1.0f, TextFormatting.GREEN),
    WARM(1.0f, 1.5f, TextFormatting.YELLOW),
    EXTREME_WARM(1.5f, 2.5f, TextFormatting.RED);

    private final float min;
    private final float max;
    private final TextFormatting color;

    private EnumTemperature(float min, float max, TextFormatting color) {
        this.min = min;
        this.max = max;
        this.color = color;
    }

    public IFormattableTextComponent getDisplayString() {
        return new TranslationTextComponent("temp." + this.name().toLowerCase()).func_240699_a_(this.color);
    }

    public boolean inRange(float value, int tolerance) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (this.ordinal() - tolerance > temp.ordinal() || temp.ordinal() > this.ordinal() + tolerance || !(temp.min <= value) || !(temp.max > value)) continue;
            return true;
        }
        return false;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public static EnumTemperature byValue(float value) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!(temp.min <= value) || !(temp.max > value)) continue;
            return temp;
        }
        return NORMAL;
    }

    @Nullable
    public static EnumTemperature byName(String name) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!temp.name().equals(name)) continue;
            return temp;
        }
        return null;
    }
}

