/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import net.kaneka.planttech2.gui.GuidePlantsScreen;
import net.kaneka.planttech2.gui.guide.GuideScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ForgeBusEventsClient {
    public static boolean hasSendUpdateAvailable = false;

    @SubscribeEvent
    public static void onTextInsert(ClientChatEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        int screen = 0;
        switch (event.getOriginalMessage()) {
            case "/pt2 guide overview": {
                screen = 1;
                break;
            }
            case "/pt2 guide plant": {
                screen = 2;
            }
        }
        if (screen != 0) {
            player.getPersistentData().func_74768_a("planttech2_screen_delay", screen);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        CompoundNBT data;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (data = player.getPersistentData()).func_74764_b("planttech2_screen_delay")) {
            Screen screen = null;
            switch (data.func_74762_e("planttech2_screen_delay")) {
                case 1: {
                    screen = new GuideScreen();
                    break;
                }
                case 2: {
                    screen = new GuidePlantsScreen();
                }
            }
            if (screen != null) {
                Minecraft.func_71410_x().func_147108_a(screen);
                data.func_74768_a("planttech2_screen_delay", 0);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldStart(EntityJoinWorldEvent evt) {
        VersionChecker.CheckResult res = VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerById("planttech2").get()).getModInfo());
        if (evt.getEntity() instanceof ClientPlayerEntity && res.status == VersionChecker.Status.OUTDATED && !hasSendUpdateAvailable) {
            TranslationTextComponent info = new TranslationTextComponent("planttech2.update.available");
            TranslationTextComponent link = new TranslationTextComponent("planttech2.update.click");
            link.func_230530_a_(link.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/planttech-2/files")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("planttech2.update.tooltip"))).func_240712_a_(TextFormatting.BLUE).setUnderlined(Boolean.valueOf(true)));
            evt.getEntity().func_145747_a((ITextComponent)info.func_230529_a_((ITextComponent)link), evt.getEntity().func_110124_au());
        }
        hasSendUpdateAvailable = true;
    }
}

