/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechClient;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.ParticleItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModFluids;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModRenderer;
import net.kaneka.planttech2.registries.ModScreens;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="planttech2", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModBusEventsClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(PlantTechClient::addAllItemModelsOverrides);
        ModRenderer.registerEntityRenderer();
        ModScreens.registerGUI();
        for (Supplier<? extends Block> block : ModBlocks.SPECIAL_RENDER_BLOCKS) {
            RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)RenderType.func_228643_e_());
        }
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.BIOMASSFLUIDBLOCK, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIOMASS, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIOMASS_FLOWING, (RenderType)RenderType.func_228645_f_());
    }

    @SubscribeEvent
    public static void registerColorItem(ColorHandlerEvent.Item event) {
        for (Item entry : ModItems.PARTICLES.values()) {
            event.getItemColors().func_199877_a((IItemColor)new ParticleItem.ColorHandler(), new IItemProvider[]{entry});
        }
        for (Item entry : ModItems.SEEDS.values()) {
            event.getItemColors().func_199877_a((IItemColor)new CropSeedItem.ColorHandler(), new IItemProvider[]{entry});
        }
        for (Hedge block : ModBlocks.HEDGE_BLOCKS) {
            event.getItemColors().func_199877_a((IItemColor)new Hedge.ColorHandlerItem(block.getLeaves()), new IItemProvider[]{block});
        }
    }

    @SubscribeEvent
    public static void registerColorBlock(ColorHandlerEvent.Block event) {
        for (CropBaseBlock cropBaseBlock : ModBlocks.CROPS.values()) {
            event.getBlockColors().func_186722_a((IBlockColor)new CropBaseBlock.ColorHandler(), new Block[]{cropBaseBlock});
        }
        for (Hedge hedge : ModBlocks.HEDGE_BLOCKS) {
            event.getBlockColors().func_186722_a((IBlockColor)new Hedge.ColorHandler(hedge.getLeaves(), hedge.getSoil()), new Block[]{hedge});
        }
    }
}

