/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import net.kaneka.planttech2.datagen.BlockModelGenerator;
import net.kaneka.planttech2.datagen.DefaultCropConfigProvider;
import net.kaneka.planttech2.datagen.ItemModelGenerator;
import net.kaneka.planttech2.datagen.Languages;
import net.kaneka.planttech2.datagen.LootTables;
import net.kaneka.planttech2.datagen.Recipes;
import net.kaneka.planttech2.recipes.ModRecipeSerializers;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModContainers;
import net.kaneka.planttech2.registries.ModEffects;
import net.kaneka.planttech2.registries.ModEntityTypes;
import net.kaneka.planttech2.registries.ModFluids;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModSounds;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEvents {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        ModTileEntities.register(event.getRegistry());
    }

    @SubscribeEvent
    public static void registerContainer(RegistryEvent.Register<ContainerType<?>> event) {
        ModContainers.registerAll(event);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ModRecipeSerializers.registerAll(event);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.registerAll((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Effect> event) {
        ModEffects.registerAll((IForgeRegistry<Effect>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        ModEntityTypes.registerAll(event.getRegistry());
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper eFH = event.getExistingFileHelper();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new Languages(gen));
            gen.func_200390_a((IDataProvider)new BlockModelGenerator(gen, eFH));
            gen.func_200390_a((IDataProvider)new ItemModelGenerator(gen, eFH));
        }
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new Recipes(gen));
            gen.func_200390_a((IDataProvider)new LootTables(gen));
            gen.func_200390_a((IDataProvider)new DefaultCropConfigProvider(gen));
        }
    }

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Fluid> event) {
        ModFluids.register((IForgeRegistry<Fluid>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onMissingMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String path;
            switch (path = mapping.key.func_110623_a()) {
                case "prismarin_seeds": {
                    mapping.remap((IForgeRegistryEntry)ModItems.SEEDS.get("prismarine_seeds"));
                    break;
                }
                case "prismarin_particles": {
                    mapping.remap((IForgeRegistryEntry)ModItems.PARTICLES.get("prismarine_particles"));
                }
            }
        }
    }
}

