/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.kaneka.planttech2.items.GuideItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuideBaseScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2", "textures/gui/plantencyclopaedia_big.png");
    protected static final int TEXT_COLOR = 59395;
    protected int xSize = 512;
    protected int ySize = 196;
    protected int guiLeft;
    protected int guiTop;
    protected int scrollMax;
    protected int scrollPos = 0;
    protected int fadeInTimer = 50;
    protected boolean hasSelection;
    protected boolean allowScroll;

    public GuideBaseScreen(int scrollMax, boolean allowScroll, String title) {
        super((ITextComponent)new TranslationTextComponent(title));
        this.scrollMax = scrollMax;
        this.allowScroll = allowScroll;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof GuideItem) {
            Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_196085_b(1);
        }
        this.hasSelection = false;
        this.guiLeft = (this.field_230708_k_ - 400) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
    }

    protected abstract void updateButtons();

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        if (this.fadeInTimer > 0) {
            --this.fadeInTimer;
            this.drawFadeInEffect(mStack);
        } else {
            this.drawBackground(mStack);
            this.drawForeground(mStack);
            this.drawButtons(mStack, mouseX, mouseY, partialTicks);
            this.drawStrings(mStack);
            this.drawTooltips(mStack, mouseX, mouseY);
        }
    }

    private void drawButtons(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.field_230710_m_) {
            button.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground(MatrixStack mStack) {
        GuideBaseScreen.func_238463_a_((MatrixStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        GuideBaseScreen.func_238463_a_((MatrixStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }

    protected abstract void drawForeground(MatrixStack var1);

    private void drawFadeInEffect(MatrixStack mStack) {
        float percentage = 1.0f - (float)this.fadeInTimer / 50.0f;
        GuideBaseScreen.func_238463_a_((MatrixStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)((float)this.xSize - 300.0f * percentage), (float)0.0f, (int)((int)(300.0f * percentage)), (int)this.ySize, (int)512, (int)512);
        GuideBaseScreen.func_238463_a_((MatrixStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.allowScroll && mouseX != 0.0) {
            this.scrollPos += delta > 0.0 ? -1 : 1;
            this.scrollPos = Math.max(0, this.scrollPos);
            this.scrollPos = Math.min(this.scrollMax, this.scrollPos);
            this.updateButtons();
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    protected abstract void drawStrings(MatrixStack var1);

    public void renderItem(ItemStack itemstack, int x, int y) {
        this.field_230707_j_.func_180450_b(itemstack, this.guiLeft + x, this.guiTop + y);
    }

    public void drawTooltip(MatrixStack mStack, ITextComponent lines, int mouseX, int mouseY, int posX, int posY) {
        this.drawTooltip(mStack, lines, mouseX, mouseY, posX, posY, 16, 16);
    }

    public void drawTooltip(MatrixStack mStack, ITextComponent lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height) {
            this.func_238652_a_(mStack, lines, mouseX, mouseY);
        }
    }

    protected abstract void drawTooltips(MatrixStack var1, int var2, int var3);

    public void func_231164_f_() {
        if (Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof GuideItem) {
            Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_196085_b(0);
        }
        super.func_231164_f_();
    }
}

