/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.kaneka.planttech2.container.ItemUpgradeableContainer;
import net.kaneka.planttech2.items.upgradeable.BaseUpgradeableItem;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemUpgradeableScreen
extends ContainerScreen<ItemUpgradeableContainer> {
    protected static final Map<Integer, ResourceLocation> BACKGROUND = new HashMap<Integer, ResourceLocation>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(10, new ResourceLocation("planttech2:textures/gui/container/itemupgradeable_10.png"));
        }
    };
    protected final PlayerInventory player;
    protected ItemStack stack;
    protected int invsize;
    protected IEnergyStorage energystorage;

    public ItemUpgradeableScreen(ItemUpgradeableContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.player = inv;
        this.stack = container.getStack();
        this.invsize = BaseUpgradeableItem.getInventorySize(this.stack);
        this.energystorage = BaseUpgradeableItem.getEnergyCap(this.stack);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_146999_f = 205;
        this.field_147000_g = 202;
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.drawTooltips(mStack, mouseX, mouseY);
        this.func_230459_a_(mStack, mouseX, mouseY);
    }

    protected void drawTooltips(MatrixStack mStack, int mouseX, int mouseY) {
        if (this.energystorage != null) {
            this.drawTooltip(mStack, this.energystorage.getEnergyStored() + "/" + this.energystorage.getMaxEnergyStored(), mouseX, mouseY, 162, 28, 16, 74);
        }
    }

    public void drawTooltip(MatrixStack mStack, String lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            this.func_238653_a_(mStack, null, mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack mStack, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND.get(this.invsize));
        this.func_238474_b_(mStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = this.getEnergyStoredScaled(55);
        this.func_238474_b_(mStack, this.field_147003_i + 149, this.field_147009_r + 28 + (55 - k), 208, 55 - k, 16, 0 + k);
    }

    protected int getEnergyStoredScaled(int pixels) {
        if (this.energystorage != null) {
            int i = this.energystorage.getEnergyStored();
            int j = this.energystorage.getMaxEnergyStored();
            return i != 0 && j != 0 ? i * pixels / j : 0;
        }
        return 0;
    }

    protected boolean func_195363_d(int keyCode, int scanCode) {
        return false;
    }
}

