/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.container.entities.TechVillagerContainer;
import net.kaneka.planttech2.entities.capabilities.techvillagertrust.ITechVillagerTrust;
import net.kaneka.planttech2.entities.capabilities.techvillagertrust.TechVillagerTrust;
import net.kaneka.planttech2.entities.passive.TechVillagerEntity;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTask;
import net.kaneka.planttech2.entities.tradesandjobs.TechVillagerTrade;
import net.kaneka.planttech2.packets.DoTechVillagerTaskMessage;
import net.kaneka.planttech2.packets.DoTechVillagerTradeMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.PlayerInventoryUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.IEnergyStorage;

public class TechVillagerScreen
extends ContainerScreen<TechVillagerContainer> {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2:textures/gui/container/techvillager.png");
    protected final PlayerInventory player;
    protected int invsize;
    protected IEnergyStorage energystorage;
    protected TechVillagerTrade selectedTrade = null;
    protected TechVillagerTask selectedTask = null;
    protected int selectedID = -1;
    protected List<ITextComponent> canTradeTextProperties = new ArrayList<ITextComponent>();
    private String profession = "scientist";
    private String professionname = "loading";
    private int playertrustlevel = 0;

    public TechVillagerScreen(TechVillagerContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.player = inv;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_146999_f = 442;
        this.field_147000_g = 196;
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.canTradeTextProperties = this.getCanTradeTextProperties();
        this.profession = TechVillagerEntity.getProfessionString(((TechVillagerContainer)this.field_147002_h).getProfession());
        this.professionname = new TranslationTextComponent("techvillager.profession." + TechVillagerEntity.getProfessionString(((TechVillagerContainer)this.field_147002_h).getProfession())).getString();
        this.checkPlayerTrustLevel();
    }

    private void checkPlayerTrustLevel() {
        ITechVillagerTrust trust = (ITechVillagerTrust)this.player.field_70458_d.getCapability(TechVillagerTrust.INSTANCE).orElse(null);
        if (trust != null) {
            this.playertrustlevel = trust.getLevel(this.profession);
        }
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.checkPlayerTrustLevel();
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.renderSelectedTrades();
        this.func_230459_a_(mStack, mouseX, mouseY);
        this.renderTooltips(mStack, mouseX, mouseY);
    }

    protected void renderSelectedTrades() {
        RenderHelper.func_74518_a();
        RenderSystem.enableDepthTest();
        if (this.selectedTrade != null) {
            int i;
            for (i = 0; i < this.selectedTrade.getInputs().size(); ++i) {
                this.renderItem(this.selectedTrade.getInputs().get(i), 147 + i % 3 * 18, 71 + i / 3 * 18);
            }
            for (i = 0; i < this.selectedTrade.getOutputs().size(); ++i) {
                this.renderItem(this.selectedTrade.getOutputs().get(i), 255 + i % 3 * 18, 71 + i / 3 * 18);
            }
        } else if (this.selectedTask != null) {
            for (int i = 0; i < this.selectedTask.getInputs().size(); ++i) {
                this.renderItem(this.selectedTask.getInputs().get(i), 147 + i % 2 * 18, 53 + i / 2 * 18);
            }
        }
        RenderSystem.enableDepthTest();
    }

    public void renderTooltips(MatrixStack mStack, int mouseX, int mouseY) {
        ITechVillagerTrust trust;
        int level;
        if (this.canTradeTextProperties.size() > 0) {
            if (this.selectedTrade != null) {
                this.drawTooltip(mStack, this.canTradeTextProperties, mouseX, mouseY, 202, 87, 50, 20);
            } else if (this.selectedTask != null) {
                this.drawTooltip(mStack, this.canTradeTextProperties, mouseX, mouseY, 185, 87, 50, 20);
            }
        }
        if ((level = (trust = (ITechVillagerTrust)this.player.field_70458_d.getCapability(TechVillagerTrust.INSTANCE).orElse(null)).getLevel(this.profession)) < trust.getMaxLevel()) {
            float trustbefore = trust.getLevelTrust(level);
            float trustatm = (float)trust.getTrust(this.profession) - trustbefore;
            float trustneeded = (float)trust.getLevelTrust(level + 1) - trustbefore;
            this.drawTooltip(mStack, (int)trustatm + "/" + (int)trustneeded + " Trust", mouseX, mouseY, 141, 23, 172, 2);
        } else {
            this.drawTooltip(mStack, "MAX", mouseX, mouseY, 141, 23, 172, 2);
        }
    }

    public void drawTooltip(MatrixStack mStack, List<ITextComponent> lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            for (ITextComponent line : lines) {
                this.func_238652_a_(mStack, line, mouseX, mouseY);
            }
        }
    }

    public void drawTooltip(MatrixStack mStack, String line, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.field_147003_i) && mouseX <= posX + width && mouseY >= (posY += this.field_147009_r) && mouseY <= posY + height) {
            this.func_238652_a_(mStack, (ITextComponent)new StringTextComponent(line), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack mStack, int mouseX, int mouseY) {
        String color;
        int i;
        super.func_230451_b_(mStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(mStack, this.professionname, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_78256_a(this.professionname) / 2.0f, 10.0f, Integer.parseInt("00e803", 16));
        this.field_230712_o_.func_238421_b_(mStack, "Trades", 70.0f, 14.0f, Integer.parseInt("00e803", 16));
        this.field_230712_o_.func_238421_b_(mStack, "Jobs", 354.0f, 14.0f, Integer.parseInt("00e803", 16));
        this.field_230712_o_.func_238421_b_(mStack, String.valueOf(this.playertrustlevel), 140.0f, 20.0f, Integer.parseInt("00e803", 16));
        this.field_230712_o_.func_238421_b_(mStack, String.valueOf(this.playertrustlevel + 1), 309.0f, 20.0f, Integer.parseInt("00e803", 16));
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTrades().size(); ++i) {
            color = ((TechVillagerContainer)this.field_147002_h).getTrades().get(i).getNeededLevel() <= this.playertrustlevel ? "00e803" : "000000";
            this.field_230712_o_.func_238421_b_(mStack, ((TechVillagerContainer)this.field_147002_h).getTrades().get(i).getName(), 43.0f, (float)(32 + i * 20), Integer.parseInt(color, 16));
        }
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTasks().size(); ++i) {
            color = ((TechVillagerContainer)this.field_147002_h).getTasks().get(i).getMinTrustLevel() <= this.playertrustlevel ? "00e803" : "000000";
            this.field_230712_o_.func_238421_b_(mStack, ((TechVillagerContainer)this.field_147002_h).getTasks().get(i).getName(), 321.0f, (float)(32 + i * 20), Integer.parseInt(color, 16));
        }
        if (this.selectedTrade != null) {
            String color2 = this.selectedTrade.getNeededLevel() <= this.playertrustlevel ? "00e803" : "000000";
            this.field_230712_o_.func_238421_b_(mStack, "Trade", 212.0f, 93.0f, Integer.parseInt(color2, 16));
            this.field_230712_o_.func_238421_b_(mStack, String.valueOf(this.selectedTrade.getCreditsBuy()), (float)(193 - String.valueOf(this.selectedTrade.getCreditsBuy()).length() * 6), 61.0f, Integer.parseInt("00e803", 16));
            this.field_230712_o_.func_238421_b_(mStack, String.valueOf(this.selectedTrade.getCreditsSell()), (float)(301 - String.valueOf(this.selectedTrade.getCreditsSell()).length() * 6), 61.0f, Integer.parseInt("00e803", 16));
        } else if (this.selectedTask != null) {
            String color3 = this.selectedTask.getMinTrustLevel() <= this.playertrustlevel ? "00e803" : "000000";
            this.field_230712_o_.func_238421_b_(mStack, "Trade", 194.0f, 93.0f, Integer.parseInt(color3, 16));
            this.field_230712_o_.func_238421_b_(mStack, String.valueOf(this.selectedTask.getTrust()) + " Trust", (float)(317 - String.valueOf(this.selectedTask.getTrust() + " Trust").length() * 6), 78.0f, Integer.parseInt("00e803", 16));
        } else {
            this.field_230712_o_.func_238421_b_(mStack, "Maybe some kind of intoduction?", 142.0f, 30.0f, Integer.parseInt("00e803", 16));
        }
    }

    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        int k;
        int k2;
        int i;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int trust = this.getTrustScaled(172);
        TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)512, (int)512);
        TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 141), (int)(this.field_147009_r + 23), (float)225.0f, (float)197.0f, (int)trust, (int)2, (int)512, (int)512);
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTrades().size(); ++i) {
            int n = k2 = this.inArea(mouseX, mouseY, 39, 25 + i * 20, 98, 20) ? 1 : 0;
            if (this.selectedTrade != null && i == this.selectedID) {
                k2 = 1;
            }
            if (((TechVillagerContainer)this.field_147002_h).getTrades().get(i).getNeededLevel() > this.playertrustlevel) {
                k2 = i == this.selectedID && this.selectedTrade != null || k2 == 1 ? 3 : 2;
            }
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 39), (int)(this.field_147009_r + 25 + i * 20), (float)0.0f, (float)(197 + 20 * k2), (int)98, (int)20, (int)512, (int)512);
        }
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTasks().size(); ++i) {
            int n = k2 = this.inArea(mouseX, mouseY, 317, 25 + i * 20, 98, 20) ? 1 : 0;
            if (this.selectedTask != null && i == this.selectedID) {
                k2 = 1;
            }
            if (((TechVillagerContainer)this.field_147002_h).getTasks().get(i).getMinTrustLevel() > this.playertrustlevel) {
                k2 = i == this.selectedID && this.selectedTask != null || k2 == 1 ? 3 : 2;
            }
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 317), (int)(this.field_147009_r + 25 + i * 20), (float)0.0f, (float)(197 + 20 * k2), (int)98, (int)20, (int)512, (int)512);
        }
        if (this.selectedTrade != null) {
            int n = k = this.inArea(mouseX, mouseY, 203, 87, 48, 20) ? 1 : 0;
            if (this.selectedTrade.getNeededLevel() > this.playertrustlevel) {
                k = k == 1 ? 3 : 2;
            }
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 203), (int)(this.field_147009_r + 87), (float)98.0f, (float)(197 + 20 * k), (int)48, (int)20, (int)512, (int)512);
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 145), (int)(this.field_147009_r + 59), (float)450.0f, (float)0.0f, (int)56, (int)48, (int)512, (int)512);
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 253), (int)(this.field_147009_r + 59), (float)450.0f, (float)0.0f, (int)56, (int)48, (int)512, (int)512);
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 203), (int)(this.field_147009_r + 76), (float)450.0f, (float)59.0f, (int)48, (int)9, (int)512, (int)512);
        } else if (this.selectedTask != null) {
            int n = k = this.inArea(mouseX, mouseY, 185, 87, 48, 20) ? 1 : 0;
            if (this.selectedTask.getMinTrustLevel() > this.playertrustlevel || this.selectedTask.getMaxTrustLevel() < this.playertrustlevel) {
                k = k == 1 ? 3 : 2;
            }
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 87), (float)98.0f, (float)(197 + 20 * k), (int)48, (int)20, (int)512, (int)512);
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 145), (int)(this.field_147009_r + 51), (float)450.0f, (float)68.0f, (int)38, (int)56, (int)512, (int)512);
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 185), (int)(this.field_147009_r + 76), (float)450.0f, (float)59.0f, (int)48, (int)9, (int)512, (int)512);
            TechVillagerScreen.func_238463_a_((MatrixStack)mStack, (int)(this.field_147003_i + 235), (int)(this.field_147009_r + 76), (float)146.0f, (float)197.0f, (int)79, (int)20, (int)512, (int)512);
        }
    }

    public void renderItem(ItemStack stack, int x, int y) {
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)32.0f);
        this.func_230926_e_(200);
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(stack, this.field_147003_i + x, this.field_147009_r + y);
        this.field_230707_j_.func_180453_a(font, stack, this.field_147003_i + x, this.field_147009_r + y, null);
        this.func_230926_e_(0);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int p_mouseClicked_5_) {
        int i;
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTrades().size(); ++i) {
            if (!this.inArea(mouseX, mouseY, 39, 25 + i * 20, 98, 20)) continue;
            this.selectedTrade = ((TechVillagerContainer)this.field_147002_h).getTrades().get(i);
            this.selectedTask = null;
            this.selectedID = i;
        }
        for (i = 0; i < ((TechVillagerContainer)this.field_147002_h).getTasks().size(); ++i) {
            if (!this.inArea(mouseX, mouseY, 317, 25 + i * 20, 98, 20)) continue;
            this.selectedTask = ((TechVillagerContainer)this.field_147002_h).getTasks().get(i);
            this.selectedTrade = null;
            this.selectedID = i;
        }
        if (this.selectedTrade != null && this.inArea(mouseX, mouseY, 203, 76, 48, 20) && this.getCanTradeTextProperties().size() <= 0) {
            PlantTech2PacketHandler.sendToServer(new DoTechVillagerTradeMessage(this.selectedTrade, ((TechVillagerContainer)this.field_147002_h).getProfession()));
        }
        if (this.selectedTask != null && this.inArea(mouseX, mouseY, 185, 87, 50, 20) && this.getCanTradeTextProperties().size() <= 0) {
            PlantTech2PacketHandler.sendToServer(new DoTechVillagerTaskMessage(this.selectedTask.getID()));
        }
        this.canTradeTextProperties = this.getCanTradeTextProperties();
        this.checkPlayerTrustLevel();
        return super.func_231044_a_(mouseX, mouseY, p_mouseClicked_5_);
    }

    private boolean inArea(double mouseX, double mouseY, int startX, int startY, int width, int height) {
        return mouseX >= (double)(startX += this.field_147003_i) && mouseX <= (double)(startX + width) && mouseY >= (double)(startY += this.field_147009_r) && mouseY <= (double)(startY + height);
    }

    public List<ITextComponent> getCanTradeTextProperties() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.selectedTrade != null) {
            if (this.selectedTrade.getNeededLevel() <= this.playertrustlevel) {
                if (PlayerInventoryUtils.enoughSpace(this.player, this.selectedTrade.getOutputs().size())) {
                    if (PlayerInventoryUtils.hasList(this.player, this.selectedTrade.getInputs())) {
                        if (PlayerInventoryUtils.enoughCredits(this.player, this.selectedTrade.getCreditsBuy())) {
                            if (this.selectedTrade.getCreditsSell() <= 0 && this.player.func_213901_a((Item)ModItems.PLANTCARD) <= 0 && this.selectedTrade.getCreditsSell() > 0) {
                                list.add("No plantcard in inventory");
                            } else {
                                list.add("Not enough credits");
                            }
                        }
                    } else {
                        list.add("Not enough items");
                    }
                } else {
                    list.add("Not enough space");
                }
            } else {
                list.add("Not enough trust");
            }
        } else if (this.selectedTask != null) {
            if (PlayerInventoryUtils.hasList(this.player, this.selectedTask.getInputs())) {
                if (this.playertrustlevel >= this.selectedTask.getMinTrustLevel()) {
                    if (this.playertrustlevel > this.selectedTask.getMaxTrustLevel()) {
                        list.add("To much Trust");
                    } else {
                        list.add("Not enough Trust");
                    }
                }
            } else {
                list.add("Not enough items");
            }
        } else {
            list.add("No trade selected");
        }
        ArrayList<ITextComponent> textPropertiesList = new ArrayList<ITextComponent>();
        for (String str : list) {
            textPropertiesList.add((ITextComponent)new StringTextComponent(str));
        }
        return textPropertiesList;
    }

    private int getTrustScaled(int pixel) {
        ITechVillagerTrust trust = (ITechVillagerTrust)this.player.field_70458_d.getCapability(TechVillagerTrust.INSTANCE).orElse(null);
        if (trust != null) {
            int level = trust.getLevel(this.profession);
            if (level < trust.getMaxLevel()) {
                float trustbefore = trust.getLevelTrust(level);
                float trustatm = (float)trust.getTrust(this.profession) - trustbefore;
                float trustneeded = (float)trust.getLevelTrust(level + 1) - trustbefore;
                return (int)(trustatm / trustneeded * (float)pixel);
            }
            return pixel;
        }
        return 0;
    }
}

