/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui.guide;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.gui.guide.GuideMenu;
import net.kaneka.planttech2.gui.guide.GuidePicture;
import net.kaneka.planttech2.gui.guide.GuideString;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GuideEntry {
    private String name;
    private GuideMenu menu;
    private List<GuidePicture> piclist = new ArrayList<GuidePicture>();
    private List<GuideString> stringList;

    public GuideEntry(String name) {
        this.name = name;
    }

    public GuideEntry setMenu(GuideMenu submenu) {
        this.menu = submenu;
        return this;
    }

    public String getNameString() {
        return this.name;
    }

    public String getName() {
        return new TranslationTextComponent("guide.planttech2." + this.name + ".header").getString();
    }

    public ITextComponent getHeader() {
        return new TranslationTextComponent("guide.planttech2." + this.name + ".header").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.ITALIC});
    }

    public GuideMenu getMenu() {
        return this.menu;
    }

    public List<GuidePicture> getPictures() {
        return this.piclist;
    }

    public GuideEntry addPicture(ResourceLocation resloc, int xStart, int yStart, int width, int height) {
        this.piclist.add(new GuidePicture(resloc, xStart, yStart, width, height));
        return this;
    }

    public String getText() {
        return new TranslationTextComponent("guide.planttech2." + this.name + ".text").getString();
    }

    public List<GuideString> getTextFormated(FontRenderer font) {
        if (this.stringList == null) {
            this.stringList = new ArrayList<GuideString>();
            int lines = 19;
            int lineWidth = 395;
            boolean isInPic = false;
            int startX = 0;
            for (int line = 0; line < lines; ++line) {
                for (int x = 0; x < lineWidth; x += 2) {
                    isInPic = false;
                    for (int y = 0; y < 2; ++y) {
                        for (GuidePicture pic : this.piclist) {
                            font.getClass();
                            if (!pic.isIn(x, line * 10 + y * 9)) continue;
                            isInPic = true;
                        }
                    }
                    if (isInPic) {
                        if (startX < 0) continue;
                        this.stringList.add(new GuideString(startX, line, x - startX));
                        startX = -1;
                        continue;
                    }
                    if (startX >= 0) continue;
                    startX = x;
                }
                if (!isInPic) {
                    this.stringList.add(new GuideString(startX, line, lineWidth - startX));
                }
                startX = 0;
            }
            String[] words = this.getText().split("\\s+");
            int actString = 0;
            GuideString guideString = this.stringList.get(actString);
            block4: for (String word : words) {
                if (word.equals("<br>")) {
                    int actLine = guideString.getLine();
                    for (int counter = 0; counter < 50; ++counter) {
                        if (this.stringList.size() > actString + 1) {
                            guideString = this.stringList.get(++actString);
                        } else {
                            this.stringList.add(new GuideString(0, guideString.getLine() + 1, lineWidth));
                            guideString = this.stringList.get(++actString);
                        }
                        if (guideString.getLine() > actLine) continue block4;
                    }
                    continue;
                }
                for (int counter = 0; counter < 50 && !guideString.appendWord(font, word); ++counter) {
                    if (this.stringList.size() > actString + 1) {
                        guideString = this.stringList.get(++actString);
                        continue;
                    }
                    this.stringList.add(new GuideString(0, guideString.getLine() + 1, lineWidth));
                    guideString = this.stringList.get(++actString);
                }
            }
        }
        return this.stringList;
    }
}

