/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.fluids.capability.BiomassFluidEnergy;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.utilities.ModCreativeTabs;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BiomassContainerItem
extends Item {
    private static final int CAPACITY = 1000;

    public BiomassContainerItem() {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MAIN).func_200917_a(1));
    }

    public static float getFillLevelModel(ItemStack stack) {
        int capacity;
        int biomass = BiomassFluidEnergy.getItemStackCap(stack).getCurrentStorage();
        if (biomass > (capacity = BiomassFluidEnergy.getItemStackCap(stack).getMaxStorage()) / 9 * 9) {
            return 9.0f;
        }
        if (biomass > capacity / 9 * 8) {
            return 8.0f;
        }
        if (biomass > capacity / 9 * 7) {
            return 7.0f;
        }
        if (biomass > capacity / 9 * 6) {
            return 6.0f;
        }
        if (biomass > capacity / 9 * 5) {
            return 5.0f;
        }
        if (biomass > capacity / 9 * 4) {
            return 4.0f;
        }
        if (biomass > capacity / 9 * 3) {
            return 3.0f;
        }
        if (biomass > capacity / 9 * 2) {
            return 2.0f;
        }
        if (biomass > capacity / 9) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new BiomassFluidEnergy();
    }

    public static int extractBiomass(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        if (current < amount) {
            BiomassContainerItem.changeCurrentStorage(stack, -current);
            return current;
        }
        BiomassContainerItem.changeCurrentStorage(stack, -amount);
        return amount;
    }

    public static int receiveBiomass(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        if (current + amount > 1000) {
            BiomassContainerItem.changeCurrentStorage(stack, 1000 - current);
            return -1000 + current;
        }
        BiomassContainerItem.changeCurrentStorage(stack, amount);
        return -amount;
    }

    public static void changeCurrentStorage(ItemStack stack, int amount) {
        int current = BiomassContainerItem.getCurrentStorage(stack);
        current = current + amount < 0 ? 0 : (current + amount > 1000 ? 1000 : (current += amount));
        BiomassContainerItem.setCurrentStorage(stack, current);
    }

    public static void setCurrentStorage(ItemStack stack, int value) {
        BiomassContainerItem.initTag(stack).func_74768_a("biomass", value < 0 ? 0 : Math.min(value, 1000));
    }

    public static int getCurrentStorage(ItemStack stack) {
        return BiomassContainerItem.initTag(stack).func_74762_e("biomass");
    }

    public static int getCapacity() {
        return 1000;
    }

    private static CompoundNBT initTag(ItemStack stack) {
        CompoundNBT compoundNBT;
        if (stack.func_77942_o()) {
            compoundNBT = stack.func_77978_p();
        } else {
            compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("biomass", 0);
            stack.func_77982_d(compoundNBT);
        }
        return compoundNBT;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IBiomassFluidEnergy cap = BiomassFluidEnergy.getItemStackCap(stack);
        tooltip.add((ITextComponent)new StringTextComponent(cap.getCurrentStorage() + "/" + cap.getMaxStorage()));
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT compound = super.getShareTag(stack);
        if (compound != null) {
            IBiomassFluidEnergy cap = (IBiomassFluidEnergy)stack.getCapability(BiomassFluidEnergy.BIOMASS_FLUID_ENERGY).orElseThrow(NullPointerException::new);
            INBT compound2 = BiomassFluidEnergy.BIOMASS_FLUID_ENERGY.getStorage().writeNBT(BiomassFluidEnergy.BIOMASS_FLUID_ENERGY, (Object)cap, null);
            if (compound2 != null) {
                compound.func_218657_a("biomass", compound2);
            }
        }
        return compound;
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbt) {
        if (nbt != null) {
            IBiomassFluidEnergy cap = (IBiomassFluidEnergy)stack.getCapability(BiomassFluidEnergy.BIOMASS_FLUID_ENERGY).orElseThrow(NullPointerException::new);
            BiomassFluidEnergy.BIOMASS_FLUID_ENERGY.getStorage().readNBT(BiomassFluidEnergy.BIOMASS_FLUID_ENERGY, (Object)cap, null, (INBT)nbt.func_74775_l("biomass"));
        }
        super.readShareTag(stack, nbt);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == this.field_77701_a) {
            items.add((Object)new ItemStack((IItemProvider)ModItems.BIOMASSCONTAINER));
            ItemStack full = new ItemStack((IItemProvider)ModItems.BIOMASSCONTAINER);
            BiomassFluidEnergy.getItemStackCap(full).setCurrentStorage(BiomassFluidEnergy.getItemStackCap(full).getMaxStorage());
            items.add((Object)full);
        }
    }
}

