/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items;

import java.util.List;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.CropsTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class FertilizerItem
extends Item {
    public FertilizerItem(ItemGroup group) {
        super(new Item.Properties().func_200916_a(group));
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                BlockPos target = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                this.func_239796_a_(FertilizerItem.applyFertillizer((World)world, target, stack));
                if (!world.func_201670_d() && this.func_239795_a_()) {
                    world.func_217379_c(2005, target, 0);
                }
                return stack;
            }
        });
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        if (!world.func_201670_d() && FertilizerItem.applyFertillizer(world, pos, stack)) {
            if (context.func_195999_j() != null && !context.func_195999_j().field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_195939_a(context);
    }

    public static float getIncreaseChance(Item item) {
        if (item == ModItems.FERTILIZER_TIER_1) {
            return 0.05f;
        }
        if (item == ModItems.FERTILIZER_TIER_2) {
            return 0.15f;
        }
        if (item == ModItems.FERTILIZER_TIER_3) {
            return 0.35f;
        }
        if (item == ModItems.FERTILIZER_TIER_4) {
            return 0.75f;
        }
        if (item == ModItems.FERTILIZER_CREATIVE) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertilizer").getString() + ": " + (int)(FertilizerItem.getIncreaseChance(stack.func_77973_b()) * 100.0f) + "%"));
        if (stack.func_77973_b() == ModItems.FERTILIZER_CREATIVE) {
            tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent("info.fertilizer_creative").getString()));
        }
    }

    public static boolean applyFertillizer(World world, BlockPos pos, ItemStack stack) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof CropBaseBlock) {
            if (field_77697_d.nextFloat() < FertilizerItem.getIncreaseChance(stack.func_77973_b())) {
                if (stack.func_77973_b() != ModItems.FERTILIZER_CREATIVE) {
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof CropsTileEntity) {
                        ((CropBaseBlock)block).updateCrop(world, pos, ((CropsTileEntity)te).getTraits());
                    }
                } else {
                    ((CropBaseBlock)block).updateCreative(world, pos);
                }
            }
            return true;
        }
        return false;
    }
}

