/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.packets;

import java.util.function.Supplier;
import net.kaneka.planttech2.PlantTechMain;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CropListSyncMessage {
    private final CompoundNBT cropList;

    public CropListSyncMessage() {
        this(PlantTechMain.getCropList().write());
    }

    public CropListSyncMessage(CompoundNBT cropList) {
        this.cropList = cropList;
    }

    public static void encode(CropListSyncMessage pkt, PacketBuffer buf) {
        buf.func_150786_a(pkt.cropList);
    }

    public static CropListSyncMessage decode(PacketBuffer buf) {
        return new CropListSyncMessage(buf.func_150793_b());
    }

    public static void handle(CropListSyncMessage pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlantTechMain.LOGGER.debug("Reading crop configurations sent from server");
            try {
                PlantTechMain.getCropList().read(pkt.cropList);
            }
            catch (Exception e) {
                PlantTechMain.LOGGER.error("An error has occurred during the processing with crop list syncing, report this to the server.");
                PlantTechMain.LOGGER.error(e.getMessage());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

