/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.cable;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class CableInfo {
    public BlockPos masterPos = BlockPos.field_177992_a;
    public boolean isMaster = false;
    public HashSet<BlockPos> slaves = new HashSet();
    public HashSet<Connection> producers = new HashSet();
    public HashSet<Connection> consumers = new HashSet();
    public HashSet<Connection> storages = new HashSet();
    public int[] connections = new int[]{0, 0, 0, 0, 0, 0};

    public CableInfo() {
    }

    public CableInfo(CompoundNBT compound) {
        this.masterPos = NBTUtil.func_186861_c((CompoundNBT)compound);
        this.isMaster = compound.func_74767_n("ismaster");
        this.connections = compound.func_74759_k("connections");
        if (this.isMaster) {
            this.slaves = this.readBlockPosList(compound, "slaves");
            this.producers = this.readBlockPosWithDirectionList(compound, "producers");
            this.consumers = this.readBlockPosWithDirectionList(compound, "consumers");
            this.storages = this.readBlockPosWithDirectionList(compound, "storages");
        }
    }

    public CompoundNBT write() {
        CompoundNBT compound = NBTUtil.func_186859_a((BlockPos)this.masterPos);
        compound.func_74757_a("ismaster", this.isMaster);
        compound.func_74783_a("connections", this.connections);
        if (this.isMaster) {
            this.writeBlockPosList(compound, "slaves", this.slaves);
            this.writeBlockPosWithDirectionList(compound, "producers", this.producers, true);
            this.writeBlockPosWithDirectionList(compound, "consumers", this.consumers, true);
            this.writeBlockPosWithDirectionList(compound, "storages", this.storages, true);
        }
        return compound;
    }

    private void writeBlockPosList(CompoundNBT compound, String key, HashSet<BlockPos> targetList) {
        HashSet<Connection> connections = new HashSet<Connection>();
        targetList.forEach(pos -> connections.add(new Connection((BlockPos)pos, Direction.UP)));
        this.writeBlockPosWithDirectionList(compound, key, connections, false);
    }

    private void writeBlockPosWithDirectionList(CompoundNBT compound, String key, HashSet<Connection> targetList, boolean direction) {
        CompoundNBT subCompound = new CompoundNBT();
        ArrayList x = new ArrayList();
        ArrayList y = new ArrayList();
        ArrayList z = new ArrayList();
        ArrayList d = new ArrayList();
        targetList.forEach(connection -> {
            BlockPos blockPos = connection.blockPos;
            x.add(blockPos.func_177958_n());
            y.add(blockPos.func_177956_o());
            z.add(blockPos.func_177952_p());
            if (direction) {
                d.add(connection.direction.func_176745_a());
            }
        });
        subCompound.func_197646_b("x", x);
        subCompound.func_197646_b("y", y);
        subCompound.func_197646_b("z", z);
        if (direction) {
            subCompound.func_197646_b("d", d);
        }
        compound.func_218657_a(key, (INBT)subCompound);
    }

    private HashSet<Connection> readBlockPosWithDirectionList(CompoundNBT compound, String key) {
        HashSet<Connection> connections = new HashSet<Connection>();
        CompoundNBT subCompound = compound.func_74775_l(key);
        int[] x = subCompound.func_74759_k("x");
        int[] y = subCompound.func_74759_k("y");
        int[] z = subCompound.func_74759_k("z");
        int[] d = subCompound.func_74759_k("d");
        for (int i = 0; i < subCompound.func_74759_k("x").length; ++i) {
            connections.add(new Connection(new BlockPos(x[i], y[i], z[i]), Direction.func_82600_a((int)d[i])));
        }
        return connections;
    }

    private HashSet<BlockPos> readBlockPosList(CompoundNBT compound, String key) {
        HashSet<BlockPos> blockPos = new HashSet<BlockPos>();
        CompoundNBT subCompound = compound.func_74775_l(key);
        int[] x = subCompound.func_74759_k("x");
        int[] y = subCompound.func_74759_k("y");
        int[] z = subCompound.func_74759_k("z");
        for (int i = 0; i < subCompound.func_74759_k("x").length; ++i) {
            blockPos.add(new BlockPos(x[i], y[i], z[i]));
        }
        return blockPos;
    }

    public CableInfo clear(boolean keepConnection) {
        CableInfo newInfo = new CableInfo();
        if (keepConnection) {
            newInfo.connections = (int[])this.connections.clone();
        }
        return newInfo;
    }

    public static class Connection {
        public BlockPos blockPos = BlockPos.field_177992_a;
        public Direction direction = Direction.UP;

        public Connection() {
        }

        public Connection(BlockPos blockPos, Direction direction) {
            this.blockPos = blockPos;
            this.direction = direction;
        }
    }
}

