/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.cable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.cable.Connection;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CableTileEntity
extends TileEntity
implements ITickableTileEntity {
    private BlockPos masterPos = null;
    private boolean isMaster = false;
    private int[] connections = new int[]{0, 0, 0, 0, 0, 0};
    private int maxTransferRate = 20;
    private boolean connectionUpdated = true;
    private final List<BlockPos> cables = new ArrayList<BlockPos>();
    private final HashMap<Integer, List<Connection>> connectionsMaster = new HashMap<Integer, List<Connection>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, new ArrayList());
            this.put(1, new ArrayList());
        }
    };
    HashMap<BlockPos, Direction> producer = new HashMap();
    HashMap<BlockPos, Direction> consumer = new HashMap();
    HashMap<BlockPos, Direction> storages = new HashMap();

    public CableTileEntity() {
        super(ModTileEntities.CABLE_TE);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.isMaster) {
            this.transferEnergy();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void transferEnergy() {
        IEnergyStorage cap;
        int maxNeeded = 0;
        int maxSupplied = 0;
        int maxStorragesNeeded = 0;
        int maxStorragesSupplied = 0;
        int amountConsumer = 0;
        int amountProducer = 0;
        int amountStorages = 0;
        if (this.connectionUpdated) {
            this.producer.clear();
            this.consumer.clear();
            this.storages.clear();
            for (Connection connection : this.connectionsMaster.get(0)) {
                cap = this.getEnergyCap(connection.getConnectedPos(), connection.getFacing().func_176734_d());
                if (cap == null || this.consumer.containsKey(connection.getConnectedPos())) continue;
                this.consumer.put(connection.getConnectedPos(), connection.getFacing().func_176734_d());
            }
            for (Connection connection : this.connectionsMaster.get(1)) {
                cap = this.getEnergyCap(connection.getConnectedPos(), connection.getFacing().func_176734_d());
                if (cap == null || this.producer.containsKey(connection.getConnectedPos())) continue;
                this.producer.put(connection.getConnectedPos(), connection.getFacing().func_176734_d());
            }
            List intersect_PC = this.producer.keySet().stream().filter(x -> this.consumer.containsKey(x)).collect(Collectors.toList());
            this.producer.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            this.consumer.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            for (Connection con : this.connectionsMaster.get(0)) {
                cap = this.getEnergyCap(con.getConnectedPos(), con.getFacing().func_176734_d());
                if (cap == null || this.storages.containsKey(con.getConnectedPos()) || !intersect_PC.contains(con.getConnectedPos())) continue;
                this.storages.put(con.getConnectedPos(), con.getFacing().func_176734_d());
            }
            this.connectionUpdated = false;
        }
        for (Map.Entry<BlockPos, Direction> entry2 : this.producer.entrySet()) {
            cap = this.getEnergyCap(entry2.getKey(), entry2.getValue());
            if (cap == null) continue;
            maxSupplied += cap.extractEnergy(this.maxTransferRate, true);
            ++amountProducer;
        }
        for (Map.Entry<BlockPos, Direction> entry3 : this.consumer.entrySet()) {
            cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
            if (cap == null) continue;
            maxNeeded += cap.receiveEnergy(this.maxTransferRate, true);
            ++amountConsumer;
        }
        for (Map.Entry<BlockPos, Direction> entry4 : this.storages.entrySet()) {
            cap = this.getEnergyCap(entry4.getKey(), entry4.getValue());
            if (cap == null) continue;
            maxStorragesSupplied += cap.extractEnergy(this.maxTransferRate, true);
            maxStorragesNeeded += cap.receiveEnergy(this.maxTransferRate, true);
            ++amountStorages;
        }
        if (maxNeeded + maxStorragesNeeded > 0 && maxSupplied + maxStorragesSupplied > 0) {
            int perMachineConsumer = 0;
            boolean bl = false;
            int perMachineStoragesIn = 0;
            int perMachineStoragesOut = 0;
            int leftoverConsumer = 0;
            int leftoverProducer = 0;
            int leftoverStorageIn = 0;
            int leftoverStorageOut = 0;
            if (maxNeeded > maxSupplied) {
                int maxSuppliedBoth = maxSupplied + maxStorragesSupplied;
                int n = this.maxTransferRate;
                if (maxNeeded > maxSuppliedBoth) {
                    perMachineStoragesOut = this.maxTransferRate;
                    perMachineConsumer = maxSuppliedBoth / amountConsumer;
                    leftoverConsumer = maxSuppliedBoth - perMachineConsumer * amountConsumer;
                } else {
                    perMachineStoragesOut = (maxNeeded - maxSupplied) / amountStorages;
                    leftoverStorageOut = maxNeeded - maxSupplied - perMachineStoragesOut * amountStorages;
                    perMachineConsumer = this.maxTransferRate;
                }
            } else if (maxNeeded < maxSupplied) {
                int maxNeededBoth = maxNeeded + maxStorragesNeeded;
                if (maxNeededBoth < maxSupplied) {
                    int n = maxNeededBoth / amountProducer;
                    leftoverProducer = maxNeededBoth - n * amountProducer;
                    perMachineStoragesIn = this.maxTransferRate;
                } else {
                    int n = this.maxTransferRate;
                    perMachineStoragesIn = (maxSupplied - maxNeeded) / amountStorages;
                    leftoverStorageIn = maxSupplied - maxNeeded - perMachineStoragesIn * amountStorages;
                }
                perMachineConsumer = this.maxTransferRate;
            } else {
                int n = this.maxTransferRate;
                perMachineConsumer = this.maxTransferRate;
            }
            for (Map.Entry<BlockPos, Direction> entry3 : this.producer.entrySet()) {
                void var10_27;
                cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
                if (cap == null) continue;
                if (leftoverProducer > 0) {
                    cap.extractEnergy((int)(var10_27 + true), false);
                    --leftoverProducer;
                    continue;
                }
                cap.extractEnergy((int)var10_27, false);
            }
            for (Map.Entry<BlockPos, Direction> entry5 : this.consumer.entrySet()) {
                cap = this.getEnergyCap(entry5.getKey(), entry5.getValue());
                if (cap == null) continue;
                if (leftoverConsumer > 0) {
                    cap.receiveEnergy(perMachineConsumer + 1, false);
                    --leftoverConsumer;
                    continue;
                }
                cap.receiveEnergy(perMachineConsumer, false);
            }
            for (Map.Entry<BlockPos, Direction> entry5 : this.storages.entrySet()) {
                cap = this.getEnergyCap(entry5.getKey(), entry5.getValue());
                if (cap == null) continue;
                if (perMachineStoragesIn > 0) {
                    if (leftoverStorageIn > 0) {
                        cap.receiveEnergy(perMachineStoragesIn + 1, false);
                        --leftoverStorageIn;
                    } else {
                        cap.receiveEnergy(perMachineStoragesIn, false);
                    }
                }
                if (perMachineStoragesOut <= 0) continue;
                if (leftoverStorageOut > 0) {
                    cap.extractEnergy(perMachineStoragesOut + 1, false);
                    --leftoverStorageOut;
                    continue;
                }
                cap.extractEnergy(perMachineStoragesOut, false);
            }
        }
    }

    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    public void setMasterPos(BlockPos pos) {
        this.masterPos = pos;
    }

    public int getConnection(Direction facing) {
        return this.connections[facing.func_176745_a()];
    }

    public void setConnection(Direction facing, int i) {
        if (0 <= i && i < 5) {
            CableTileEntity te = this.getTECable(this.masterPos);
            if (te != null) {
                te.changeConnectionMaster(this.field_174879_c, facing, this.connections[facing.func_176745_a()], i);
            }
            this.connections[facing.func_176745_a()] = i;
        }
    }

    public void changeConnectionMaster(BlockPos pos, Direction facing, int fromState, int toState) {
        if (fromState > 1) {
            this.connectionsMaster.get(fromState - 2).removeIf(x -> x.areEqual(pos, facing));
        }
        if (toState > 1 && this.connectionsMaster.get(toState - 2).stream().noneMatch(x -> x.areEqual(pos, facing))) {
            this.connectionsMaster.get(toState - 2).add(new Connection(pos, facing));
        }
        this.connectionUpdated = true;
    }

    private void removeValues() {
        this.masterPos = null;
        if (this.isMaster) {
            this.removeMaster(null);
        }
    }

    public void setAsMaster() {
        this.isMaster = true;
        this.masterPos = this.field_174879_c;
        this.cables.add(this.field_174879_c);
        this.connectionUpdated = true;
    }

    public void removeMaster(@Nullable BlockPos newMaster) {
        this.isMaster = false;
        this.masterPos = newMaster;
        this.cables.clear();
        for (int i = 0; i < this.connectionsMaster.size(); ++i) {
            this.connectionsMaster.get(i).clear();
        }
    }

    public void addCable(BlockPos pos) {
        this.cables.add(pos);
    }

    public void removeCable(BlockPos pos) {
        this.cables.remove(pos);
    }

    public void initCable(BlockState state) {
        if (this.field_145850_b != null) {
            ArrayList<BlockPos> neighborMaster = new ArrayList<BlockPos>();
            for (Direction facing : Direction.values()) {
                CableTileEntity te = this.getTECable(this.field_174879_c.func_177972_a(facing));
                if (te == null || neighborMaster.contains(te.getMasterPos())) continue;
                neighborMaster.add(te.getMasterPos());
            }
            switch (neighborMaster.size()) {
                case 0: {
                    this.setAsMaster();
                    this.masterPos = this.field_174879_c;
                    break;
                }
                case 1: {
                    CableTileEntity te = this.getTECable((BlockPos)neighborMaster.get(0));
                    if (te == null) break;
                    te.addCable(this.field_174879_c);
                    this.setMasterPos(te.func_174877_v());
                    break;
                }
                default: {
                    this.combineAndAdd(neighborMaster);
                }
            }
            this.checkConnections(false);
            this.func_70296_d();
        }
    }

    public void deleteCable() {
        CableTileEntity cable;
        ArrayList<BlockPos> neighborCables = new ArrayList<BlockPos>();
        if (this.field_145850_b == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (!(te instanceof CableTileEntity)) continue;
            neighborCables.add(this.field_174879_c.func_177972_a(facing));
        }
        if (this.isMaster) {
            if (neighborCables.size() == 1) {
                CableTileEntity newMaster = (CableTileEntity)this.field_145850_b.func_175625_s((BlockPos)neighborCables.get(0));
                if (newMaster != null) {
                    this.transferMastery(newMaster, this);
                    newMaster.removeCable(this.field_174879_c);
                }
            } else if (neighborCables.size() > 1) {
                this.recreateNetworks(neighborCables, this.cables);
            }
        } else if (neighborCables.size() == 1) {
            cable = this.getTECable((BlockPos)neighborCables.get(0));
            if (cable != null) {
                cable.removeCable(this.field_174879_c);
            }
        } else if (neighborCables.size() > 1 && (cable = this.getTECable((BlockPos)neighborCables.get(0))) != null) {
            this.recreateNetworks(neighborCables, cable.getCableList());
        }
    }

    public void recreateNetworks(List<BlockPos> neighborCables, List<BlockPos> cables) {
        CableTileEntity te;
        ArrayList<BlockPos> cableCopy = new ArrayList<BlockPos>(cables);
        for (BlockPos cablePos : cableCopy) {
            te = this.getTECable(cablePos);
            if (te == null) continue;
            te.removeValues();
        }
        for (BlockPos neighborCable : neighborCables) {
            te = this.getTECable(neighborCable);
            if (te == null || te.getMasterPos() != null) continue;
            te.setAsMaster();
            te.sendConnections();
            te.spreadPos(this.field_174879_c);
        }
    }

    public void spreadPos(BlockPos exception) {
        for (Direction facing : Direction.values()) {
            CableTileEntity te;
            BlockPos nextPos = this.field_174879_c.func_177972_a(facing);
            if (nextPos.equals((Object)exception) || (te = this.getTECable(nextPos)) == null || te.getMasterPos() != null) continue;
            te.setMasterPos(this.masterPos);
            CableTileEntity cable = this.getTECable(te.getMasterPos());
            if (cable != null) {
                cable.addCable(te.func_174877_v());
            }
            te.sendConnections();
            te.spreadPos(exception);
        }
    }

    private void sendConnections() {
        CableTileEntity te = this.getTECable(this.masterPos);
        if (te != null) {
            for (Direction facing : Direction.values()) {
                if (this.connections[facing.func_176745_a()] <= 1) continue;
                te.changeConnectionMaster(this.field_174879_c, facing, 0, this.connections[facing.func_176745_a()]);
            }
        }
    }

    public void combineAndAdd(List<BlockPos> list) {
        CableTileEntity newMaster = this.getTECable(list.get(0));
        list.remove(0);
        if (newMaster != null) {
            for (BlockPos oldMasterPos : list) {
                CableTileEntity oldMaster = this.getTECable(oldMasterPos);
                if (oldMaster == null) continue;
                this.transferMastery(newMaster, oldMaster);
            }
            newMaster.addCable(this.func_174877_v());
            this.setMasterPos(newMaster.func_174877_v());
        }
    }

    public HashMap<Integer, List> getLists() {
        HashMap<Integer, List> lists = new HashMap<Integer, List>();
        lists.put(0, this.cables);
        lists.put(1, this.connectionsMaster.get(0));
        lists.put(2, this.connectionsMaster.get(1));
        return lists;
    }

    public void setLists(HashMap<Integer, List> lists) {
        this.cables.addAll(lists.get(0));
        this.connectionsMaster.get(0).addAll(lists.get(1));
        this.connectionsMaster.get(1).addAll(lists.get(2));
    }

    public List<BlockPos> getCableList() {
        return this.cables;
    }

    private void setCableMasterPos(BlockPos pos) {
        for (BlockPos cablePos : this.cables) {
            CableTileEntity cable = this.getTECable(cablePos);
            if (cable == null) continue;
            cable.setMasterPos(pos);
        }
    }

    private void transferMastery(CableTileEntity newMaster, CableTileEntity oldMaster) {
        oldMaster.setCableMasterPos(newMaster.getMasterPos());
        newMaster.setAsMaster();
        newMaster.setLists(oldMaster.getLists());
        oldMaster.removeMaster(newMaster.getMasterPos());
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("ismaster", this.isMaster);
        if (this.masterPos != null) {
            compound.func_74768_a("masterposx", this.masterPos.func_177958_n());
            compound.func_74768_a("masterposy", this.masterPos.func_177956_o());
            compound.func_74768_a("masterposz", this.masterPos.func_177952_p());
        }
        if (!this.cables.isEmpty()) {
            ListNBT cableList = new ListNBT();
            this.cables.stream().forEach(x -> cableList.add((Object)NBTUtil.func_186859_a((BlockPos)x)));
            compound.func_218657_a("cables", (INBT)cableList);
        }
        if (this.connections.length == 6) {
            compound.func_74783_a("connections", this.connections);
        }
        for (int i = 0; i < 2; ++i) {
            if (this.connectionsMaster.get(i).size() <= 0) continue;
            List<Connection> connections = this.connectionsMaster.get(i);
            ListNBT connectionlist = new ListNBT();
            for (Connection con : connections) {
                connectionlist.add((Object)con.serializeConnection());
            }
            compound.func_218657_a("connections_" + i, (INBT)connectionlist);
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ListNBT cableList;
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("ismaster")) {
            this.isMaster = compound.func_74767_n("ismaster");
        }
        if (compound.func_74764_b("masterposx")) {
            this.masterPos = new BlockPos(compound.func_74762_e("masterposx"), compound.func_74762_e("masterposy"), compound.func_74762_e("masterposz"));
        }
        if ((cableList = compound.func_150295_c("cables", 10)).size() > 0) {
            this.cables.clear();
            for (int i = 0; i < cableList.size(); ++i) {
                this.cables.add(NBTUtil.func_186861_c((CompoundNBT)cableList.func_150305_b(i)));
            }
        }
        if (compound.func_74764_b("connections")) {
            this.connections = compound.func_74759_k("connections");
        }
        for (int i = 0; i < 2; ++i) {
            ListNBT list;
            if (!compound.func_74764_b("connections_" + i) || (list = compound.func_150295_c("connections_" + i, 10)).size() <= 0) continue;
            this.connectionsMaster.get(i).clear();
            for (int k = 0; k < list.size(); ++k) {
                this.connectionsMaster.get(i).add(new Connection().deserializeConnection(list.func_150305_b(k)));
            }
        }
    }

    private IEnergyStorage getEnergyCap(BlockPos pos, Direction facing) {
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te != null && te.getCapability(CapabilityEnergy.ENERGY, facing).isPresent()) {
            return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing).orElse(null);
        }
        return null;
    }

    public void checkConnections(boolean neighborChanged) {
        boolean shouldSendChanges = false;
        if (this.field_145850_b == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (te != null) {
                if (te instanceof CableTileEntity) {
                    if (this.getConnection(facing) == 1) continue;
                    this.setConnection(facing, 1);
                    shouldSendChanges = true;
                    continue;
                }
                if (!te.getCapability(CapabilityEnergy.ENERGY, facing).isPresent() || this.getConnection(facing) >= 2) continue;
                this.setConnection(facing, 2);
                shouldSendChanges = true;
                continue;
            }
            if (this.getConnection(facing) == 0) continue;
            this.setConnection(facing, 0);
            shouldSendChanges = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (shouldSendChanges) {
                this.sendUpdates();
            }
            if (neighborChanged) {
                this.connectionUpdated = true;
            }
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    private void sendUpdates() {
        if (this.field_145850_b != null) {
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0, 512);
        }
    }

    public void rotateConnection(Direction dir) {
        this.rotateConnection(dir.func_176745_a());
    }

    public void rotateConnection(int i) {
        int next = this.connections[i] + 1;
        if (next > 3) {
            next = 2;
        }
        this.setConnection(Direction.func_82600_a((int)i), next);
    }

    private CableTileEntity getTECable(BlockPos pos) {
        TileEntity te;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (te = this.field_145850_b.func_175625_s(pos)) instanceof CableTileEntity) {
            return (CableTileEntity)te;
        }
        return null;
    }
}

