/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.Optional;
import javax.annotation.Nullable;
import net.kaneka.planttech2.container.InfuserContainer;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.ConvertEnergyInventoryFluidTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InfuserTileEntity
extends ConvertEnergyInventoryFluidTileEntity {
    private int fluidTotal = 0;
    private Item output = null;
    private final RangedWrapper inputs;
    private final RangedWrapper outputs;
    private final LazyOptional<IItemHandler> inputs_provider;
    private final LazyOptional<IItemHandler> outputs_provider;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return InfuserTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return InfuserTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return InfuserTileEntity.this.biomassCap.getCurrentStorage();
                }
                case 3: {
                    return InfuserTileEntity.this.biomassCap.getMaxStorage();
                }
                case 4: {
                    return InfuserTileEntity.this.ticksPassed;
                }
                case 5: {
                    return InfuserTileEntity.this.fluidTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    InfuserTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    InfuserTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    InfuserTileEntity.this.biomassCap.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    InfuserTileEntity.this.biomassCap.setMaxStorage(value);
                    break;
                }
                case 4: {
                    InfuserTileEntity.this.ticksPassed = value;
                    break;
                }
                case 5: {
                    InfuserTileEntity.this.fluidTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 6;
        }
    };

    public InfuserTileEntity() {
        super(ModTileEntities.INFUSER_TE, 1000, 8, 5000, 2);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 1);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 1, 2);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        if (input.func_190926_b()) {
            return false;
        }
        InfuserRecipe recipe = this.getOutputRecipe();
        if (recipe == null) {
            return false;
        }
        if (recipe.getOutput() == this.output || this.output == null) {
            if (this.output == null) {
                this.output = recipe.getOutput();
                this.fluidTotal = recipe.getBiomass();
            }
            return this.ticksPassed + this.fluidPerAction() < this.fluidTotal;
        }
        this.fluidTotal = recipe.getBiomass();
        this.output = recipe.getOutput();
        return false;
    }

    @Override
    protected void increaseProgress() {
        this.ticksPassed += this.fluidPerAction();
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        return this.getOutputRecipe() == null ? ItemStack.field_190927_a : this.getOutputRecipe().func_77571_b();
    }

    @Override
    protected boolean shouldResetProgressIfNotProcessing() {
        return false;
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    @Nullable
    private InfuserRecipe getOutputRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.itemhandler);
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.INFUSING, (IInventory)wrapper, this.field_145850_b);
        return recipe.orElse(null);
    }

    @Override
    public String getNameString() {
        return "infuser";
    }

    @Override
    public int getFluidInSlot() {
        return 3;
    }

    @Override
    public int getFluidOutSlot() {
        return 4;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new InfuserContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 5;
    }

    @Override
    public int getEnergyOutSlot() {
        return 6;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 7;
    }

    @Override
    public int getKnowledgePerAction() {
        return 150;
    }

    @Override
    public int getUpgradeSlot() {
        return 2;
    }
}

