/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.container.MachineBulbReprocessorContainer;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.ConvertEnergyInventoryFluidTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.Tags;

public class MachineBulbReprocessorTileEntity
extends ConvertEnergyInventoryFluidTileEntity {
    private int selectedId = 0;
    private int actualTier = 0;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return MachineBulbReprocessorTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return MachineBulbReprocessorTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return MachineBulbReprocessorTileEntity.this.biomassCap.getCurrentStorage();
                }
                case 3: {
                    return MachineBulbReprocessorTileEntity.this.biomassCap.getMaxStorage();
                }
                case 4: {
                    return MachineBulbReprocessorTileEntity.this.ticksPassed;
                }
                case 5: {
                    return MachineBulbReprocessorTileEntity.this.selectedId;
                }
                case 6: {
                    return MachineBulbReprocessorTileEntity.this.actualTier;
                }
                case 7: {
                    return MachineBulbReprocessorTileEntity.this.field_174879_c.func_177958_n();
                }
                case 8: {
                    return MachineBulbReprocessorTileEntity.this.field_174879_c.func_177956_o();
                }
                case 9: {
                    return MachineBulbReprocessorTileEntity.this.field_174879_c.func_177952_p();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    MachineBulbReprocessorTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    MachineBulbReprocessorTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    MachineBulbReprocessorTileEntity.this.biomassCap.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    MachineBulbReprocessorTileEntity.this.biomassCap.setMaxStorage(value);
                    break;
                }
                case 4: {
                    MachineBulbReprocessorTileEntity.this.ticksPassed = value;
                    break;
                }
                case 5: {
                    MachineBulbReprocessorTileEntity.this.selectedId = value;
                    break;
                }
                case 6: {
                    MachineBulbReprocessorTileEntity.this.actualTier = value;
                    break;
                }
                case 7: {
                    MachineBulbReprocessorTileEntity.this.field_174879_c = new BlockPos(value, MachineBulbReprocessorTileEntity.this.field_174879_c.func_177956_o(), MachineBulbReprocessorTileEntity.this.field_174879_c.func_177952_p());
                    break;
                }
                case 8: {
                    MachineBulbReprocessorTileEntity.this.field_174879_c = new BlockPos(MachineBulbReprocessorTileEntity.this.field_174879_c.func_177958_n(), value, MachineBulbReprocessorTileEntity.this.field_174879_c.func_177952_p());
                    break;
                }
                case 9: {
                    MachineBulbReprocessorTileEntity.this.field_174879_c = new BlockPos(MachineBulbReprocessorTileEntity.this.field_174879_c.func_177958_n(), MachineBulbReprocessorTileEntity.this.field_174879_c.func_177956_o(), value);
                }
            }
        }

        public int func_221478_a() {
            return 10;
        }
    };

    public MachineBulbReprocessorTileEntity() {
        super(ModTileEntities.MACHINEBULBREPROCESSOR_TE, 5000, 8, 5000, 0);
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        if (this.selectedId < 1 || this.selectedId > ModItems.MACHINE_BULBS.size()) {
            return false;
        }
        MachineBulbItem bulb = ModItems.MACHINE_BULBS.get(this.selectedId - 1).get();
        if (bulb.getTier() > this.actualTier) {
            return false;
        }
        return Tags.Items.SEEDS.func_230235_a_((Object)input.func_77973_b()) || input.func_77973_b() instanceof CropSeedItem;
    }

    @Override
    protected EnergyInventoryTileEntity.EnergyConsumptionType getEnergyConsumptionType() {
        return EnergyInventoryTileEntity.EnergyConsumptionType.PER_PROCESS;
    }

    @Override
    protected EnergyInventoryTileEntity.FluidConsumptionType getFluidConsumptionType() {
        return EnergyInventoryTileEntity.FluidConsumptionType.PER_PROCESS;
    }

    @Override
    public int fluidPerAction() {
        if (this.selectedId < 1) {
            return 0;
        }
        return ModItems.MACHINE_BULBS.get(this.selectedId - 1).get().getNeededBiomass();
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        if (this.selectedId < 1) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)ModItems.MACHINE_BULBS.get(this.selectedId - 1).get());
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        this.checkTier();
    }

    public void checkTier() {
        Item item;
        ItemStack stack = this.itemhandler.getStackInSlot(this.getKnowledgeChipSlot());
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof KnowledgeChip) {
            this.actualTier = ((KnowledgeChip)item).getTier();
            return;
        }
        this.actualTier = 0;
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    @Override
    public int energyPerAction() {
        return 1000;
    }

    @Override
    public int ticksPerItem() {
        return 300;
    }

    @Override
    public String getNameString() {
        return "machinebulbreprocessor";
    }

    @Override
    public int getFluidInSlot() {
        return 2;
    }

    @Override
    public int getFluidOutSlot() {
        return 3;
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new MachineBulbReprocessorContainer(id, inv, this);
    }

    public void setSelectedId(int buttonId) {
        this.selectedId = buttonId;
    }

    @Override
    public int getKnowledgePerAction() {
        return 10;
    }
}

