/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryFluidTileEntity;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;

public abstract class ConvertEnergyInventoryFluidTileEntity
extends EnergyInventoryFluidTileEntity {
    public ConvertEnergyInventoryFluidTileEntity(TileEntityType<?> type, int energyStorage, int invSize, int maxBiomassStorage, int tier) {
        super(type, energyStorage, invSize, maxBiomassStorage, tier);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.energystorage.getEnergyStored() >= this.energyPerAction() && this.biomassCap.getCurrentStorage() >= this.fluidPerAction()) {
            ItemStack input = this.getInput();
            ItemStack output = this.getOutput();
            if (!input.func_190926_b() && this.canProceed(input, output)) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    this.increaseProgress();
                    if (this.getEnergyConsumptionType() == EnergyInventoryTileEntity.EnergyConsumptionType.PER_TICK) {
                        this.energystorage.extractEnergy(this.energyPerAction(), false);
                    }
                    if (this.getFluidConsumptionType() == EnergyInventoryTileEntity.FluidConsumptionType.PER_TICK) {
                        this.biomassCap.extractBiomass(this.fluidPerAction());
                    }
                } else if (this.onProcessFinished(input, output)) {
                    if (this.getEnergyConsumptionType() != EnergyInventoryTileEntity.EnergyConsumptionType.NONE) {
                        this.energystorage.extractEnergy(this.energyPerAction(), false);
                    }
                    if (this.getFluidConsumptionType() != EnergyInventoryTileEntity.FluidConsumptionType.NONE) {
                        this.biomassCap.extractBiomass(this.fluidPerAction());
                    }
                    this.resetProgress();
                    this.addKnowledge();
                }
            } else {
                this.resetProgress();
            }
        }
    }

    protected boolean hasEnoughFluid() {
        return this.biomassCap.getCurrentStorage() >= this.fluidPerAction();
    }

    protected abstract boolean canProceed(ItemStack var1, ItemStack var2);

    protected abstract ItemStack getResult(ItemStack var1, ItemStack var2);

    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        ItemStack result = this.getResult(input, output);
        if (this.itemhandler.insertItem(this.getOutputSlotIndex(), result, false).func_190926_b()) {
            input.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    protected void resetProgress() {
        if (this.shouldResetProgressIfNotProcessing()) {
            super.resetProgress();
        }
    }

    protected boolean shouldResetProgressIfNotProcessing() {
        return true;
    }

    public int getInputSlotIndex() {
        return 0;
    }

    public int getOutputSlotIndex() {
        return 1;
    }

    public ItemStack getInput() {
        return this.itemhandler.getStackInSlot(this.getInputSlotIndex());
    }

    public ItemStack getOutput() {
        return this.itemhandler.getStackInSlot(this.getOutputSlotIndex());
    }

    public int fluidPerAction() {
        return 5 + this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 3;
    }

    protected EnergyInventoryTileEntity.FluidConsumptionType getFluidConsumptionType() {
        return EnergyInventoryTileEntity.FluidConsumptionType.PER_TICK;
    }
}

