/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;

public abstract class ConvertEnergyInventoryTileEntity
extends EnergyInventoryTileEntity {
    public ConvertEnergyInventoryTileEntity(TileEntityType<?> type, int energyStorage, int invSize, int tier) {
        super(type, energyStorage, invSize, tier);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.energystorage.getEnergyStored() >= this.energyPerAction()) {
            ItemStack input = this.getInput();
            ItemStack output = this.getOutput();
            if (!input.func_190926_b() && this.canProceed(input, output)) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    this.increaseProgress();
                    if (this.getEnergyConsumptionType() == EnergyInventoryTileEntity.EnergyConsumptionType.PER_TICK) {
                        this.energystorage.extractEnergy(this.energyPerAction(), false);
                    }
                } else if (this.onProcessFinished(input, output)) {
                    if (this.getEnergyConsumptionType() != EnergyInventoryTileEntity.EnergyConsumptionType.NONE) {
                        this.energystorage.extractEnergy(this.energyPerAction(), false);
                    }
                    this.resetProgress();
                    this.addKnowledge();
                }
            } else {
                this.resetProgress();
            }
        }
    }

    protected abstract boolean canProceed(ItemStack var1, ItemStack var2);

    protected abstract ItemStack getResult(ItemStack var1, ItemStack var2);

    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        ItemStack result = this.getResult(input, output);
        if (this.itemhandler.insertItem(this.getOutputSlotIndex(), result, false).func_190926_b()) {
            input.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    protected void resetProgress() {
        if (this.shouldResetProgressIfNotProcessing()) {
            super.resetProgress();
        }
    }

    protected boolean shouldResetProgressIfNotProcessing() {
        return true;
    }

    public int getInputSlotIndex() {
        return 0;
    }

    public int getOutputSlotIndex() {
        return 1;
    }

    public ItemStack getInput() {
        return this.itemhandler.getStackInSlot(this.getInputSlotIndex());
    }

    public ItemStack getOutput() {
        return this.itemhandler.getStackInSlot(this.getOutputSlotIndex());
    }
}

