/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.fluids.capability.BiomassFluidEnergy;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.kaneka.planttech2.items.BiomassContainerItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public abstract class EnergyInventoryFluidTileEntity
extends EnergyInventoryTileEntity {
    protected final IBiomassFluidEnergy biomassCap = BiomassFluidEnergy.getTECap(this);

    public EnergyInventoryFluidTileEntity(TileEntityType<?> type, int energyStorage, int invSize, int maxBiomassStorage, int tier) {
        super(type, energyStorage, invSize, tier);
        this.biomassCap.setMaxStorage(maxBiomassStorage);
        this.biomassCap.setCurrentStorage(0);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        this.doFluidLoop();
    }

    public void doFluidLoop() {
        boolean changesMade = false;
        ItemStack stack = this.itemhandler.getStackInSlot(this.getFluidInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getFluidOutSlot());
        if (this.biomassCap.getCurrentStorage() < this.biomassCap.getMaxStorage()) {
            if (stack.func_77973_b() instanceof BiomassContainerItem) {
                if (this.biomassCap.getCurrentStorage() < this.biomassCap.getMaxStorage()) {
                    this.biomassCap.changeCurrentStorage(BiomassFluidEnergy.getItemStackCap(stack).extractBiomass(1));
                    this.itemhandler.setStackInSlot(this.getFluidInSlot(), stack);
                }
                changesMade = true;
            } else if (stack.func_77973_b() == ModItems.BIOMASS_BUCKET) {
                stack.func_190918_g(1);
                this.itemhandler.setStackInSlot(this.getFluidInSlot(), new ItemStack((IItemProvider)Items.field_151133_ar));
                this.biomassCap.recieveBiomass(3000);
                changesMade = true;
            }
        }
        if (stack2.func_77973_b() instanceof BiomassContainerItem) {
            IBiomassFluidEnergy capability = BiomassFluidEnergy.getItemStackCap(stack2);
            int need = capability.getMaxStorage() - capability.getCurrentStorage();
            int have = this.biomassCap.getCurrentStorage();
            int amount = this.biomassCap.extractBiomass(Math.min(Math.min(need, have), 4));
            capability.recieveBiomass(amount);
            this.itemhandler.setStackInSlot(this.getFluidOutSlot(), stack2);
            changesMade = true;
        } else if (stack2.func_77973_b() == Items.field_151133_ar && this.biomassCap.getCurrentStorage() >= 3000) {
            stack2.func_190918_g(1);
            this.itemhandler.setStackInSlot(this.getFluidOutSlot(), new ItemStack((IItemProvider)ModItems.BIOMASS_BUCKET));
            this.biomassCap.extractBiomass(3000);
            changesMade = true;
        }
        if (changesMade) {
            this.func_70296_d();
        }
    }

    public abstract int getFluidInSlot();

    public abstract int getFluidOutSlot();
}

