/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class EnergyInventoryTileEntity
extends EnergyTileEntity {
    protected ItemStackHandler itemhandler;
    protected LazyOptional<IItemHandler> inventoryCap;
    protected int ticksPassed = 0;
    protected int tier;

    public EnergyInventoryTileEntity(TileEntityType<?> type, int energyStorage, int invSize, int tier) {
        super(type, energyStorage);
        this.itemhandler = new ItemStackHandler(invSize);
        this.inventoryCap = LazyOptional.of(() -> this.itemhandler);
        this.tier = tier;
    }

    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemhandler.getSlots(); ++i) {
            stacks.add(this.itemhandler.getStackInSlot(i).func_77946_l());
        }
        return stacks;
    }

    @Override
    public void doUpdate() {
        this.doEnergyLoop();
    }

    protected void resetProgress() {
        this.ticksPassed = 0;
    }

    public void doEnergyLoop() {
        ItemStack stack = this.itemhandler.getStackInSlot(this.getEnergyInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getEnergyOutSlot());
        if (stack.func_77973_b() instanceof IItemChargeable && this.energystorage.getEnergyStored() < this.energystorage.getMaxEnergyStored()) {
            this.energystorage.receiveEnergy(((IItemChargeable)stack.func_77973_b()).extractEnergy(stack, 1, false));
        }
        if (stack2.func_77973_b() instanceof IItemChargeable && this.energystorage.getEnergyStored() >= 1) {
            this.energystorage.extractEnergy(((IItemChargeable)stack2.func_77973_b()).receiveEnergy(stack2, 1, false));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.itemhandler.serializeNBT());
        compound.func_74768_a("tickspassed", this.ticksPassed);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        int slotamount = this.itemhandler.getSlots();
        this.itemhandler.deserializeNBT(compound.func_74775_l("inventory"));
        if (this.itemhandler.getSlots() != slotamount) {
            this.itemhandler.setSize(slotamount);
        }
        this.ticksPassed = compound.func_74762_e("tickspassed");
    }

    public static void spawnAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (worldIn != null && !worldIn.field_72995_K && !stack.func_190926_b() && !worldIn.restoringBlockSnapshots && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity entityitem = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            worldIn.func_217376_c((Entity)entityitem);
        }
    }

    public int energyPerAction() {
        return 4 + this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 35;
    }

    protected EnergyConsumptionType getEnergyConsumptionType() {
        return EnergyConsumptionType.PER_TICK;
    }

    public int getCapacityUpgrade() {
        return this.getUpgradeTier(TierItem.ItemType.CAPACITY_UPGRADE);
    }

    protected void increaseProgress() {
        ++this.ticksPassed;
    }

    public int getUpgradeTier(TierItem.ItemType itemType) {
        return this.getUpgradeTier(this.getUpgradeSlot(), itemType);
    }

    public int getUpgradeTier(int slot, TierItem.ItemType itemType) {
        TierItem item;
        if (slot == -1) {
            return 0;
        }
        ItemStack stack = this.itemhandler.getStackInSlot(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof TierItem && (item = (TierItem)stack.func_77973_b()).getItemType() == itemType) {
            return item.getTier();
        }
        return 0;
    }

    public void onContainerUpdated(int slotIndex) {
    }

    public abstract int getEnergyInSlot();

    public abstract int getEnergyOutSlot();

    protected ItemStack getKnowledgeChip() {
        return this.itemhandler.getStackInSlot(this.getKnowledgeChipSlot());
    }

    protected void addKnowledge() {
        ItemStack chip = this.getKnowledgeChip();
        ItemStack newChip = KnowledgeChip.addKnowledge(chip, this.getKnowledgePerAction(), this.tier);
        if (!(chip.func_190926_b() || newChip.func_190926_b() || chip.func_77973_b().equals(newChip.func_77973_b()))) {
            this.itemhandler.setStackInSlot(this.getKnowledgeChipSlot(), newChip);
        }
    }

    public abstract int getKnowledgeChipSlot();

    public abstract int getKnowledgePerAction();

    public int getTotalCapacity() {
        return this.getTotalCapacity(this.getUpgradeSlot());
    }

    public int getTotalCapacity(int capacityChipSlot) {
        return (int)(1000.0 * Math.pow(10.0, this.getUpgradeTier(capacityChipSlot, TierItem.ItemType.CAPACITY_UPGRADE)));
    }

    public static enum FluidConsumptionType {
        PER_TICK,
        PER_PROCESS,
        NONE;

    }

    public static enum EnergyConsumptionType {
        PER_TICK,
        PER_PROCESS,
        NONE;

    }
}

