/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class NBTHelper {
    public static int getInt(ItemStack stack, String key, int defaultValue) {
        return NBTHelper.getInt(stack.func_77978_p(), key, defaultValue);
    }

    public static int getInt(CompoundNBT nbt, String key, int defaultValue) {
        if (nbt != null && nbt.func_150297_b(key, 99)) {
            return nbt.func_74762_e(key);
        }
        return defaultValue;
    }

    public static float getFloat(ItemStack stack, String key, int defaultValue) {
        return NBTHelper.getFloat(stack.func_77978_p(), key, (float)defaultValue);
    }

    public static float getFloat(CompoundNBT nbt, String key, float defaultValue) {
        if (nbt != null && nbt.func_150297_b(key, 99)) {
            return nbt.func_74760_g(key);
        }
        return defaultValue;
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultValue) {
        return NBTHelper.getBoolean(stack.func_77978_p(), key, defaultValue);
    }

    public static boolean getBoolean(CompoundNBT nbt, String key, boolean defaultValue) {
        if (nbt != null && nbt.func_74764_b(key)) {
            return nbt.func_74767_n(key);
        }
        return defaultValue;
    }

    public static <E extends ISerializable> void putSerilizableList(CompoundNBT compound, String key, Collection<E> collection) {
        NBTHelper.putList(compound, key, collection, ISerializable::write);
    }

    public static <E> void putList(CompoundNBT compound, String key, Collection<E> collection, Function<E, INBT> serializer) {
        ListNBT list = new ListNBT();
        for (E e : collection) {
            list.add((Object)serializer.apply(e));
        }
        compound.func_218657_a(key, (INBT)list);
    }

    public static <E> List<E> constructListFromCompound(CompoundNBT compound, String key, Function<CompoundNBT, E> constructor) {
        return NBTHelper.constructListNotNull(compound, key, nbt -> (CompoundNBT)nbt, constructor, 10);
    }

    public static <E> List<E> constructListFromString(CompoundNBT compound, String key, Function<String, E> constructor) {
        return NBTHelper.constructListNotNull(compound, key, nbt -> ((StringNBT)nbt).func_150285_a_(), constructor, 8);
    }

    public static <E> List<E> constructListFromInteger(CompoundNBT compound, String key, Function<Integer, E> constructor) {
        return NBTHelper.constructListNotNull(compound, key, nbt -> ((IntNBT)nbt).func_150287_d(), constructor, 3);
    }

    private static <E, T> List<E> constructListNotNull(CompoundNBT compound, String key, Function<INBT, T> typeGetter, Function<T, E> constructor, int type) {
        ListNBT list = compound.func_150295_c(key, type);
        ArrayList<E> results = new ArrayList<E>();
        for (INBT inbt : list) {
            T t = typeGetter.apply(inbt);
            if (t != null) {
                E e = constructor.apply(t);
                if (e != null) {
                    results.add(e);
                    continue;
                }
                PlantTechMain.LOGGER.error("value is null, this should not happen");
                continue;
            }
            PlantTechMain.LOGGER.error("value type is null, this should not happen");
        }
        return results;
    }
}

