/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import owmii.powah.api.recipe.energizing.IEnergizingRegistry;

public class PowahAPI {
    public static final Set<IEnergizingRegistry> ENERGIZING_REGISTRIES = new HashSet<IEnergizingRegistry>();
    public static final Map<Fluid, Integer> MAGMATIC_FLUIDS = new HashMap<Fluid, Integer>();
    public static final Map<Fluid, Integer> THERMO_COOLANTS = new HashMap<Fluid, Integer>();
    public static final Map<Block, Integer> THERMO_HEAT_SOURCES = new HashMap<Block, Integer>();
    public static final Map<Fluid, Integer> REACTOR_COOLANTS = new HashMap<Fluid, Integer>();
    public static final Map<ResourceLocation, Pair<Integer, Integer>> REACTOR_SOLID_COOLANTS = new HashMap<ResourceLocation, Pair<Integer, Integer>>();

    public static void register(IEnergizingRegistry registry) {
        ENERGIZING_REGISTRIES.add(registry);
    }

    public static void registerMagmaticFluid(Fluid fluid, int heat) {
        MAGMATIC_FLUIDS.put(fluid, heat);
    }

    public static int getMagmaticFluidHeat(Fluid fluid) {
        if (MAGMATIC_FLUIDS.containsKey(fluid)) {
            return MAGMATIC_FLUIDS.get(fluid);
        }
        return 0;
    }

    public static void registerThermoCoolant(Fluid fluid, int cooling) {
        THERMO_COOLANTS.put(fluid, cooling);
    }

    public static int getThermoCoolant(Fluid fluid) {
        if (THERMO_COOLANTS.containsKey(fluid)) {
            return THERMO_COOLANTS.get(fluid);
        }
        return 0;
    }

    public static void registerThermoHeatSource(Block block, int heat) {
        THERMO_HEAT_SOURCES.put(block, heat);
    }

    public static int getThermoHeatSource(Block block) {
        if (THERMO_HEAT_SOURCES.containsKey(block)) {
            return THERMO_HEAT_SOURCES.get(block);
        }
        return 0;
    }

    public static void registerReactorCoolant(Fluid fluid, int cooling) {
        REACTOR_COOLANTS.put(fluid, cooling);
    }

    public static int getReactorCoolant(Fluid fluid) {
        if (REACTOR_COOLANTS.containsKey(fluid)) {
            return REACTOR_COOLANTS.get(fluid);
        }
        return 0;
    }

    public static void registerReactorSolidCoolant(IItemProvider item, int size, int cooling) {
        REACTOR_SOLID_COOLANTS.put(item.func_199767_j().getRegistryName(), (Pair<Integer, Integer>)Pair.of((Object)size, (Object)cooling));
    }

    public static Pair<Integer, Integer> getReactorSolidCoolant(IItemProvider item) {
        if (REACTOR_SOLID_COOLANTS.containsKey(item.func_199767_j().getRegistryName())) {
            return REACTOR_SOLID_COOLANTS.get(item.func_199767_j().getRegistryName());
        }
        return Pair.of((Object)0, (Object)0);
    }
}

