/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import owmii.lib.block.IBlockBase;
import owmii.lib.item.BlockItemBase;
import owmii.powah.block.OreBlockBase;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.Cables;
import owmii.powah.block.discharger.DischargerBlock;
import owmii.powah.block.endercell.EnderCellBlock;
import owmii.powah.block.endercell.EnderCells;
import owmii.powah.block.endergate.EnderGateBlock;
import owmii.powah.block.endergate.EnderGates;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.block.energizing.EnergizingRodBlock;
import owmii.powah.block.energizing.EnergizingRods;
import owmii.powah.block.energycell.EnergyCellBlock;
import owmii.powah.block.energycell.EnergyCells;
import owmii.powah.block.generator.furnator.FurnatorBlock;
import owmii.powah.block.generator.furnator.Furnators;
import owmii.powah.block.generator.magmatic.MagmaticGenBlock;
import owmii.powah.block.generator.magmatic.MagmaticGenerators;
import owmii.powah.block.generator.panel.solar.SolarPanelBlock;
import owmii.powah.block.generator.panel.solar.SolarPanels;
import owmii.powah.block.generator.reactor.ReactorBlock;
import owmii.powah.block.generator.reactor.Reactors;
import owmii.powah.block.generator.thermoelectric.ThermoGeneratorBlock;
import owmii.powah.block.generator.thermoelectric.ThermoGenerators;
import owmii.powah.block.hopper.EnergyHopperBlock;
import owmii.powah.block.transmitter.PlayerTransmitterBlock;
import owmii.powah.item.ItemGroups;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class IBlocks {
    public static final List<BlockItem> BLOCK_ITEMS = new ArrayList<BlockItem>();
    public static final List<Block> BLOCKS = new ArrayList<Block>();
    public static final EnergyCellBlock[] ENERGY_CELLS;
    public static final EnderGateBlock[] ENDER_GATES;
    public static final FurnatorBlock[] FURNATORS;
    public static final MagmaticGenBlock[] MAGMATIC_GENERATORS;
    public static final ThermoGeneratorBlock[] THERMO_GENERATORS;
    public static final SolarPanelBlock[] SOLAR_PANELS;
    public static final ReactorBlock[] REACTORS;
    public static final PlayerTransmitterBlock PLAYER_TRANSMITTER;
    public static final PlayerTransmitterBlock PLAYER_TRANSMITTER_DIM;
    public static final DischargerBlock DISCHARGER;
    public static final EnergyHopperBlock ENERGY_HOPPER;
    public static final EnergizingOrbBlock ENERGIZING_ORB;
    public static final EnergizingRodBlock[] ENERGIZING_RODS;
    public static final CableBlock[] CABLES;
    public static final EnderCellBlock[] ENDER_CELLS;
    public static final OreBlockBase URANINITE_ORE_POOR;
    public static final OreBlockBase URANINITE_ORE;
    public static final OreBlockBase URANINITE_ORE_DENSE;
    public static final OreBlockBase DRY_ICE;

    static <T extends Block> T register(String name, T block) {
        BlockItemBase itemBlock = ((IBlockBase)block).getBlockItem(new Item.Properties(), ItemGroups.MAIN);
        itemBlock.setRegistryName(name);
        block.setRegistryName(name);
        BLOCK_ITEMS.add((BlockItem)itemBlock);
        BLOCKS.add(block);
        return block;
    }

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.Register<Block> event) {
        BLOCKS.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
    }

    static {
        EnergyCells[] cells = EnergyCells.values();
        ENERGY_CELLS = new EnergyCellBlock[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            EnergyCells cell = cells[i];
            IBlocks.ENERGY_CELLS[i] = (EnergyCellBlock)((Object)IBlocks.register("energy_cell_" + cell.name().toLowerCase(), new EnergyCellBlock(Block.Properties.func_200945_a((Material)cell.material).func_200948_a(2.0f, cell.resistance), cell.capacity, cell.transfer).setCreative(cell.isCreative)));
        }
        EnderCells[] enderCells = EnderCells.values();
        ENDER_CELLS = new EnderCellBlock[enderCells.length];
        for (int i = 0; i < enderCells.length; ++i) {
            EnderCells cell = enderCells[i];
            IBlocks.ENDER_CELLS[i] = IBlocks.register("ender_cell_" + cell.name().toLowerCase(), new EnderCellBlock(Block.Properties.func_200945_a((Material)cell.material).func_200948_a(2.0f, cell.resistance), cell.transfer, cell.transfer, cell.channels));
        }
        Furnators[] furnators = Furnators.values();
        FURNATORS = new FurnatorBlock[furnators.length];
        for (int i = 0; i < furnators.length; ++i) {
            Furnators furnator = furnators[i];
            IBlocks.FURNATORS[i] = IBlocks.register("furnator_" + furnator.name().toLowerCase(), new FurnatorBlock(Block.Properties.func_200945_a((Material)furnator.material).func_200948_a(2.0f, furnator.resistance), furnator.capacity, furnator.transfer, furnator.perTick));
        }
        MagmaticGenerators[] magmaticValues = MagmaticGenerators.values();
        MAGMATIC_GENERATORS = new MagmaticGenBlock[magmaticValues.length];
        for (int i = 0; i < magmaticValues.length; ++i) {
            MagmaticGenerators magmaticValue = magmaticValues[i];
            IBlocks.MAGMATIC_GENERATORS[i] = IBlocks.register("magmatic_generator_" + magmaticValue.name().toLowerCase(), new MagmaticGenBlock(Block.Properties.func_200945_a((Material)magmaticValue.material).func_200948_a(2.0f, magmaticValue.resistance), magmaticValue.capacity, magmaticValue.transfer, magmaticValue.perTick, magmaticValue.buckets));
        }
        ThermoGenerators[] thermoGenerators = ThermoGenerators.values();
        THERMO_GENERATORS = new ThermoGeneratorBlock[thermoGenerators.length];
        for (int i = 0; i < thermoGenerators.length; ++i) {
            ThermoGenerators tg = thermoGenerators[i];
            IBlocks.THERMO_GENERATORS[i] = IBlocks.register("thermo_generator_" + tg.name().toLowerCase(), new ThermoGeneratorBlock(Block.Properties.func_200945_a((Material)tg.material).func_200948_a(2.0f, tg.resistance), tg.capacity, tg.transfer, tg.perTick));
        }
        SolarPanels[] panels = SolarPanels.values();
        SOLAR_PANELS = new SolarPanelBlock[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            SolarPanels panel = panels[i];
            IBlocks.SOLAR_PANELS[i] = IBlocks.register("solar_panel_" + panel.name().toLowerCase(), new SolarPanelBlock(Block.Properties.func_200945_a((Material)panel.material).func_200948_a(2.0f, panel.resistance), panel.capacity, panel.transfer, panel.perTick));
        }
        Reactors[] reactors = Reactors.values();
        REACTORS = new ReactorBlock[reactors.length];
        for (int i = 0; i < reactors.length; ++i) {
            Reactors reactor = reactors[i];
            IBlocks.REACTORS[i] = IBlocks.register("reactor_" + reactor.name().toLowerCase(), new ReactorBlock(Block.Properties.func_200945_a((Material)reactor.material).func_200948_a(15.0f, reactor.resistance), reactor.capacity, reactor.transfer, reactor.perTick));
        }
        DISCHARGER = IBlocks.register("discharger", new DischargerBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 15.0f), 500000, 1000));
        ENERGY_HOPPER = IBlocks.register("energy_hopper", new EnergyHopperBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 15.0f), 500000, 1000));
        PLAYER_TRANSMITTER = IBlocks.register("player_transmitter", new PlayerTransmitterBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 15.0f).func_200942_a(), 10000, 100, 1, false));
        PLAYER_TRANSMITTER_DIM = IBlocks.register("player_transmitter_dim", new PlayerTransmitterBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 15.0f).func_200942_a(), 100000, 250, 2, true));
        ENERGIZING_ORB = IBlocks.register("energizing_orb", new EnergizingOrbBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 15.0f)));
        EnergizingRods[] rods = EnergizingRods.values();
        ENERGIZING_RODS = new EnergizingRodBlock[rods.length];
        for (int i = 0; i < rods.length; ++i) {
            EnergizingRods rod = rods[i];
            IBlocks.ENERGIZING_RODS[i] = IBlocks.register("energizing_rod_" + rod.name().toLowerCase(), new EnergizingRodBlock(Block.Properties.func_200945_a((Material)rod.material).func_200948_a(1.0f, rod.resistance).func_200942_a(), rod.capacity, rod.transfer, rod.energizingSpeed));
        }
        Cables[] cables = Cables.values();
        CABLES = new CableBlock[cables.length];
        for (int i = 0; i < cables.length; ++i) {
            Cables cable = cables[i];
            IBlocks.CABLES[i] = IBlocks.register("cable_" + cable.name().toLowerCase(), new CableBlock(Block.Properties.func_200945_a((Material)cable.material).func_200948_a(1.0f, cable.resistance).func_200942_a(), cable.transfer, cable.transfer));
        }
        EnderGates[] gates = EnderGates.values();
        ENDER_GATES = new EnderGateBlock[gates.length];
        for (int i = 0; i < gates.length; ++i) {
            EnderGates gate = gates[i];
            IBlocks.ENDER_GATES[i] = IBlocks.register("ender_gate_" + gate.name().toLowerCase(), new EnderGateBlock(Block.Properties.func_200945_a((Material)gate.material).func_200948_a(2.0f, gate.resistance).func_200942_a().func_200951_a(2), gate.transfer, gate.transfer, gate.channels));
        }
        URANINITE_ORE_POOR = IBlocks.register("uraninite_ore_poor", new OreBlockBase(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f)));
        URANINITE_ORE = IBlocks.register("uraninite_ore", new OreBlockBase(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f)));
        URANINITE_ORE_DENSE = IBlocks.register("uraninite_ore_dense", new OreBlockBase(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f)));
        DRY_ICE = IBlocks.register("dry_ice", new OreBlockBase(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f)));
    }
}

