/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import owmii.powah.block.IBlocks;
import owmii.powah.block.cable.CableTile;
import owmii.powah.block.discharger.DischargerTile;
import owmii.powah.block.endercell.EnderCellTile;
import owmii.powah.block.endergate.EnderGateTile;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.block.energycell.EnergyCellTile;
import owmii.powah.block.generator.furnator.FurnatorTile;
import owmii.powah.block.generator.magmatic.MagmaticGenTile;
import owmii.powah.block.generator.panel.solar.SolarPanelTile;
import owmii.powah.block.generator.reactor.ReactorTile;
import owmii.powah.block.generator.thermoelectric.ThermoGeneratorTile;
import owmii.powah.block.hopper.EnergyHopperTile;
import owmii.powah.block.transmitter.PlayerTransmitterTile;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ITiles {
    public static final List<TileEntityType<?>> TILE_ENTITY_TYPES = new ArrayList();
    public static final TileEntityType<?> ENERGY_CELL = ITiles.register("energy_cell", EnergyCellTile::new, (Block[])IBlocks.ENERGY_CELLS);
    public static final TileEntityType<?> ENDER_CELL = ITiles.register("ender_cell", EnderCellTile::new, (Block[])IBlocks.ENDER_CELLS);
    public static final TileEntityType<?> ENDER_GATE = ITiles.register("ender_gate", EnderGateTile::new, (Block[])IBlocks.ENDER_GATES);
    public static final TileEntityType<?> MAGMATIC_GENERATOR = ITiles.register("magmatic_generator", MagmaticGenTile::new, (Block[])IBlocks.MAGMATIC_GENERATORS);
    public static final TileEntityType<?> FURNATOR = ITiles.register("furnator", FurnatorTile::new, (Block[])IBlocks.FURNATORS);
    public static final TileEntityType<?> PLAYER_TRANSMITTER = ITiles.register("player_transmitter", PlayerTransmitterTile::new, new Block[]{IBlocks.PLAYER_TRANSMITTER, IBlocks.PLAYER_TRANSMITTER_DIM});
    public static final TileEntityType<?> SOLAR_PANEL = ITiles.register("solar_panel", SolarPanelTile::new, (Block[])IBlocks.SOLAR_PANELS);
    public static final TileEntityType<?> THERMO_GENERATOR = ITiles.register("thermo_generator_", ThermoGeneratorTile::new, (Block[])IBlocks.THERMO_GENERATORS);
    public static final TileEntityType<?> CABLE = ITiles.register("cable", CableTile::new, (Block[])IBlocks.CABLES);
    public static final TileEntityType<?> DISCHARGER = ITiles.register("discharger", DischargerTile::new, new Block[]{IBlocks.DISCHARGER});
    public static final TileEntityType<?> ENERGY_HOPPER = ITiles.register("energy_hopper", EnergyHopperTile::new, new Block[]{IBlocks.ENERGY_HOPPER});
    public static final TileEntityType<?> ENERGIZING_ORB = ITiles.register("energizing_orb", EnergizingOrbTile::new, new Block[]{IBlocks.ENERGIZING_ORB});
    public static final TileEntityType<?> ENERGIZING_ROD = ITiles.register("energizing_rod", EnergizingRodTile::new, (Block[])IBlocks.ENERGIZING_RODS);
    public static final TileEntityType<?> REACTOR = ITiles.register("reactor", ReactorTile::new, (Block[])IBlocks.REACTORS);

    static <T extends TileEntity> TileEntityType<T> register(String name, Supplier<? extends T> factoryIn, Block ... b) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(factoryIn, (Block[])b).func_206865_a(null);
        type.setRegistryName(name);
        TILE_ENTITY_TYPES.add(type);
        return type;
    }

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
        TILE_ENTITY_TYPES.forEach(tileType -> event.getRegistry().register((IForgeRegistryEntry)tileType));
    }
}

