/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import owmii.lib.block.BlockBase;
import owmii.lib.item.BlockItemBase;
import owmii.lib.util.Energy;
import owmii.lib.util.Text;
import owmii.powah.block.PowahTile;
import owmii.powah.block.generator.GeneratorBlock;
import owmii.powah.energy.ItemPowahStorage;
import owmii.powah.item.PowahBlockItem;

public abstract class PowahBlock
extends BlockBase {
    protected int capacity;
    protected int maxExtract;
    protected int maxReceive;
    protected boolean isCreative;

    public PowahBlock(Block.Properties properties, int capacity, int maxExtract, int maxReceive) {
        super(properties);
        this.capacity = capacity;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new PowahBlockItem(this, properties, group);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PowahTile) {
            PowahTile powahTile = (PowahTile)tileEntity;
            powahTile.sideConfig.init();
        }
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    public void tooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Energy.getForgeEnergy((ItemStack)stack).ifPresent(storage -> {
            if (storage instanceof ItemPowahStorage && !this.isCreative()) {
                if (storage.getMaxEnergyStored() > 0) {
                    tooltip.add(new TranslationTextComponent("info.powah.stored", new Object[]{TextFormatting.DARK_GRAY + Text.addCommas((long)storage.getEnergyStored()), Text.numFormat((long)storage.getMaxEnergyStored())}).func_211708_a(TextFormatting.GRAY));
                }
                if (this.getBlock() instanceof GeneratorBlock) {
                    tooltip.add(new TranslationTextComponent("info.powah.generates", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)((GeneratorBlock)this.getBlock()).perTick())}).func_211708_a(TextFormatting.GRAY));
                }
                int maxIn = this.getMaxReceive();
                int maxOut = this.getMaxExtract();
                tooltip.add(new TranslationTextComponent("info.powah.max.io", new Object[]{TextFormatting.DARK_GRAY + (maxIn == maxOut ? Text.numFormat((long)maxOut) : (maxIn == 0 || maxOut == 0 ? Text.numFormat((long)Math.max(maxIn, maxOut)) : Text.numFormat((long)maxIn) + "/" + Text.numFormat((long)maxOut)))}).func_211708_a(TextFormatting.GRAY));
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
        });
    }

    public int stackSize() {
        return 1;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setTransfer(int transfer) {
        this.maxReceive = transfer;
        this.maxExtract = transfer;
    }

    public <T extends PowahBlock> T setCreative(boolean isCreative) {
        this.isCreative = isCreative;
        return (T)((Object)this);
    }
}

