/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import owmii.lib.block.TileBase;
import owmii.lib.util.Energy;
import owmii.powah.block.PowahBlock;
import owmii.powah.energy.PowahStorage;
import owmii.powah.energy.RedstoneMode;
import owmii.powah.energy.SideConfig;

public abstract class PowahTile
extends TileBase.Tickable {
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    public final PowahStorage internal;
    protected SideConfig sideConfig;
    protected boolean isCreative;

    public PowahTile(TileEntityType<?> type, int capacity, int maxReceive, int maxExtract, boolean isCreative) {
        super(type);
        this.internal = new PowahStorage(capacity, maxReceive, maxExtract);
        this.sideConfig = new SideConfig(this);
        this.isCreative = isCreative;
        if (isCreative) {
            this.internal.setEnergy(capacity);
            this.internal.setMaxReceive(0);
        }
        this.inv.add(this.getChargingSlots() + this.getUpgradeSlots());
    }

    public void readStorable(CompoundNBT compound) {
        super.readStorable(compound);
        this.internal.read(compound);
        this.isCreative = compound.func_74767_n("IsCreative");
    }

    public CompoundNBT writeStorable(CompoundNBT compound) {
        this.internal.write(compound);
        compound.func_74757_a("IsCreative", this.isCreative);
        return super.writeStorable(compound);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.sideConfig.read(compound);
        this.redstoneMode = RedstoneMode.values()[compound.func_74762_e("RedstoneMode")];
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        this.sideConfig.write(compound);
        compound.func_74768_a("RedstoneMode", this.redstoneMode.ordinal());
        return super.writeSync(compound);
    }

    protected void firstTick() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getBlock() instanceof PowahBlock) {
            PowahBlock powahBlock = (PowahBlock)this.getBlock();
            this.internal.setCapacity(powahBlock.capacity);
            this.internal.setMaxExtract(powahBlock.maxExtract);
            this.internal.setMaxReceive(powahBlock.maxReceive);
            if (this.isCreative) {
                this.internal.setEnergy(powahBlock.capacity);
                this.internal.setMaxExtract(powahBlock.capacity);
                this.internal.setMaxReceive(0);
            }
            this.markDirtyAndSync();
        }
    }

    protected boolean postTicks() {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        int extracted = 0;
        if (this.canExtractFromSides()) {
            for (Direction direction : Direction.values()) {
                if (!this.canExtract(direction)) continue;
                int amount = Math.min(this.getMaxExtract(), this.getEnergyStored());
                int received = Energy.receive((TileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction)), (Direction)direction, (int)amount, (boolean)false);
                extracted += this.extractEnergy(received, false, direction);
            }
        }
        if (this.canChargeItems() && this.canExtract(null)) {
            for (int i = 0; i < this.getChargingSlots(); ++i) {
                extracted += this.chargeItem(this.inv.getStackInSlot(i));
            }
        }
        return extracted > 0;
    }

    protected int chargeItem(ItemStack stack) {
        return this.chargeItem(stack, this.getMaxExtract());
    }

    protected int chargeItem(ItemStack stack, int transfer) {
        if (!stack.func_190926_b()) {
            int amount = Math.min(transfer, this.getEnergyStored());
            int received = Energy.receive((ItemStack)stack, (int)amount, (boolean)false);
            return this.extractEnergy(received, false, null);
        }
        return 0;
    }

    public int getSyncTicks() {
        return this.isContainerOpen() ? 5 : 20;
    }

    public int getSlotLimit(int index) {
        if (index < this.builtInSlots()) {
            return 1;
        }
        return 64;
    }

    public int[] nonBuiltInSlots() {
        int[] slots = new int[this.inv.getSlots() - this.builtInSlots()];
        for (int i = this.builtInSlots(); i < this.inv.getSlots(); ++i) {
            slots[i] = i - this.builtInSlots();
        }
        return slots;
    }

    public int builtInSlots() {
        return this.getChargingSlots() + this.getUpgradeSlots();
    }

    private int getUpgradeSlots() {
        return 0;
    }

    public int getChargingSlots() {
        return 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction side) {
        if (!this.canReceive(side)) {
            return 0;
        }
        int energyReceived = Math.min(this.getCapacity() - this.getEnergyStored(), Math.min(this.getMaxReceive(), maxReceive));
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() + energyReceived, side);
            if (energyReceived > 0) {
                this.sync(this.getSyncTicks());
            }
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate, @Nullable Direction side) {
        if (!this.canExtract(side)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxExtract(), maxExtract));
        if (!simulate && !this.isCreative) {
            this.setEnergy(this.getEnergyStored() - energyExtracted, side);
            if (energyExtracted > 0) {
                this.sync(this.getSyncTicks());
            }
        }
        return energyExtracted;
    }

    public int getMaxReceive() {
        return this.internal.getMaxReceive();
    }

    public int getMaxExtract() {
        return this.internal.getMaxExtract();
    }

    public void setEnergy(int amount, @Nullable Direction side) {
        this.internal.setEnergy(amount);
    }

    public int getEnergyStored() {
        return this.internal.getEnergyStored();
    }

    public int getCapacity() {
        return this.internal.getMaxEnergyStored();
    }

    public PowahStorage getInternal() {
        return this.internal;
    }

    public SideConfig getSideConfig() {
        return this.sideConfig;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public boolean canExtract(@Nullable Direction side) {
        return this.checkRedstone() && (this.isOut(side) || side == null) && this.internal.canExtract();
    }

    public boolean isOut(@Nullable Direction side) {
        return side != null && this.sideConfig.getPowerMode(side).isOut();
    }

    public boolean canReceive(@Nullable Direction side) {
        return this.checkRedstone() && (this.isIn(side) || side == null) && this.internal.canReceive();
    }

    public boolean isIn(@Nullable Direction side) {
        return side != null && this.sideConfig.getPowerMode(side).isIn();
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
    }

    public void nextRedstoneMode() {
        RedstoneMode redstoneMode;
        int i = this.redstoneMode.ordinal() + 1;
        this.redstoneMode = redstoneMode = RedstoneMode.values()[i > 2 ? 0 : i];
        this.markDirtyAndSync();
    }

    protected boolean doTick() {
        return this.checkRedstone();
    }

    public boolean checkRedstone() {
        boolean power = this.field_145850_b != null && this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        return RedstoneMode.IGNORE.equals((Object)this.getRedstoneMode()) || power && RedstoneMode.ON.equals((Object)this.getRedstoneMode()) || !power && RedstoneMode.OFF.equals((Object)this.getRedstoneMode());
    }

    public boolean keepInventory() {
        return true;
    }

    public boolean canInsert(int index, ItemStack stack) {
        if (index < this.getChargingSlots()) {
            return Energy.isPresent((ItemStack)stack);
        }
        return true;
    }

    protected ExtractionType getExtractionType() {
        return ExtractionType.ALL;
    }

    public boolean isExtractor() {
        return this.canExtractFromSides();
    }

    public boolean canExtractFromSides() {
        return this.getExtractionType().equals((Object)ExtractionType.ALL) || this.getExtractionType().equals((Object)ExtractionType.TILE);
    }

    public boolean canChargeItems() {
        return this.getExtractionType().equals((Object)ExtractionType.ALL) || this.getExtractionType().equals((Object)ExtractionType.ITEM);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, final @Nullable Direction side) {
        return cap == CapabilityEnergy.ENERGY && this.func_145830_o() && this.isEnergyPresent(side) ? LazyOptional.of(() -> new PowahStorage(this.getInternal()){

            public int extractEnergy(int maxExtract, boolean simulate) {
                return PowahTile.this.extractEnergy(maxExtract, simulate, side);
            }

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return PowahTile.this.receiveEnergy(maxReceive, simulate, side);
            }

            @Override
            public boolean canReceive() {
                return PowahTile.this.canReceive(side);
            }

            @Override
            public boolean canExtract() {
                return PowahTile.this.canExtract(side);
            }
        }).cast() : super.getCapability(cap, side);
    }

    public boolean isEnergyPresent(@Nullable Direction side) {
        return true;
    }

    public static enum ExtractionType {
        ALL,
        ITEM,
        TILE,
        OFF;

    }
}

