/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import owmii.lib.block.TileBase;
import owmii.lib.client.handler.IHud;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.Energy;
import owmii.lib.util.Server;
import owmii.lib.util.Side;
import owmii.powah.api.cable.ICable;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.cable.CableNoneTileData;
import owmii.powah.block.cable.CableTile;
import owmii.powah.energy.PowerMode;
import owmii.powah.inventory.CableContainer;
import owmii.powah.inventory.IContainers;
import owmii.powah.item.WrenchItem;

public class CableBlock
extends PowahBlock
implements ICable,
IHud,
IWaterLoggable {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    public static final BooleanProperty DOWN = SixWayBlock.field_196489_A;
    public static final BooleanProperty TILE = BooleanProperty.func_177716_a((String)"tile");
    private static final VoxelShape CABLE = CableBlock.func_208617_a((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);
    private static final VoxelShape[] MULTIPART = new VoxelShape[]{CableBlock.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)6.5), CableBlock.func_208617_a((double)9.5, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), CableBlock.func_208617_a((double)7.0, (double)7.0, (double)9.5, (double)9.0, (double)9.0, (double)16.0), CableBlock.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)6.5, (double)9.0, (double)9.0), CableBlock.func_208617_a((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), CableBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.5, (double)9.0)};
    static final Map<BlockPos, Set<BlockPos>> CACHE = new HashMap<BlockPos, Set<BlockPos>>();

    public CableBlock(Block.Properties properties, int maxExtract, int maxReceive) {
        super(properties.func_200947_a(SoundType.field_185852_e), 0, maxExtract, maxReceive);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)TILE, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int stackSize() {
        return 64;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelShape = CABLE;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue() || this.canConnectEnergy(worldIn, pos, Direction.NORTH)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[0]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue() || this.canConnectEnergy(worldIn, pos, Direction.EAST)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[1]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue() || this.canConnectEnergy(worldIn, pos, Direction.SOUTH)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[2]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue() || this.canConnectEnergy(worldIn, pos, Direction.WEST)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[3]);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue() || this.canConnectEnergy(worldIn, pos, Direction.UP)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[4]);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() || this.canConnectEnergy(worldIn, pos, Direction.DOWN)) {
            voxelShape = VoxelShapes.func_197872_a((VoxelShape)voxelShape, (VoxelShape)MULTIPART[5]);
        }
        return voxelShape;
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof CableTile) {
            return new CableContainer(IContainers.CABLE, id, playerInventory, (CableTile)inv);
        }
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TILE);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CableTile(this.maxReceive, this.maxExtract, this.isCreative);
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        VoxelShape voxelshape = CABLE;
        voxelshape.func_197755_b((p_199284_3_, p_199284_5_, p_199284_7_, p_199284_9_, p_199284_11_, p_199284_13_) -> {
            double d1 = Math.min(1.0, p_199284_9_ - p_199284_3_);
            double d2 = Math.min(1.0, p_199284_11_ - p_199284_5_);
            double d3 = Math.min(1.0, p_199284_13_ - p_199284_7_);
            int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
            int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
            int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + p_199284_3_;
                        double d8 = d5 * d2 + p_199284_5_;
                        double d9 = d6 * d3 + p_199284_7_;
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new DiggingParticle(world, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                    }
                }
            }
        });
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.newState(world, currentPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.newState((IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState newState(IWorld world, BlockPos pos) {
        BlockState state = this.func_176223_P();
        boolean[] north = this.canAttach(state, world, pos, Direction.NORTH);
        boolean[] south = this.canAttach(state, world, pos, Direction.SOUTH);
        boolean[] west = this.canAttach(state, world, pos, Direction.WEST);
        boolean[] east = this.canAttach(state, world, pos, Direction.EAST);
        boolean[] up = this.canAttach(state, world, pos, Direction.UP);
        boolean[] down = this.canAttach(state, world, pos, Direction.DOWN);
        boolean tile = false;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (north[1] || south[1] || west[1] || east[1] || up[1] || down[1]) {
            tile = true;
        } else if (tileEntity instanceof CableTile) {
            CableTile cable = (CableTile)tileEntity;
            cable.getInventory().drop((World)world, pos);
            if (world instanceof ServerWorld) {
                CableNoneTileData data = (CableNoneTileData)Server.getData(CableNoneTileData::new, (Dimension)((ServerWorld)world).field_73011_w);
                data.add(pos, cable.getSideConfig().write(new CompoundNBT()));
                ((ServerWorld)world).func_175726_f(pos).func_76630_e();
            }
            tileEntity.func_145843_s();
        }
        IFluidState ifluidstate = world.func_204610_c(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north[0] && !north[1]))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south[0] && !south[1]))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(west[0] && !west[1]))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(east[0] && !east[1]))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(up[0] && !up[1]))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down[0] && !down[1]))).func_206870_a((IProperty)TILE, (Comparable)Boolean.valueOf(tile))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CableTile) {
            CableTile cable = (CableTile)tileEntity;
            for (Direction direction : Direction.values()) {
                if (!cable.canExtract(direction)) continue;
                cable.search((Block)this, direction);
            }
        } else {
            this.searchCables((IWorld)worldIn, pos, pos);
        }
    }

    @Override
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CableTile) {
            CableNoneTileData data;
            CompoundNBT nbt;
            CableTile cable = (CableTile)tileEntity;
            cable.energySides.clear();
            for (Direction direction : Direction.values()) {
                if (!this.canAttach(state, (IWorld)world, pos, direction)[1]) continue;
                cable.energySides.add(direction);
            }
            if (world instanceof ServerWorld && cable.ticks == 0 && (nbt = (data = (CableNoneTileData)Server.getData(CableNoneTileData::new, (Dimension)((ServerWorld)world).field_73011_w)).get(pos)) != null) {
                cable.getSideConfig().read(nbt);
            }
            cable.sync(1);
        }
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public boolean[] canAttach(BlockState state, IWorld world, BlockPos pos, Direction direction) {
        return new boolean[]{world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() == this || this.checkEnergyTile(world, pos, direction), this.checkEnergyTile(world, pos, direction)};
    }

    public boolean checkEnergyTile(IWorld world, BlockPos pos, Direction direction) {
        return this.canConnectEnergy((IBlockReader)world, pos, direction);
    }

    public boolean canConnectEnergy(IBlockReader world, BlockPos pos, Direction direction) {
        BlockPos pos1 = pos.func_177972_a(direction);
        TileEntity tileEntity = world.func_175625_s(pos1);
        return !(tileEntity instanceof CableTile) && Energy.isPresent((TileEntity)tileEntity, (Direction)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, TILE});
        super.func_206840_a(builder);
    }

    public void searchCables(IWorld world, BlockPos pos, CableTile first, Direction side) {
        if (!first.linkedCables.get((Object)side).searchCach.contains(pos)) {
            for (Direction direction : Direction.values()) {
                BlockPos blockPos = pos.func_177972_a(direction);
                BlockState state = world.func_180495_p(blockPos);
                if (state.func_177230_c() != this) continue;
                TileEntity tileEntity = world.func_175625_s(blockPos);
                if (tileEntity instanceof CableTile) {
                    CableTile cable = (CableTile)tileEntity;
                    first.linkedCables.get(side).add(blockPos);
                }
                CableBlock cableBlock = (CableBlock)state.func_177230_c();
                first.linkedCables.get((Object)side).searchCach.add(pos);
                cableBlock.searchCables(world, blockPos, first, side);
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
        if (Energy.isPresent((TileEntity)world.func_175625_s(fromPos), (Direction)Side.fromNeighbor((BlockPos)pos, (BlockPos)fromPos))) {
            this.searchCables((IWorld)world, pos, pos);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CableTile) {
                CableTile cable = (CableTile)tileEntity;
                cable.energySides.clear();
                for (Direction direction : Direction.values()) {
                    if (!this.canAttach(state, (IWorld)world, pos, direction)[1]) continue;
                    cable.energySides.add(direction);
                }
                cable.markDirtyAndSync();
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.searchCables((IWorld)worldIn, pos, pos);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void searchCables(IWorld world, BlockPos poss, BlockPos pos) {
        Set<BlockPos> ss = CACHE.get(poss);
        if (ss == null) {
            ss = new HashSet<BlockPos>();
        }
        if (!ss.contains(pos)) {
            for (Direction direction : Direction.values()) {
                BlockPos blockPos = pos.func_177972_a(direction);
                BlockState state = world.func_180495_p(blockPos);
                if (state.func_177230_c() != this) continue;
                TileEntity tileEntity = world.func_175625_s(blockPos);
                if (tileEntity instanceof CableTile) {
                    CableTile cable = (CableTile)tileEntity;
                    for (Direction side : Direction.values()) {
                        cable.linkedCables.get(side).cables().clear();
                        cable.search((Block)this, side);
                    }
                }
                CableBlock cableBlock = (CableBlock)state.func_177230_c();
                ss.add(pos);
                CACHE.put(poss, ss);
                cableBlock.searchCables(world, poss, blockPos);
            }
        }
        CACHE.clear();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CableTile) {
            CableTile cable = (CableTile)tileEntity;
            if (stack.func_77973_b() instanceof WrenchItem) {
                Vec3d hit = blockRayTraceResult.func_216347_e();
                Optional<Direction> sides = this.getHitSide(hit, pos);
                boolean[] flag = new boolean[]{false};
                sides.ifPresent(direction -> {
                    if (this.checkEnergyTile((IWorld)world, pos, (Direction)direction)) {
                        cable.getSideConfig().nextPowerMode((Direction)direction);
                        flag[0] = true;
                    }
                });
                if (!world.field_72995_K && flag[0]) {
                    cable.markDirtyAndSync();
                    return true;
                }
            }
        }
        return super.func_220051_a(state, world, pos, player, hand, blockRayTraceResult);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(BlockState state, World world, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(result.func_216350_a());
        boolean[] flag = new boolean[]{false};
        if (tileEntity instanceof CableTile) {
            CableTile cable = (CableTile)tileEntity;
            if (stack.func_77973_b() instanceof WrenchItem) {
                Vec3d hit = result.func_216347_e();
                Optional<Direction> sides = this.getHitSide(hit, result.func_216350_a());
                sides.ifPresent(direction -> {
                    if (this.checkEnergyTile((IWorld)world, result.func_216350_a(), (Direction)direction)) {
                        Minecraft mc = Minecraft.func_71410_x();
                        FontRenderer font = mc.field_71466_p;
                        int width = mc.field_195558_d.func_198107_o();
                        int height = mc.field_195558_d.func_198087_p();
                        String s = I18n.func_135052_a((String)("info.lollipop.side." + direction.func_176610_l()), (Object[])new Object[]{TextFormatting.WHITE});
                        int sw = font.func_78256_a(s);
                        font.func_175063_a(s, (float)(-(sw / 2) + width / 2), (float)(height - 84), 0xBFBFBF);
                        PowerMode mode = cable.getSideConfig().getPowerMode((Direction)direction);
                        TextFormatting tf = mode.equals((Object)PowerMode.ALL) ? TextFormatting.GRAY : (mode.equals((Object)PowerMode.IN) ? TextFormatting.DARK_AQUA : (mode.equals((Object)PowerMode.OUT) ? TextFormatting.GOLD : TextFormatting.YELLOW));
                        String sideConf = I18n.func_135052_a((String)("info.powah.mode.cable." + mode.name().toLowerCase()), (Object[])new Object[]{TextFormatting.YELLOW});
                        int sc = font.func_78256_a(sideConf);
                        font.func_175063_a(sideConf, (float)(-(sc / 2) + width / 2), (float)(height - 98), 0xBFBFBF);
                        flag[0] = true;
                    }
                });
            }
        }
        return flag[0];
    }

    public Optional<Direction> getHitSide(Vec3d hit, BlockPos pos) {
        double x = hit.field_72450_a - (double)pos.func_177958_n();
        double y = hit.field_72448_b - (double)pos.func_177956_o();
        double z = hit.field_72449_c - (double)pos.func_177952_p();
        if (x > 0.0 && x < 0.4) {
            return Optional.of(Direction.WEST);
        }
        if (x > 0.6 && x < 1.0) {
            return Optional.of(Direction.EAST);
        }
        if (z > 0.0 && z < 0.4) {
            return Optional.of(Direction.NORTH);
        }
        if (z > 0.6 && z < 1.0) {
            return Optional.of(Direction.SOUTH);
        }
        if (y > 0.6 && y < 1.0) {
            return Optional.of(Direction.UP);
        }
        if (y > 0.0 && y < 0.4) {
            return Optional.of(Direction.DOWN);
        }
        return Optional.empty();
    }
}

