/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import owmii.lib.util.Energy;
import owmii.powah.block.ITiles;
import owmii.powah.block.PowahTile;
import owmii.powah.block.cable.LinkedCables;

public class CableTile
extends PowahTile {
    public final Map<Direction, LinkedCables> linkedCables = new HashMap<Direction, LinkedCables>();
    public final Set<Direction> energySides = new HashSet<Direction>();
    public boolean[] flags = new boolean[6];

    public CableTile(int maxReceive, int maxExtract, boolean isCreative) {
        super(ITiles.CABLE, 0, maxReceive, maxExtract, isCreative);
        for (Direction side : Direction.values()) {
            this.linkedCables.put(side, LinkedCables.create());
        }
    }

    public CableTile() {
        this(0, 0, false);
    }

    @Override
    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        ListNBT list = compound.func_150295_c("LinkedCables", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt = list.func_150305_b(i);
            Direction direction = Direction.values()[nbt.func_74762_e("Direction")];
            this.linkedCables.put(direction, LinkedCables.create().read(nbt));
        }
        ListNBT list1 = compound.func_150295_c("EnergyDirections", 10);
        for (int i = 0; i < list1.size(); ++i) {
            CompoundNBT nbt = list1.func_150305_b(i);
            Direction direction = Direction.values()[nbt.func_74762_e("EnergyDirection")];
            this.energySides.add(direction);
        }
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        this.linkedCables.forEach((direction, linkedCables) -> {
            CompoundNBT nbt = new CompoundNBT();
            linkedCables.write(nbt);
            nbt.func_74768_a("Direction", direction.ordinal());
            list.add((Object)nbt);
        });
        compound.func_218657_a("LinkedCables", (INBT)list);
        ListNBT list1 = new ListNBT();
        this.energySides.forEach(direction -> {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("EnergyDirection", direction.ordinal());
            list1.add((Object)nbt);
        });
        compound.func_218657_a("EnergyDirections", (INBT)list1);
        return super.writeSync(compound);
    }

    public boolean isNBTStorable() {
        return false;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, @Nullable Direction direction) {
        if (this.field_145850_b == null || direction == null || !this.canReceive(direction)) {
            return 0;
        }
        int received = 0;
        for (Direction side : this.energySides) {
            BlockPos pos1;
            TileEntity tile;
            int amount = maxReceive - received;
            if (amount <= 0) continue;
            int net = Math.min(amount, this.internal.getMaxExtract());
            amount -= net;
            if (!this.canExtract(side) || !Energy.canReceive((TileEntity)(tile = this.field_145850_b.func_175625_s(pos1 = this.field_174879_c.func_177972_a(side))), (Direction)side) || tile instanceof CableTile || maxReceive - (received += Energy.receive((TileEntity)tile, (Direction)side, (int)net, (boolean)simulate)) > 0) continue;
            return received;
        }
        LinkedCables cables = this.linkedCables.get(direction);
        for (BlockPos cablePos : cables.cables()) {
            TileEntity cableTile;
            if (cablePos.equals((Object)this.func_174877_v()) || !((cableTile = this.field_145850_b.func_175625_s(cablePos)) instanceof CableTile) || cableTile == this) continue;
            CableTile cable = (CableTile)cableTile;
            for (Direction side : cable.energySides) {
                BlockPos pos1;
                TileEntity tile;
                int amount = maxReceive - received;
                if (amount <= 0) continue;
                int net = Math.min(amount, this.internal.getMaxExtract());
                amount -= net;
                if (!cable.canExtract(side) || !Energy.canReceive((TileEntity)(tile = this.field_145850_b.func_175625_s(pos1 = cablePos.func_177972_a(side))), (Direction)side) || tile instanceof CableTile || pos1.equals((Object)this.field_174879_c.func_177972_a(direction.func_176734_d())) || maxReceive - (received += Energy.receive((TileEntity)tile, (Direction)side, (int)net, (boolean)simulate)) > 0) continue;
                return received;
            }
        }
        return received;
    }

    public void search(Block block, Direction side) {
        this.linkedCables.get(side).search(block, this, side).clear();
    }
}

