/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.discharger;

import net.minecraft.item.ItemStack;
import owmii.lib.util.Energy;
import owmii.powah.block.ITiles;
import owmii.powah.block.PowahTile;

public class DischargerTile
extends PowahTile {
    public DischargerTile(int capacity, int maxExtract) {
        super(ITiles.DISCHARGER, capacity, 0, maxExtract, false);
        this.inv.add(4);
    }

    public DischargerTile() {
        this(0, 0);
    }

    @Override
    protected boolean postTicks() {
        super.postTicks();
        int[] extracted = new int[]{0};
        for (int i = this.builtInSlots(); i < 4 + this.builtInSlots(); ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            int amount = Math.min(this.internal.getMaxExtract(), Energy.getStored((ItemStack)stack));
            int received = Math.min(this.internal.getMaxEnergyStored() - this.internal.getEnergyStored(), amount);
            int j = Energy.extract((ItemStack)stack, (int)received, (boolean)false);
            this.internal.setEnergy(this.internal.getEnergyStored() + j);
            extracted[0] = extracted[0] + j;
        }
        return extracted[0] > 0;
    }

    @Override
    public int getSlotLimit(int index) {
        return super.getSlotLimit(index);
    }

    @Override
    protected PowahTile.ExtractionType getExtractionType() {
        return PowahTile.ExtractionType.TILE;
    }

    @Override
    public boolean canInsert(int index, ItemStack stack) {
        boolean[] b = new boolean[]{false};
        Energy.getForgeEnergy((ItemStack)stack).ifPresent(storage -> {
            if (storage.canExtract()) {
                b[0] = storage.getEnergyStored() > 0;
            }
        });
        return b[0];
    }
}

