/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.endercell;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.item.BlockItemBase;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.endercell.EnderCellTile;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.inventory.IContainers;
import owmii.powah.item.EnderCellItem;

public class EnderCellBlock
extends PowahBlock
implements IWaterLoggable {
    protected int channels;

    public EnderCellBlock(Block.Properties properties, int maxExtract, int maxReceive, int channels) {
        super(properties, 0, maxExtract, maxReceive);
        this.channels = channels;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new EnderCellItem(this, properties, group);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderCellTile(this.maxReceive, this.maxExtract, this.channels);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        EnderCellTile tile;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof EnderCellTile && (tile = (EnderCellTile)tileentity).getOwner() == null && placer instanceof ServerPlayerEntity) {
            tile.setOwner(((ServerPlayerEntity)placer).func_146103_bH());
        }
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof EnderCellTile) {
            return new EnderCellContainer(IContainers.ENDER_CELL, id, playerInventory, (EnderCellTile)inv);
        }
        return null;
    }

    protected void postTooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.remove(new StringTextComponent(""));
        tooltip.add(new TranslationTextComponent("info.powah.max.channels", new Object[]{"" + TextFormatting.DARK_GRAY + this.channels}).func_211708_a(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(""));
        CompoundNBT tag = stack.func_77978_p() != null ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT stackTag = tag.func_74775_l("lollipop_Storable_NBT");
        int activeChannel = stackTag.func_74762_e("ActiveChannel");
        String owner = stackTag.func_74779_i("OwnerName");
        if (!owner.isEmpty()) {
            tooltip.add(new TranslationTextComponent("info.powah.owner", new Object[]{TextFormatting.DARK_GRAY + owner}).func_211708_a(TextFormatting.GRAY));
            tooltip.add(new TranslationTextComponent("info.powah.channel", new Object[]{"" + TextFormatting.DARK_AQUA + (activeChannel + 1)}).func_211708_a(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
    }

    @Override
    public int stackSize() {
        return 64;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }
}

