/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.endercell;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import owmii.lib.util.Server;
import owmii.powah.block.ITiles;
import owmii.powah.block.PowahTile;
import owmii.powah.block.endercell.EnderCellBlock;
import owmii.powah.block.endercell.EnderNetwork;
import owmii.powah.energy.PowahStorage;

public class EnderCellTile
extends PowahTile {
    protected int channels;
    protected int activeChannel;
    protected boolean flag;
    @Nullable
    private GameProfile owner;

    public EnderCellTile(TileEntityType<?> enderCell, int maxReceive, int maxExtract, int channels) {
        super(enderCell, 0, maxReceive, maxExtract, false);
        this.channels = channels;
    }

    public EnderCellTile(int maxReceive, int maxExtract, int channels) {
        this(ITiles.ENDER_CELL, maxReceive, maxExtract, channels);
    }

    public EnderCellTile() {
        this(0, 0, 0);
    }

    @Override
    public void readStorable(CompoundNBT compound) {
        this.channels = compound.func_74762_e("TotalChannels");
        if (compound.func_186855_b("OwnerId")) {
            this.owner = new GameProfile(compound.func_186857_a("OwnerId"), compound.func_74779_i("OwnerName"));
            this.activeChannel = compound.func_74762_e("ActiveChannel");
        }
    }

    @Override
    public CompoundNBT writeStorable(CompoundNBT compound) {
        compound.func_74768_a("TotalChannels", this.channels);
        if (this.owner != null) {
            compound.func_186854_a("OwnerId", this.owner.getId());
            compound.func_74778_a("OwnerName", this.owner.getName());
            compound.func_74768_a("ActiveChannel", this.activeChannel);
        }
        return compound;
    }

    @Override
    public void readSync(CompoundNBT compound) {
        this.internal.read(compound);
        super.readSync(compound);
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT compound) {
        this.internal.write(compound);
        return super.writeSync(compound);
    }

    @Override
    public boolean keepInventory() {
        return false;
    }

    @Override
    protected void firstTick() {
        EnderCellBlock cell;
        super.firstTick();
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getBlock() instanceof EnderCellBlock && this.channels != (cell = (EnderCellBlock)this.getBlock()).getChannels()) {
            this.channels = cell.getChannels();
            this.markDirtyAndSync();
        }
    }

    @Override
    protected boolean postTicks() {
        if (this.isServerWorld()) {
            int prevCap = this.internal.getMaxEnergyStored();
            int prevStored = this.internal.getEnergyStored();
            this.internal.setCapacity(this.getCapacity());
            this.internal.setEnergy(this.getEnergyStored());
            if (this.flag && (prevCap != this.internal.getMaxEnergyStored() || prevStored != this.internal.getEnergyStored())) {
                this.markDirtyAndSync();
                this.flag = false;
            }
        }
        return super.postTicks() || this.isContainerOpen || this.ticks % 100 == 0;
    }

    @Override
    public void setEnergy(int amount, @Nullable Direction side) {
        PowahStorage storage = this.getInternal();
        storage.setEnergy(amount);
        this.setInternal(storage);
    }

    public void setCapacity(int cap) {
        PowahStorage storage = this.getInternal();
        storage.setCapacity(cap);
        this.setInternal(storage);
    }

    @Override
    public int getEnergyStored() {
        return this.getInternal().getEnergyStored();
    }

    @Override
    public int getCapacity() {
        return this.getInternal().getMaxEnergyStored();
    }

    @Override
    public PowahStorage getInternal() {
        if (this.isServerWorld()) {
            EnderNetwork network = (EnderNetwork)Server.getData(EnderNetwork::new);
            if (this.getOwner() != null) {
                return network.getStorage(this.getOwner().getId(), this.activeChannel);
            }
        }
        return new PowahStorage(0);
    }

    public void setInternal(PowahStorage storage) {
        if (this.getOwner() != null && this.isServerWorld()) {
            EnderNetwork network = (EnderNetwork)Server.getData(EnderNetwork::new);
            network.setStorage(this.getOwner().getId(), this.activeChannel, storage);
        }
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public int getActiveChannel() {
        return this.activeChannel;
    }

    public void setActiveChannel(int activeChannel) {
        this.activeChannel = Math.min(15, Math.max(0, activeChannel));
        this.flag = true;
    }

    public boolean isExtender() {
        return true;
    }
}

