/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.endergate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import owmii.lib.block.BlockBase;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.util.Energy;
import owmii.powah.api.cable.ICable;
import owmii.powah.block.endercell.EnderCellBlock;
import owmii.powah.block.endergate.EnderGateTile;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.inventory.IContainers;

public class EnderGateBlock
extends EnderCellBlock
implements IWaterLoggable {
    private static final Map<Direction, VoxelShape> VOXEL_SHAPES = new HashMap<Direction, VoxelShape>();

    public EnderGateBlock(Block.Properties properties, int capacity, int maxExtract, int maxReceive) {
        super(properties, capacity, maxExtract, maxReceive);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderGateTile(this.maxReceive, this.maxExtract, this.channels);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState state1 = worldIn.func_180495_p(blockpos);
        TileEntity tile = worldIn.func_175625_s(blockpos);
        return state1.func_177230_c() instanceof ICable || tile != null && Energy.getForgeEnergy((TileEntity)tile, (Direction)direction).isPresent();
    }

    @Override
    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof EnderGateTile) {
            return new EnderCellContainer(IContainers.ENDER_CELL, id, playerInventory, (EnderGateTile)inv);
        }
        return null;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    protected BlockBase.FacingType getFacingType() {
        return BlockBase.FacingType.ALL;
    }

    static {
        VOXEL_SHAPES.put(Direction.UP, EnderGateBlock.func_208617_a((double)6.0, (double)15.5, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        VOXEL_SHAPES.put(Direction.DOWN, EnderGateBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)0.5, (double)10.0));
        VOXEL_SHAPES.put(Direction.NORTH, EnderGateBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)0.5));
        VOXEL_SHAPES.put(Direction.SOUTH, EnderGateBlock.func_208617_a((double)6.0, (double)6.0, (double)15.5, (double)10.0, (double)10.0, (double)16.0));
        VOXEL_SHAPES.put(Direction.EAST, EnderGateBlock.func_208617_a((double)15.5, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        VOXEL_SHAPES.put(Direction.WEST, EnderGateBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)0.5, (double)10.0, (double)10.0));
    }
}

