/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import owmii.lib.block.TileBase;
import owmii.lib.client.particle.Effect;
import owmii.lib.client.particle.Effects;
import owmii.lib.util.math.V3d;
import owmii.powah.api.recipe.energizing.EnergizingRecipeSorter;
import owmii.powah.api.recipe.energizing.IEnergizingRecipe;
import owmii.powah.block.ITiles;

public class EnergizingOrbTile
extends TileBase.Tickable {
    private boolean containRecipe;
    private int requiredEnergy;
    private int energy;
    @Nullable
    private IEnergizingRecipe recipe;

    public EnergizingOrbTile() {
        super(ITiles.ENERGIZING_ORB);
        this.inv.set(7);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.containRecipe = compound.func_74767_n("ContainRecipe");
        this.requiredEnergy = compound.func_74762_e("RequiredEnergy");
        this.energy = compound.func_74762_e("Energy");
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a("ContainRecipe", this.containRecipe);
        compound.func_74768_a("RequiredEnergy", this.requiredEnergy);
        compound.func_74768_a("Energy", this.energy);
        return super.writeSync(compound);
    }

    @Nullable
    public IEnergizingRecipe currRecipe() {
        return this.recipe;
    }

    protected void firstTick() {
        super.firstTick();
        this.checkRecipe();
    }

    public void onSlotChanged(int index) {
        if (this.isServerWorld()) {
            this.energy = 0;
            this.checkRecipe();
        }
    }

    private void checkRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.recipe = EnergizingRecipeSorter.get((ItemStackHandler)this.inv, this.field_145850_b, this.field_174879_c);
            this.requiredEnergy = this.recipe != null ? this.recipe.getEnergy() : 0;
            this.setContainRecipe(this.recipe != null);
        }
        this.sync(1);
    }

    public int fillEnergy(int amount) {
        int filled = Math.min(this.requiredEnergy - this.energy, amount);
        if (this.field_145850_b != null) {
            if (this.recipe != null) {
                this.energy += filled;
                if (this.energy >= this.requiredEnergy) {
                    ItemStack stack = this.recipe.getOutput();
                    this.inv.clear();
                    this.inv.setStack(0, stack.func_77946_l());
                    this.requiredEnergy = 0;
                    this.energy = 0;
                    this.func_70296_d();
                }
            }
            if (this.containRecipe && this.field_145850_b.field_72995_K && Math.random() < 0.2) {
                Effects.create((Effect.Texture)Effect.GLOW_SMALL, (World)this.field_145850_b, (V3d)new V3d((Vec3i)this.field_174879_c).east(0.5 + Math.random() * 0.3 - Math.random() * 0.3).south(0.5 + Math.random() * 0.3 - Math.random() * 0.3).up(0.5 + Math.random() * 0.3 - Math.random() * 0.3)).scale(0.0f, 3, 0.0f).alpha(0.7f, 2).color(11304893).maxAge(20).blend().spawn();
            }
        }
        return filled;
    }

    public boolean containRecipe() {
        return this.containRecipe;
    }

    public void setContainRecipe(boolean containRecipe) {
        this.containRecipe = containRecipe;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return slot == 0;
    }

    public boolean canInsert(int index, ItemStack stack) {
        return index != 0 && this.inv.getStackInSlot(0).func_190926_b() && this.inv.getStackInSlot(index).func_190926_b();
    }
}

