/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import owmii.lib.block.BlockBase;
import owmii.lib.util.math.V3d;
import owmii.powah.api.wrench.IWrench;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.IBlocks;
import owmii.powah.block.PowahBlock;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.config.Config;

public class EnergizingRodBlock
extends PowahBlock
implements IWaterLoggable,
IWrenchable {
    private static final Map<Direction, VoxelShape> VOXEL_SHAPES = new HashMap<Direction, VoxelShape>();
    private int energizingSpeed;

    public EnergizingRodBlock(Block.Properties properties, int capacity, int maxReceive, int energizingSpeed) {
        super(properties, capacity, 0, maxReceive);
        this.energizingSpeed = energizingSpeed;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.DOWN)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOXEL_SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof EnergizingRodTile) {
            this.setOrbPos(worldIn, pos, (EnergizingRodTile)tileEntity);
        }
    }

    public void setOrbPos(World worldIn, BlockPos pos, EnergizingRodTile tile) {
        int range = (Integer)Config.ENERGIZING_CONFIG.range.get();
        List list = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos pos1 : list) {
            TileEntity tileEntity1;
            if (pos1.equals((Object)BlockPos.field_177992_a) || !((tileEntity1 = worldIn.func_175625_s(pos1)) instanceof EnergizingOrbTile)) continue;
            tile.setOrbPos(pos1);
            break;
        }
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnergizingRodTile(this.capacity, this.maxReceive);
    }

    protected void postTooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("info.powah.energizing.speed", new Object[]{"" + TextFormatting.DARK_GRAY + this.energizingSpeed}).func_211708_a(TextFormatting.GRAY));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return IBlocks.PLAYER_TRANSMITTER.func_196260_a(state, worldIn, pos);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return IBlocks.PLAYER_TRANSMITTER.rotate(state, world, pos, direction);
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    protected BlockBase.FacingType getFacingType() {
        return BlockBase.FacingType.ALL;
    }

    public int getEnergizingSpeed() {
        return this.energizingSpeed;
    }

    public void setEnergizingSpeed(int energizingSpeed) {
        this.energizingSpeed = energizingSpeed;
    }

    @Override
    public boolean onWrench(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, WrenchMode mode, Vec3d hit) {
        ItemStack stack;
        if (mode.link() && (stack = player.func_184586_b(hand)).func_77973_b() instanceof IWrench) {
            IWrench wrench = (IWrench)stack.func_77973_b();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof EnergizingRodTile) {
                EnergizingRodTile rod = (EnergizingRodTile)tileEntity;
                CompoundNBT nbt = wrench.getWrenchNBT(stack);
                if (nbt.func_150297_b("OrbPos", 10)) {
                    BlockPos orbPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("OrbPos"));
                    TileEntity tileEntity1 = world.func_175625_s(orbPos);
                    if (tileEntity1 instanceof EnergizingOrbTile) {
                        EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity1;
                        V3d v3d = V3d.from((Vec3i)orbPos);
                        if ((int)v3d.distance((Vec3i)pos) <= (Integer)Config.ENERGIZING_CONFIG.range.get()) {
                            rod.setOrbPos(orbPos);
                            player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.done", new Object[0]).func_211708_a(TextFormatting.GOLD), true);
                        } else {
                            player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.fail", new Object[0]).func_211708_a(TextFormatting.RED), true);
                        }
                    }
                    nbt.func_82580_o("OrbPos");
                } else {
                    nbt.func_218657_a("RodPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                    player.func_146105_b(new TranslationTextComponent("chat.powah.wrench.link.start", new Object[0]).func_211708_a(TextFormatting.YELLOW), true);
                }
                return true;
            }
        }
        return false;
    }

    static {
        VOXEL_SHAPES.put(Direction.UP, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)9.0, (double)7.25, (double)8.75, (double)13.0, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.DOWN, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)3.0, (double)7.25, (double)8.75, (double)7.0, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.NORTH, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)7.25, (double)3.0, (double)8.75, (double)8.75, (double)7.0), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.SOUTH, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)13.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)7.25, (double)7.25, (double)13.0, (double)8.75, (double)8.75, (double)9.0), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.WEST, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)3.0, (double)7.25, (double)7.25, (double)7.0, (double)8.75, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
        VOXEL_SHAPES.put(Direction.EAST, VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0), (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)EnergizingRodBlock.func_208617_a((double)13.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), (VoxelShape)EnergizingRodBlock.func_208617_a((double)13.0, (double)7.25, (double)7.25, (double)9.0, (double)8.75, (double)8.75), (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_));
    }
}

