/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import owmii.lib.block.BlockBase;
import owmii.lib.util.Ticker;
import owmii.powah.block.ITiles;
import owmii.powah.block.PowahTile;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodBlock;
import owmii.powah.config.Config;

public class EnergizingRodTile
extends PowahTile {
    private BlockPos orbPos = BlockPos.field_177992_a;
    public int energizingSpeed;
    public final Ticker coolDown = new Ticker(15.0);

    public EnergizingRodTile(int capacity, int maxReceive) {
        super(ITiles.ENERGIZING_ROD, capacity, maxReceive, 0, false);
    }

    public EnergizingRodTile() {
        this(0, 0);
    }

    @Override
    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.energizingSpeed = compound.func_74762_e("EnergizingSpeed");
        this.orbPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("OrbPos"));
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74768_a("EnergizingSpeed", this.energizingSpeed);
        compound.func_218657_a("OrbPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.orbPos));
        return super.writeSync(compound);
    }

    @Override
    protected void firstTick() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getBlock() instanceof EnergizingRodBlock) {
            EnergizingRodBlock rodBlock = (EnergizingRodBlock)this.getBlock();
            this.energizingSpeed = rodBlock.getEnergizingSpeed();
        }
        super.firstTick();
    }

    @Override
    protected boolean postTicks() {
        TileEntity tileEntity;
        if (this.field_145850_b == null) {
            return false;
        }
        boolean flag = false;
        if (!this.orbPos.equals((Object)BlockPos.field_177992_a) && (tileEntity = this.field_145850_b.func_175625_s(this.orbPos)) instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileEntity;
            if (orb.containRecipe() && this.internal.hasEnergy()) {
                this.coolDown.onward();
                flag = true;
            } else if (this.coolDown.getTicks() > 0.0) {
                this.coolDown.back();
                flag = true;
            }
            if (orb.containRecipe() && this.coolDown.ended()) {
                int fill = Math.min(this.internal.getEnergyStored(), this.energizingSpeed);
                orb.fillEnergy(fill);
                this.internal.consume(fill);
                flag = true;
            }
        }
        return super.postTicks() || flag;
    }

    public boolean hasOrb() {
        if (this.field_145850_b == null) {
            return false;
        }
        return this.orbPos != BlockPos.field_177992_a && this.field_145850_b.func_175625_s(this.orbPos) instanceof EnergizingOrbTile;
    }

    public BlockPos getOrbPos() {
        return this.orbPos;
    }

    public void setOrbPos(BlockPos orbPos) {
        this.orbPos = orbPos;
        this.sync(2);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int range = (Integer)Config.ENERGIZING_CONFIG.range.get();
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)range);
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != null && side.equals((Object)this.func_195044_w().func_177229_b((IProperty)BlockBase.FACING));
    }
}

