/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import owmii.powah.block.PowahTile;
import owmii.powah.block.generator.GeneratorBlock;

public abstract class GeneratorTile
extends PowahTile {
    public int perTick;
    public int nextGenCap;
    public int nextGen;

    public GeneratorTile(TileEntityType<?> type, int capacity, int transfer, int perTick) {
        super(type, capacity, 0, transfer, false);
        this.perTick = perTick;
    }

    @Override
    public void readStorable(CompoundNBT compound) {
        super.readStorable(compound);
        this.perTick = compound.func_74762_e("PerTick");
    }

    @Override
    public CompoundNBT writeStorable(CompoundNBT compound) {
        compound.func_74768_a("PerTick", this.perTick);
        return super.writeStorable(compound);
    }

    @Override
    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.nextGenCap = compound.func_74762_e("NextGenCap");
        this.nextGen = compound.func_74762_e("NextGen");
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74768_a("NextGenCap", this.nextGenCap);
        compound.func_74768_a("NextGen", this.nextGen);
        return super.writeSync(compound);
    }

    @Override
    protected void firstTick() {
        super.firstTick();
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getBlock() instanceof GeneratorBlock) {
            GeneratorBlock generatorBlock = (GeneratorBlock)this.getBlock();
            this.perTick = generatorBlock.perTick;
            this.sync(this.getSyncTicks());
        }
    }

    @Override
    protected boolean postTicks() {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        boolean flag = this.isGenerating();
        boolean flag1 = super.postTicks();
        if (this.perTick() > 0) {
            int toGenerate = Math.min(this.perTick(), this.internal.getDif());
            if (this.nextGen > toGenerate) {
                this.nextGen -= toGenerate;
                if (this.nextGen <= 0) {
                    this.nextGenCap = 0;
                }
            } else {
                toGenerate = this.nextGen;
                this.nextGen = 0;
                this.nextGenCap = 0;
            }
            this.generate();
            if (toGenerate > 0) {
                int stored = this.internal.getEnergyStored();
                this.internal.setEnergy(stored + toGenerate);
                flag1 = true;
            }
        }
        if (flag != this.isGenerating() && this.getBlock() instanceof GeneratorBlock && ((GeneratorBlock)this.getBlock()).hasLitProp()) {
            flag1 = true;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)GeneratorBlock.LIT, (Comparable)Boolean.valueOf(this.isGenerating())), 3);
        }
        return flag1;
    }

    @Override
    public int getChargingSlots() {
        return 1;
    }

    protected abstract void generate();

    protected boolean isGenerating() {
        return this.nextGen > 0;
    }

    public int perTick() {
        return this.perTick;
    }
}

