/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.magmatic;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.BlockBase;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.powah.block.generator.GeneratorBlock;
import owmii.powah.block.generator.magmatic.MagmaticGenTile;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.MagmaticGenContainer;

public class MagmaticGenBlock
extends GeneratorBlock
implements IWaterLoggable {
    public static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)MagmaticGenBlock.func_208617_a((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)MagmaticGenBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    private int buckets;

    public MagmaticGenBlock(Block.Properties properties, int capacity, int transfer, int perTick, int buckets) {
        super(properties, capacity, transfer, perTick);
        this.buckets = buckets;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)H_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof MagmaticGenTile) {
            MagmaticGenTile genTile = (MagmaticGenTile)tile;
            boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)genTile.tank);
            if (result) {
                genTile.markDirtyAndSync();
                return true;
            }
        }
        return super.func_220051_a(state, world, pos, player, hand, blockRayTraceResult);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MagmaticGenTile(this.capacity, this.maxExtract, this.perTick, this.buckets);
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof MagmaticGenTile) {
            return new MagmaticGenContainer(IContainers.MAGMATIC_GENERATOR, id, playerInventory, (MagmaticGenTile)inv);
        }
        return null;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public int getBuckets() {
        return this.buckets;
    }

    public void setBuckets(int buckets) {
        this.buckets = buckets;
    }

    protected BlockBase.FacingType getFacingType() {
        return BlockBase.FacingType.HORIZONTAL;
    }
}

