/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.magmatic;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.ITiles;
import owmii.powah.block.generator.GeneratorTile;
import owmii.powah.block.generator.magmatic.MagmaticGenBlock;

public class MagmaticGenTile
extends GeneratorTile {
    protected final FluidTank tank;
    private final LazyOptional<IFluidHandler> holder;

    public MagmaticGenTile(int capacity, int transfer, int perTick, int bucketCount) {
        super(ITiles.MAGMATIC_GENERATOR, capacity, transfer, perTick);
        this.tank = new FluidTank(1000 * bucketCount){

            public boolean isFluidValid(FluidStack stack) {
                return PowahAPI.MAGMATIC_FLUIDS.containsKey(stack.getFluid()) && super.isFluidValid(stack);
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                MagmaticGenTile.this.sync(5);
            }
        };
        this.holder = LazyOptional.of(() -> this.tank);
    }

    public MagmaticGenTile() {
        this(0, 0, 0, 0);
    }

    @Override
    public void readStorable(CompoundNBT compound) {
        this.tank.readFromNBT(compound);
        this.tank.setCapacity(compound.func_74762_e("TankCap"));
        super.readStorable(compound);
    }

    @Override
    public CompoundNBT writeStorable(CompoundNBT compound) {
        this.tank.writeToNBT(compound);
        compound.func_74768_a("TankCap", this.tank.getCapacity());
        return super.writeStorable(compound);
    }

    @Override
    protected void firstTick() {
        super.firstTick();
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getBlock() instanceof MagmaticGenBlock) {
            MagmaticGenBlock magmaticGen = (MagmaticGenBlock)this.getBlock();
            this.tank.setCapacity(1000 * magmaticGen.getBuckets());
            this.sync(this.getSyncTicks());
        }
    }

    @Override
    public void generate() {
        int fluidHeat;
        FluidStack fluid;
        if (this.nextGen <= 0 && !this.tank.isEmpty() && PowahAPI.MAGMATIC_FLUIDS.containsKey((fluid = this.tank.getFluid()).getFluid()) && (fluidHeat = PowahAPI.getMagmaticFluidHeat(fluid.getFluid())) > 0 && this.perTick > 0) {
            int minStored = Math.min(this.tank.getFluidAmount(), 100);
            this.nextGen = this.nextGenCap = minStored * fluidHeat / 100;
            this.tank.drain(minStored, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

