/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.panel.solar;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import owmii.lib.util.Misc;
import owmii.lib.util.Time;
import owmii.powah.block.ITiles;
import owmii.powah.block.generator.GeneratorTile;

public class SolarPanelTile
extends GeneratorTile {
    private boolean canSeeSunLight;
    private int noSkyDelay;

    public SolarPanelTile(int capacity, int transfer, int perTick) {
        super(ITiles.SOLAR_PANEL, capacity, transfer, perTick);
    }

    public SolarPanelTile() {
        this(0, 0, 0);
    }

    @Override
    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.canSeeSunLight = compound.func_74767_n("CanSeeSunLight");
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a("CanSeeSunLight", this.canSeeSunLight);
        return super.writeSync(compound);
    }

    @Override
    protected void generate() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!Time.isDay((World)this.field_145850_b) && this.canSeeSunLight || (long)this.ticks % 40L == 0L) {
            this.canSeeSunLight = Time.isDay((World)this.field_145850_b) && Misc.canBlockSeeSky((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            this.markDirtyAndSync();
        }
        if (this.internal.isFull()) {
            return;
        }
        if (this.nextGen <= 0 && this.canSeeSunLight) {
            this.nextGen = this.perTick;
        }
    }

    public boolean canSeeSunLight() {
        return this.canSeeSunLight;
    }

    @Override
    public int getChargingSlots() {
        return 1;
    }

    @Override
    public boolean isEnergyPresent(@Nullable Direction side) {
        return side != Direction.UP;
    }
}

