/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.generator.reactor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import owmii.lib.block.TileBase;
import owmii.lib.inventory.ContainerBase;
import owmii.lib.item.BlockItemBase;
import owmii.lib.util.Energy;
import owmii.lib.util.Text;
import owmii.powah.block.generator.GeneratorBlock;
import owmii.powah.block.generator.reactor.ReactorTile;
import owmii.powah.inventory.IContainers;
import owmii.powah.inventory.ReactorContainer;
import owmii.powah.item.ReactorItem;

public class ReactorBlock
extends GeneratorBlock {
    public ReactorBlock(Block.Properties properties, int capacity, int transfer, int perTick) {
        super(properties, capacity, transfer, perTick);
    }

    @Override
    public BlockItemBase getBlockItem(Item.Properties properties, @Nullable ItemGroup group) {
        return new ReactorItem(this, properties, group);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ReactorTile(this.capacity, this.maxExtract, this.perTick);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.setCore(true);
            tile.getSideConfig().init();
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ReactorTile reactor;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof ReactorTile && (reactor = (ReactorTile)tileentity).isBuilt()) {
            if (reactor.isCore()) {
                boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)reactor.tank);
                if (result) {
                    reactor.markDirtyAndSync();
                    return true;
                }
                return super.func_220051_a(state, world, pos, player, hand, blockRayTraceResult);
            }
            if (reactor.core().isPresent()) {
                return reactor.getBlock().func_220051_a(state, world, reactor.getCorePos(), player, hand, blockRayTraceResult);
            }
        }
        return false;
    }

    @Nullable
    public ContainerBase getContainer(int id, PlayerInventory playerInventory, TileBase inv) {
        if (inv instanceof ReactorTile) {
            return new ReactorContainer(IContainers.REACTOR, id, playerInventory, (ReactorTile)inv);
        }
        return null;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ReactorTile) {
            ReactorTile tile = (ReactorTile)tileentity;
            tile.demolish();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public int stackSize() {
        return 64;
    }

    @Override
    public void tooltip(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Energy.getForgeEnergy((ItemStack)stack).ifPresent(storage -> {
            if (storage.getMaxEnergyStored() > 0) {
                tooltip.add(new TranslationTextComponent("info.powah.capacity", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)storage.getMaxEnergyStored())}).func_211708_a(TextFormatting.GRAY));
            }
            if (this.getBlock() instanceof GeneratorBlock) {
                tooltip.add(new TranslationTextComponent("info.powah.generation.factor", new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)((GeneratorBlock)this.getBlock()).perTick())}).func_211708_a(TextFormatting.GRAY));
            }
            int maxIn = this.getMaxReceive();
            int maxOut = this.getMaxExtract();
            tooltip.add(new TranslationTextComponent("info.powah.max.io", new Object[]{TextFormatting.DARK_GRAY + (maxIn == maxOut ? Text.numFormat((long)maxOut) : (maxIn == 0 || maxOut == 0 ? Text.numFormat((long)Math.max(maxIn, maxOut)) : Text.numFormat((long)maxIn) + "/" + Text.numFormat((long)maxOut)))}).func_211708_a(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent(""));
        });
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    @Override
    protected boolean hasLitProp() {
        return false;
    }
}

